/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.Float6D;
import mitiv.array.Float7D;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.FlatFloat6D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedFloat7D;
import mitiv.array.impl.StriddenFloat6D;
import mitiv.array.impl.StriddenFloat7D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.FloatGenerator;

public class FlatFloat7D
extends Float7D {
    static final int order = 1;
    final float[] data;
    final int dim1dim2;
    final int dim1dim2dim3;
    final int dim1dim2dim3dim4;
    final int dim1dim2dim3dim4dim5;
    final int dim1dim2dim3dim4dim5dim6;

    public FlatFloat7D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.data = new float[this.number];
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * n6;
    }

    public FlatFloat7D(int[] nArray) {
        super(nArray);
        this.data = new float[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
    }

    public FlatFloat7D(Shape shape) {
        super(shape);
        this.data = new float[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
    }

    public FlatFloat7D(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.checkSize(fArray);
        this.data = fArray;
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * n6;
    }

    public FlatFloat7D(float[] fArray, int[] nArray) {
        super(nArray);
        this.checkSize(fArray);
        this.data = fArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
    }

    public FlatFloat7D(float[] fArray, Shape shape) {
        super(shape);
        this.checkSize(fArray);
        this.data = fArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
        this.dim1dim2dim3dim4dim5dim6 = this.dim1dim2dim3dim4dim5 * this.dim6;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(float[] fArray) {
        if (fArray == null || fArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.dim1dim2dim3dim4dim5dim6 * n7 + this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final float get(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.data[this.dim1dim2dim3dim4dim5dim6 * n7 + this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, int n5, int n6, int n7, float f) {
        this.data[this.dim1dim2dim3dim4dim5dim6 * n7 + this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n] = f;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(float f) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = f;
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = floatGenerator.nextFloat();
        }
    }

    @Override
    public void increment(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + f;
        }
    }

    @Override
    public void decrement(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - f;
        }
    }

    @Override
    public void scale(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * f;
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = floatFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        floatScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            floatScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public float[] flatten(boolean bl) {
        if (bl) {
            float[] fArray = new float[this.number];
            System.arraycopy(this.data, 0, fArray, 0, this.number);
            return fArray;
        }
        return this.data;
    }

    @Override
    public float[] getData() {
        return this.data;
    }

    @Override
    public Float6D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim7)) == 0) {
            return new FlatFloat6D(this.data, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
        }
        return new StriddenFloat6D(this.data, this.dim1dim2dim3dim4dim5dim6 * n, 1, this.dim1, this.dim1dim2, this.dim1dim2dim3, this.dim1dim2dim3dim4, this.dim1dim2dim3dim4dim5, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Float6D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        if ((n2 = Helper.fixSliceIndex(n2, 7)) == 0) {
            n15 = Helper.fixIndex(n, this.dim1);
            n14 = this.dim1;
            n13 = this.dim1dim2;
            n12 = this.dim1dim2dim3;
            n11 = this.dim1dim2dim3dim4;
            n10 = this.dim1dim2dim3dim4dim5;
            n9 = this.dim1dim2dim3dim4dim5dim6;
            n8 = this.dim2;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 1) {
            n15 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n14 = 1;
            n13 = this.dim1dim2;
            n12 = this.dim1dim2dim3;
            n11 = this.dim1dim2dim3dim4;
            n10 = this.dim1dim2dim3dim4dim5;
            n9 = this.dim1dim2dim3dim4dim5dim6;
            n8 = this.dim1;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 2) {
            n15 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n14 = 1;
            n13 = this.dim1;
            n12 = this.dim1dim2dim3;
            n11 = this.dim1dim2dim3dim4;
            n10 = this.dim1dim2dim3dim4dim5;
            n9 = this.dim1dim2dim3dim4dim5dim6;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 3) {
            n15 = this.dim1dim2dim3 * Helper.fixIndex(n, this.dim4);
            n14 = 1;
            n13 = this.dim1;
            n12 = this.dim1dim2;
            n11 = this.dim1dim2dim3dim4;
            n10 = this.dim1dim2dim3dim4dim5;
            n9 = this.dim1dim2dim3dim4dim5dim6;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 4) {
            n15 = this.dim1dim2dim3dim4 * Helper.fixIndex(n, this.dim5);
            n14 = 1;
            n13 = this.dim1;
            n12 = this.dim1dim2;
            n11 = this.dim1dim2dim3;
            n10 = this.dim1dim2dim3dim4dim5;
            n9 = this.dim1dim2dim3dim4dim5dim6;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 5) {
            n15 = this.dim1dim2dim3dim4dim5 * Helper.fixIndex(n, this.dim6);
            n14 = 1;
            n13 = this.dim1;
            n12 = this.dim1dim2;
            n11 = this.dim1dim2dim3;
            n10 = this.dim1dim2dim3dim4;
            n9 = this.dim1dim2dim3dim4dim5dim6;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim7;
        } else {
            n15 = this.dim1dim2dim3dim4dim5dim6 * Helper.fixIndex(n, this.dim7);
            n14 = 1;
            n13 = this.dim1;
            n12 = this.dim1dim2;
            n11 = this.dim1dim2dim3;
            n10 = this.dim1dim2dim3dim4;
            n9 = this.dim1dim2dim3dim4dim5;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        }
        return new StriddenFloat6D(this.data, n15, n14, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Float7D view(Range range, Range range2, Range range3, Range range4, Range range5, Range range6, Range range7) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.dim1dim2dim3);
        CompiledRange compiledRange5 = new CompiledRange(range5, this.dim5, 0, this.dim1dim2dim3dim4);
        CompiledRange compiledRange6 = new CompiledRange(range6, this.dim6, 0, this.dim1dim2dim3dim4dim5);
        CompiledRange compiledRange7 = new CompiledRange(range7, this.dim7, 0, this.dim1dim2dim3dim4dim5dim6);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing() && compiledRange5.doesNothing() && compiledRange6.doesNothing() && compiledRange7.doesNothing()) {
            return this;
        }
        return new StriddenFloat7D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset() + compiledRange5.getOffset() + compiledRange6.getOffset() + compiledRange7.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange5.getStride(), compiledRange6.getStride(), compiledRange7.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber(), compiledRange5.getNumber(), compiledRange6.getNumber(), compiledRange7.getNumber());
    }

    @Override
    public Float7D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        int[] nArray8 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray9 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray10 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        int[] nArray11 = Helper.select(0, this.dim1dim2dim3, this.dim4, nArray4);
        int[] nArray12 = Helper.select(0, this.dim1dim2dim3dim4, this.dim5, nArray5);
        int[] nArray13 = Helper.select(0, this.dim1dim2dim3dim4dim5, this.dim6, nArray6);
        int[] nArray14 = Helper.select(0, this.dim1dim2dim3dim4dim5dim6, this.dim7, nArray7);
        return new SelectedFloat7D(this.data, nArray8, nArray9, nArray10, nArray11, nArray12, nArray13, nArray14);
    }

    @Override
    public Float1D as1D() {
        return new FlatFloat1D(this.data, this.number);
    }
}

