/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.FlatFloat2D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedFloat3D;
import mitiv.array.impl.StriddenFloat2D;
import mitiv.array.impl.StriddenFloat3D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.FloatGenerator;

public class FlatFloat3D
extends Float3D {
    static final int order = 1;
    final float[] data;
    final int dim1dim2;

    public FlatFloat3D(int n, int n2, int n3) {
        super(n, n2, n3);
        this.data = new float[this.number];
        this.dim1dim2 = n * n2;
    }

    public FlatFloat3D(int[] nArray) {
        super(nArray);
        this.data = new float[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatFloat3D(Shape shape) {
        super(shape);
        this.data = new float[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatFloat3D(float[] fArray, int n, int n2, int n3) {
        super(n, n2, n3);
        this.checkSize(fArray);
        this.data = fArray;
        this.dim1dim2 = n * n2;
    }

    public FlatFloat3D(float[] fArray, int[] nArray) {
        super(nArray);
        this.checkSize(fArray);
        this.data = fArray;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    public FlatFloat3D(float[] fArray, Shape shape) {
        super(shape);
        this.checkSize(fArray);
        this.data = fArray;
        this.dim1dim2 = this.dim1 * this.dim2;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(float[] fArray) {
        if (fArray == null || fArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3) {
        return this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final float get(int n, int n2, int n3) {
        return this.data[this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, float f) {
        this.data[this.dim1dim2 * n3 + this.dim1 * n2 + n] = f;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(float f) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = f;
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = floatGenerator.nextFloat();
        }
    }

    @Override
    public void increment(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + f;
        }
    }

    @Override
    public void decrement(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - f;
        }
    }

    @Override
    public void scale(float f) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * f;
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = floatFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        floatScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            floatScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public float[] flatten(boolean bl) {
        if (bl) {
            float[] fArray = new float[this.number];
            System.arraycopy(this.data, 0, fArray, 0, this.number);
            return fArray;
        }
        return this.data;
    }

    @Override
    public float[] getData() {
        return this.data;
    }

    @Override
    public Float2D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim3)) == 0) {
            return new FlatFloat2D(this.data, this.dim1, this.dim2);
        }
        return new StriddenFloat2D(this.data, this.dim1dim2 * n, 1, this.dim1, this.dim1, this.dim2);
    }

    @Override
    public Float2D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if ((n2 = Helper.fixSliceIndex(n2, 3)) == 0) {
            n7 = Helper.fixIndex(n, this.dim1);
            n6 = this.dim1;
            n5 = this.dim1dim2;
            n4 = this.dim2;
            n3 = this.dim3;
        } else if (n2 == 1) {
            n7 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n6 = 1;
            n5 = this.dim1dim2;
            n4 = this.dim1;
            n3 = this.dim3;
        } else {
            n7 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n6 = 1;
            n5 = this.dim1;
            n4 = this.dim1;
            n3 = this.dim2;
        }
        return new StriddenFloat2D(this.data, n7, n6, n5, n4, n3);
    }

    @Override
    public Float3D view(Range range, Range range2, Range range3) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing()) {
            return this;
        }
        return new StriddenFloat3D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber());
    }

    @Override
    public Float3D view(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray5 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray6 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        return new SelectedFloat3D(this.data, nArray4, nArray5, nArray6);
    }

    @Override
    public Float1D as1D() {
        return new FlatFloat1D(this.data, this.number);
    }
}

