/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.qr;

import org.ejml.alg.block.BlockMatrixOps;
import org.ejml.alg.block.BlockMultiplication;
import org.ejml.alg.block.decomposition.qr.BlockHouseHolder;
import org.ejml.alg.dense.decomposition.QRDecomposition;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;

public class BlockMatrix64HouseholderQR
implements QRDecomposition<BlockMatrix64F> {
    private BlockMatrix64F dataA;
    private BlockMatrix64F dataW = new BlockMatrix64F(1, 1);
    private BlockMatrix64F dataWTA = new BlockMatrix64F(1, 1);
    private int blockLength;
    private D1Submatrix64F A = new D1Submatrix64F();
    private D1Submatrix64F Y = new D1Submatrix64F();
    private D1Submatrix64F W = new D1Submatrix64F(this.dataW);
    private D1Submatrix64F WTA = new D1Submatrix64F(this.dataWTA);
    private double[] temp = new double[1];
    private double[] gammas = new double[1];
    private boolean saveW = false;

    public BlockMatrix64F getQR() {
        return this.dataA;
    }

    public void setSaveW(boolean bl) {
        this.saveW = bl;
    }

    @Override
    public BlockMatrix64F getQ(BlockMatrix64F blockMatrix64F, boolean bl) {
        blockMatrix64F = BlockMatrix64HouseholderQR.initializeQ(blockMatrix64F, this.dataA.numRows, this.dataA.numCols, this.blockLength, bl);
        this.applyQ(blockMatrix64F, true);
        return blockMatrix64F;
    }

    public static BlockMatrix64F initializeQ(BlockMatrix64F blockMatrix64F, int n, int n2, int n3, boolean bl) {
        int n4 = Math.min(n, n2);
        if (bl) {
            if (blockMatrix64F == null) {
                blockMatrix64F = new BlockMatrix64F(n, n4, n3);
                BlockMatrixOps.setIdentity(blockMatrix64F);
            } else {
                if (blockMatrix64F.numRows != n || blockMatrix64F.numCols != n4) {
                    throw new IllegalArgumentException("Unexpected matrix dimension. Found " + blockMatrix64F.numRows + " " + blockMatrix64F.numCols);
                }
                BlockMatrixOps.setIdentity(blockMatrix64F);
            }
        } else if (blockMatrix64F == null) {
            blockMatrix64F = new BlockMatrix64F(n, n, n3);
            BlockMatrixOps.setIdentity(blockMatrix64F);
        } else {
            if (blockMatrix64F.numRows != n || blockMatrix64F.numCols != n) {
                throw new IllegalArgumentException("Unexpected matrix dimension. Found " + blockMatrix64F.numRows + " " + blockMatrix64F.numCols);
            }
            BlockMatrixOps.setIdentity(blockMatrix64F);
        }
        return blockMatrix64F;
    }

    public void applyQ(BlockMatrix64F blockMatrix64F) {
        this.applyQ(blockMatrix64F, false);
    }

    public void applyQ(BlockMatrix64F blockMatrix64F, boolean bl) {
        int n = Math.min(this.dataA.numCols, this.dataA.numRows);
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(blockMatrix64F);
        this.W.row0 = 0;
        this.W.col0 = 0;
        this.Y.row1 = this.W.row1 = this.dataA.numRows;
        this.WTA.col0 = 0;
        this.WTA.row0 = 0;
        int n2 = n - n % this.blockLength;
        if (n2 == n) {
            n2 -= this.blockLength;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        for (int i = n2; i >= 0; i -= this.blockLength) {
            this.Y.col0 = i;
            this.Y.col1 = Math.min(this.Y.col0 + this.blockLength, this.dataA.numCols);
            this.Y.row0 = i;
            if (bl) {
                d1Submatrix64F.col0 = i;
            }
            d1Submatrix64F.row0 = i;
            this.setW();
            this.WTA.row1 = this.Y.col1 - this.Y.col0;
            this.WTA.col1 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
            this.WTA.original.reshape(this.WTA.row1, this.WTA.col1, false);
            if (!this.saveW) {
                BlockHouseHolder.computeW_Column(this.blockLength, this.Y, this.W, this.temp, this.gammas, this.Y.col0);
            }
            BlockHouseHolder.multTransA_vecCol(this.blockLength, this.Y, d1Submatrix64F, this.WTA);
            BlockMultiplication.multPlus(this.blockLength, this.W, this.WTA, d1Submatrix64F);
        }
    }

    public void applyQTran(BlockMatrix64F blockMatrix64F) {
        int n = Math.min(this.dataA.numCols, this.dataA.numRows);
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(blockMatrix64F);
        this.W.row0 = 0;
        this.W.col0 = 0;
        this.Y.row1 = this.W.row1 = this.dataA.numRows;
        this.WTA.col0 = 0;
        this.WTA.row0 = 0;
        for (int i = 0; i < n; i += this.blockLength) {
            this.Y.col0 = i;
            this.Y.col1 = Math.min(this.Y.col0 + this.blockLength, this.dataA.numCols);
            this.Y.row0 = i;
            d1Submatrix64F.row0 = i;
            this.setW();
            this.WTA.row0 = 0;
            this.WTA.col0 = 0;
            this.WTA.row1 = this.W.col1 - this.W.col0;
            this.WTA.col1 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
            this.WTA.original.reshape(this.WTA.row1, this.WTA.col1, false);
            if (!this.saveW) {
                BlockHouseHolder.computeW_Column(this.blockLength, this.Y, this.W, this.temp, this.gammas, this.Y.col0);
            }
            BlockMultiplication.multTransA(this.blockLength, this.W, d1Submatrix64F, this.WTA);
            BlockHouseHolder.multAdd_zeros(this.blockLength, this.Y, this.WTA, d1Submatrix64F);
        }
    }

    @Override
    public BlockMatrix64F getR(BlockMatrix64F blockMatrix64F, boolean bl) {
        int n = Math.min(this.dataA.numRows, this.dataA.numCols);
        if (blockMatrix64F == null) {
            blockMatrix64F = bl ? new BlockMatrix64F(n, this.dataA.numCols, this.blockLength) : new BlockMatrix64F(this.dataA.numRows, this.dataA.numCols, this.blockLength);
        } else if (bl ? blockMatrix64F.numCols != this.dataA.numCols || blockMatrix64F.numRows != n : blockMatrix64F.numCols != this.dataA.numCols || blockMatrix64F.numRows != this.dataA.numRows) {
            throw new IllegalArgumentException("Unexpected dimension.");
        }
        BlockMatrixOps.zeroTriangle(false, blockMatrix64F);
        BlockMatrixOps.copyTriangle(true, this.dataA, blockMatrix64F);
        return blockMatrix64F;
    }

    @Override
    public boolean decompose(BlockMatrix64F blockMatrix64F) {
        this.setup(blockMatrix64F);
        int n = Math.min(blockMatrix64F.numCols, blockMatrix64F.numRows);
        for (int i = 0; i < n; i += this.blockLength) {
            this.Y.col0 = i;
            this.Y.col1 = Math.min(blockMatrix64F.numCols, this.Y.col0 + this.blockLength);
            this.Y.row0 = i;
            if (!BlockHouseHolder.decomposeQR_block_col(this.blockLength, this.Y, this.gammas)) {
                return false;
            }
            this.updateA(this.A);
        }
        return true;
    }

    private void setup(BlockMatrix64F blockMatrix64F) {
        this.dataW.blockLength = this.blockLength = blockMatrix64F.blockLength;
        this.dataWTA.blockLength = this.blockLength;
        this.dataA = blockMatrix64F;
        this.A.original = this.dataA;
        int n = Math.min(this.blockLength, blockMatrix64F.numCols);
        this.dataW.reshape(blockMatrix64F.numRows, n, false);
        this.dataWTA.reshape(n, blockMatrix64F.numRows, false);
        this.Y.original = blockMatrix64F;
        this.Y.row1 = this.W.row1 = blockMatrix64F.numRows;
        if (this.temp.length < this.blockLength) {
            this.temp = new double[this.blockLength];
        }
        if (this.gammas.length < blockMatrix64F.numCols) {
            this.gammas = new double[blockMatrix64F.numCols];
        }
        if (this.saveW) {
            this.dataW.reshape(blockMatrix64F.numRows, blockMatrix64F.numCols, false);
        }
    }

    protected void updateA(D1Submatrix64F d1Submatrix64F) {
        this.setW();
        d1Submatrix64F.row0 = this.Y.row0;
        d1Submatrix64F.row1 = this.Y.row1;
        d1Submatrix64F.col0 = this.Y.col1;
        d1Submatrix64F.col1 = this.Y.original.numCols;
        this.WTA.row0 = 0;
        this.WTA.col0 = 0;
        this.WTA.row1 = this.W.col1 - this.W.col0;
        this.WTA.col1 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        this.WTA.original.reshape(this.WTA.row1, this.WTA.col1, false);
        if (d1Submatrix64F.col1 > d1Submatrix64F.col0) {
            BlockHouseHolder.computeW_Column(this.blockLength, this.Y, this.W, this.temp, this.gammas, this.Y.col0);
            BlockMultiplication.multTransA(this.blockLength, this.W, d1Submatrix64F, this.WTA);
            BlockHouseHolder.multAdd_zeros(this.blockLength, this.Y, this.WTA, d1Submatrix64F);
        } else if (this.saveW) {
            BlockHouseHolder.computeW_Column(this.blockLength, this.Y, this.W, this.temp, this.gammas, this.Y.col0);
        }
    }

    private void setW() {
        if (this.saveW) {
            this.W.col0 = this.Y.col0;
            this.W.col1 = this.Y.col1;
            this.W.row0 = this.Y.row0;
            this.W.row1 = this.Y.row1;
        } else {
            this.W.col1 = this.Y.col1 - this.Y.col0;
            this.W.row0 = this.Y.row0;
        }
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

