/*
 * Decompiled with CFR 0.152.
 */
package mitiv.tests;

import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.LinearConjugateGradient;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;

public class LinearConjGradTest {
    static double[][] arrA = new double[][]{{3.0, 2.0}, {2.0, 3.0}};
    static double[] arrX = new double[]{7.0, -13.0};

    public static void main(String[] stringArray) throws IncorrectSpaceException {
        DoubleShapedVectorSpace doubleShapedVectorSpace = new DoubleShapedVectorSpace(new int[]{arrX.length});
        DoubleShapedVector doubleShapedVector = doubleShapedVectorSpace.wrap(arrX);
        DoubleShapedVector doubleShapedVector2 = doubleShapedVectorSpace.create(0.0);
        DoubleShapedVector doubleShapedVector3 = doubleShapedVectorSpace.create();
        LinearOperator linearOperator = new LinearOperator(doubleShapedVectorSpace){

            @Override
            protected void _apply(Vector vector, Vector vector2, int n) {
                if (n != DIRECT && n != ADJOINT) {
                    throw new IllegalLinearOperationException();
                }
                double[] dArray = ((DoubleShapedVector)vector2).getData();
                double[] dArray2 = ((DoubleShapedVector)vector).getData();
                for (int i = 0; i < dArray2.length; ++i) {
                    dArray2[i] = ArrayOps.dot(arrA[i], dArray);
                }
            }
        };
        linearOperator.apply(doubleShapedVector3, doubleShapedVector);
        int n = 100;
        double d = 0.0;
        double d2 = 1.0E-6;
        int n2 = LinearConjugateGradient.solve(linearOperator, doubleShapedVector3, doubleShapedVector2, d, d2, n, true);
        if (n2 != 1) {
            System.out.println("NOT ENDED");
        }
        System.out.println("result: x = " + doubleShapedVector2 + ";");
    }
}

