/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.array.ArrayFactory;
import mitiv.array.ArrayUtils;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.base.Shape;
import mitiv.base.mapping.DifferentiableMapping;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.cost.DifferentiableGaussianLikelihood;
import mitiv.cost.HyperbolicTotalVariation;
import mitiv.cost.SmoothInverseProblem;
import mitiv.cost.WeightedData;
import mitiv.deconv.Convolution;
import mitiv.deconv.WeightedConvolutionCost;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.OptimTask;
import mitiv.utils.FFTUtils;

public class EdgePreservingDeconvolution
extends SmoothInverseProblem {
    private boolean updatePending = true;
    private boolean single;
    private ShapedVectorSpace dataSpace = null;
    private ShapedVectorSpace objectSpace = null;
    private Vector x = null;
    private ShapedArray data = null;
    private boolean writableData = false;
    private ShapedArray weights = null;
    private boolean writableWeights = false;
    private double sigma = Double.NaN;
    private double gamma = Double.NaN;
    private ShapedArray bads = null;
    private WeightedData weightedData = null;
    private ShapedArray psf = null;
    private boolean normalizePSF = false;
    private ShapedArray object = null;
    private Shape objectShape = null;
    private double padValue = Double.NaN;
    private double epsilon = 1.0;
    private double[] scale = new double[]{1.0};
    private boolean useNewCode = false;

    private void forceRestart() {
        this.weightedData = null;
        this.updatePending = true;
    }

    public boolean getUseNewCode() {
        return this.useNewCode;
    }

    public void setUseNewCode(boolean bl) {
        if (this.useNewCode != bl) {
            this.useNewCode = bl;
            this.forceRestart();
        }
    }

    public boolean getForceSinglePrecision() {
        return this.single;
    }

    public void setForceSinglePrecision(boolean bl) {
        if (this.single != bl) {
            this.single = bl;
            this.forceRestart();
        }
    }

    public ShapedArray getData() {
        return this.data;
    }

    public void setData(ShapedArray shapedArray, boolean bl) {
        if (this.data != shapedArray) {
            this.data = shapedArray;
            this.writableData = bl;
            this.forceRestart();
        }
    }

    public void setData(ShapedArray shapedArray) {
        this.setData(shapedArray, false);
    }

    public ShapedArray getWeights() {
        return this.weights;
    }

    public void setWeights(ShapedArray shapedArray, boolean bl) {
        if (this.weights != shapedArray) {
            this.weights = shapedArray;
            this.writableWeights = bl;
            this.forceRestart();
        }
    }

    public void setWeights(ShapedArray shapedArray) {
        this.setWeights(shapedArray, false);
    }

    public ShapedArray getBads() {
        return this.bads;
    }

    public void setBads(ShapedArray shapedArray) {
        if (this.bads != shapedArray) {
            this.bads = shapedArray;
            this.forceRestart();
        }
    }

    public ShapedArray getPSF() {
        return this.psf;
    }

    public void setPSF(ShapedArray shapedArray) {
        this.setPSF(shapedArray, false);
    }

    public void setPSF(ShapedArray shapedArray, boolean bl) {
        if (this.psf != shapedArray) {
            this.psf = shapedArray;
            this.normalizePSF = bl;
            this.forceRestart();
        }
    }

    public double getEdgeThreshold() {
        return this.epsilon;
    }

    public void setEdgeThreshold(double d) {
        if (this.nonfinite(d) || d <= 0.0) {
            EdgePreservingDeconvolution.error("Edge threshold must be strictly positive");
        }
        if (this.epsilon != d) {
            this.epsilon = d;
            this.forceRestart();
        }
    }

    public void setScale(double ... dArray) {
        this.scale = dArray;
    }

    public double[] getScale() {
        return this.scale;
    }

    public ShapedArray getSolution() {
        return this.object;
    }

    @Override
    public ShapedVector getBestSolution() {
        return (ShapedVector)super.getBestSolution();
    }

    public void setInitialSolution(ShapedArray shapedArray) {
        if (this.object != shapedArray) {
            this.object = shapedArray;
            this.forceRestart();
            this.resetIteration();
        }
    }

    public Shape getObjectShape() {
        return this.objectShape;
    }

    public void setObjectShape(Shape shape) {
        if (shape == null != (this.objectShape == null) || shape != null && this.objectShape != null && !shape.equals(this.objectShape)) {
            this.objectShape = shape;
            this.forceRestart();
        }
    }

    public double getFillValue() {
        return this.padValue;
    }

    public void setFillValue(double d) {
        this.padValue = d;
    }

    public void setObjectShape(int[] nArray) {
        this.setObjectShape(new Shape(nArray));
    }

    private void update() {
        double d;
        int n;
        int n2;
        Object object;
        if (this.data == null) {
            EdgePreservingDeconvolution.error("No data specified");
        }
        int n3 = this.data.getRank();
        Shape shape = this.data.getShape();
        if (this.weights != null && !this.weights.getShape().equals(shape)) {
            EdgePreservingDeconvolution.error("Weights and data must have the same dimensions");
        }
        if (this.bads != null && !this.bads.getShape().equals(shape)) {
            EdgePreservingDeconvolution.error("Mask of invalid data must have the same dimensions as the data");
        }
        if (this.psf != null && this.psf.getRank() != n3) {
            EdgePreservingDeconvolution.error("PSF and data must have the same number of dimensions");
        }
        if (this.object != null && this.object.getRank() != n3) {
            EdgePreservingDeconvolution.error("Object and data must have the same number of dimensions");
        }
        if (this.objectShape != null && this.objectShape.rank() != n3) {
            EdgePreservingDeconvolution.error("Given object shape must the same number of dimensions as the data");
        }
        if (this.debug) {
            System.out.format("mu: %.2g, epsilon: %.2g\n", this.getRegularizationLevel(), this.getEdgeThreshold());
        }
        int n4 = this.single ? 4 : (this.data.getType() == 5 || this.psf != null && this.psf.getType() == 5 || this.weights != null && this.weights.getType() == 5 || this.object != null && this.object.getType() == 5 ? 5 : 4);
        if (this.psf == null) {
            this.objectShape = shape;
        } else {
            object = this.psf.getShape();
            if (this.objectShape != null) {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.objectShape.dimension(n2) < shape.dimension(n2)) {
                        EdgePreservingDeconvolution.error("Given object dimensions must be at least those of the data");
                    }
                    if (object == null || this.objectShape.dimension(n2) >= ((Shape)object).dimension(n2)) continue;
                    EdgePreservingDeconvolution.error("Given object dimensions must be at least those of the PSF");
                }
            } else {
                int[] nArray = new int[n3];
                for (n = 0; n < n3; ++n) {
                    int n5 = shape.dimension(n) + ((Shape)object).dimension(n) - 1;
                    if (this.object != null) {
                        n5 = Math.max(n5, this.object.getDimension(n));
                    }
                    nArray[n] = FFTUtils.bestDimension(n5);
                }
                this.objectShape = new Shape(nArray);
            }
        }
        if (n4 == 4) {
            if (this.dataSpace == null) {
                this.dataSpace = new FloatShapedVectorSpace(shape);
            }
            if (this.objectSpace == null) {
                this.objectSpace = new FloatShapedVectorSpace(this.objectShape);
            }
        } else {
            if (this.dataSpace == null) {
                this.dataSpace = new DoubleShapedVectorSpace(shape);
            }
            if (this.objectSpace == null) {
                this.objectSpace = new DoubleShapedVectorSpace(this.objectShape);
            }
        }
        if (this.psf == null) {
            this.weightedData = new WeightedData(this.dataSpace);
            this.setWeightsAndData(this.weightedData);
            this.setLikelihood(this.weightedData);
        } else if (this.useNewCode) {
            this.weightedData = new WeightedData(this.dataSpace);
            this.setWeightsAndData(this.weightedData);
            object = Convolution.build(this.objectSpace, this.dataSpace);
            ((Convolution)object).setPSF(this.psf, this.normalizePSF);
            this.setLikelihood(new DifferentiableGaussianLikelihood(this.weightedData, (DifferentiableMapping)object));
        } else {
            object = WeightedConvolutionCost.build(this.objectSpace, this.dataSpace);
            this.setWeightsAndData((WeightedData)object);
            ((WeightedConvolutionCost)object).setPSF(this.psf, this.normalizePSF);
            this.setLikelihood((DifferentiableCostFunction)object);
            this.weightedData = object;
        }
        if (this.object == null) {
            d = this.computePadValue();
            this.object = ArrayFactory.create(n4, this.objectShape);
            if (this.single) {
                ((FloatArray)this.object).fill((float)d);
            } else {
                ((DoubleArray)this.object).fill(d);
            }
            if (this.debug) {
                System.err.format("Create initial array with value %g\n", d);
            }
        } else {
            d = 0.0;
            for (n = 0; n < n3; ++n) {
                if (this.objectShape.dimension(n) <= this.object.getDimension(n)) continue;
                d = this.computePadValue();
                break;
            }
            if (this.debug) {
                System.err.format("Pad initial array with value %g\n", d);
            }
            this.object = ArrayUtils.extract(this.object, this.objectShape, d);
        }
        HyperbolicTotalVariation hyperbolicTotalVariation = new HyperbolicTotalVariation(this.objectSpace, this.epsilon);
        if (this.scale.length == 1) {
            hyperbolicTotalVariation.setScale(this.scale[0]);
        } else {
            hyperbolicTotalVariation.setScale(this.scale);
        }
        this.setRegularization(hyperbolicTotalVariation);
        n2 = this.object.getType() != n4 || !this.object.isFlat() ? 1 : 0;
        this.x = this.objectSpace.create(this.object, false);
        if (n2 != 0) {
            this.object = n4 == 4 ? ArrayFactory.wrap(((FloatShapedVector)this.x).getData(), this.objectShape) : ArrayFactory.wrap(((DoubleShapedVector)this.x).getData(), this.objectShape);
        }
        this.updatePending = false;
    }

    public OptimTask start() {
        return this.start(false);
    }

    public OptimTask start(boolean bl) {
        if (this.updatePending) {
            this.update();
        }
        return super.start(this.x, bl);
    }

    public OptimTask iterate() {
        if (this.updatePending) {
            return this.start();
        }
        return super.iterate(this.x);
    }

    private static void error(String string) {
        throw new IllegalArgumentException(string);
    }

    private boolean nonfinite(double d) {
        return Double.isInfinite(d) || Double.isNaN(d);
    }

    public double getDetectorNoise() {
        return this.sigma;
    }

    public void setDetectorNoise(double d) {
        this.sigma = d;
    }

    public double getDetectorGain() {
        return this.gamma;
    }

    public void setDetectorGain(double d) {
        this.gamma = d;
    }

    private void setWeightsAndData(WeightedData weightedData) {
        weightedData.setData(this.data, this.writableData);
        if (this.weights != null) {
            if (!EdgePreservingDeconvolution.isnan(this.sigma) || !EdgePreservingDeconvolution.isnan(this.gamma)) {
                System.err.println("Warning: noise model parameters are ignored when weights are specified.");
            }
            weightedData.setWeights(this.weights, this.writableWeights);
        } else {
            double d;
            double d2;
            if (EdgePreservingDeconvolution.isnan(this.sigma)) {
                if (!EdgePreservingDeconvolution.isnan(this.gamma)) {
                    System.err.println("Warning: linear noise model parameter is ignored if affine noise model parameter is not specified");
                }
                d2 = 0.0;
                d = 1.0;
            } else if (EdgePreservingDeconvolution.isnan(this.gamma)) {
                d2 = 0.0;
                d = EdgePreservingDeconvolution.abs2(this.sigma);
            } else {
                d2 = 1.0 / this.gamma;
                d = EdgePreservingDeconvolution.abs2(this.sigma / this.gamma);
            }
            System.err.format("alpha = %g, beta = %g\n", d2, d);
            weightedData.computeWeightsFromData(d2, d);
        }
        if (this.bads != null) {
            weightedData.markBadData(this.bads);
        }
    }

    private double computePadValue() {
        double d;
        if (EdgePreservingDeconvolution.isnan(this.padValue)) {
            d = this.weightedData.getWeightedMean();
            if (this.psf != null && !this.normalizePSF) {
                d /= EdgePreservingDeconvolution.sum(this.psf);
            }
        } else {
            d = this.padValue;
        }
        return d;
    }

    private static double sum(ShapedArray shapedArray) {
        double d = 0.0;
        if (shapedArray != null) {
            switch (shapedArray.getType()) {
                case 0: {
                    d = ((ByteArray)shapedArray).sum();
                    break;
                }
                case 1: {
                    d = ((ShortArray)shapedArray).sum();
                    break;
                }
                case 2: {
                    d = ((IntArray)shapedArray).sum();
                    break;
                }
                case 3: {
                    d = ((LongArray)shapedArray).sum();
                    break;
                }
                case 4: {
                    d = ((FloatArray)shapedArray).sum();
                    break;
                }
                case 5: {
                    d = ((DoubleArray)shapedArray).sum();
                }
            }
        }
        return d;
    }

    private static final boolean isnan(double d) {
        return Double.isNaN(d);
    }

    private static final double abs2(double d) {
        return d * d;
    }
}

