/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class UnidataTdsDataPathRemapper {
    private static HashMap<String, Remapper> map;

    private static InputStream getInputStream(String resourceName, Class originClass) {
        InputStream s;
        while (originClass != null && (s = originClass.getResourceAsStream(resourceName)) == null) {
            originClass = originClass.getSuperclass();
        }
        ClassLoader cl = UnidataTdsDataPathRemapper.class.getClassLoader();
        s = cl.getResourceAsStream(resourceName);
        if (s != null) {
            return s;
        }
        File f = new File(resourceName);
        if (f.exists()) {
            try {
                s = new FileInputStream(f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (s != null) {
            return s;
        }
        return s;
    }

    private void initMap() {
        List<UrlRemapperBean> beans = this.readUrlRemapFile("resources/thredds/4p2to4p3Remap.xml");
        map = this.makeMapBeans(beans);
    }

    public List<String> getMappedUrlPaths(String oldUrlPath) {
        List<String> result = this.getMappedUrlPaths(oldUrlPath, null);
        return result;
    }

    public List<String> getMappedUrlPaths(String oldUrlPath, String urlType) {
        Remapper mbean;
        ArrayList<String> result = new ArrayList<String>();
        if (map == null) {
            this.initMap();
        }
        if ((mbean = map.get(oldUrlPath)) != null && mbean.newUrls != null) {
            result.add(mbean.newUrl);
            return result;
        }
        if (urlType != null && mbean != null) {
            for (UrlRemapperBean r : mbean.newUrls) {
                if (!r.getUrlType().equals(urlType)) continue;
                result.add(r.newUrlPath);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UrlRemapperBean> readUrlRemapFile(String path) {
        ArrayList<UrlRemapperBean> arrayList;
        ArrayList<UrlRemapperBean> beans = new ArrayList<UrlRemapperBean>(1000);
        InputStream is = null;
        try {
            is = UnidataTdsDataPathRemapper.getInputStream(path, null);
            if (is == null) {
                System.out.println("Cant read file " + path);
                List<UrlRemapperBean> list = null;
                return list;
            }
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(is);
            Element root = doc.getRootElement();
            List dsElems = root.getChildren("urlMap");
            for (Element dsElem : dsElems) {
                String dsType = dsElem.getAttributeValue("type");
                List params = dsElem.getChildren("urlPath");
                for (Element elem : params) {
                    String oldUrlPath = elem.getAttributeValue("oldUrlPath");
                    String newUrlPath = elem.getAttributeValue("newUrlPath");
                    beans.add(new UrlRemapperBean(dsType, oldUrlPath, newUrlPath));
                }
            }
            arrayList = beans;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            List<UrlRemapperBean> list = null;
            return list;
        }
        catch (JDOMException e) {
            e.printStackTrace();
            List<UrlRemapperBean> list = null;
            return list;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return arrayList;
    }

    private String getNewName(HashMap<String, Remapper> map, String urlType, String oldUrlPath) {
        Remapper mbean = map.get(oldUrlPath);
        if (mbean == null) {
            return null;
        }
        if (mbean.newUrl != null) {
            return mbean.newUrl;
        }
        for (UrlRemapperBean r : mbean.newUrls) {
            if (!r.getUrlType().equals(urlType)) continue;
            return r.getNewUrlPath();
        }
        return null;
    }

    private HashMap<String, Remapper> makeMapBeans(List<UrlRemapperBean> vbeans) {
        HashMap<String, Remapper> map = new HashMap<String, Remapper>(200);
        for (UrlRemapperBean vbean : vbeans) {
            Remapper mbean = (Remapper)map.get(vbean.getOldUrlPath());
            if (mbean == null) {
                mbean = new Remapper(vbean.getOldUrlPath());
                map.put(vbean.getOldUrlPath(), mbean);
            }
            mbean.add(vbean);
        }
        for (Remapper rmap : map.values()) {
            rmap.finish();
        }
        return map;
    }

    public static void main(String[] args) throws IOException {
        UnidataTdsDataPathRemapper u = new UnidataTdsDataPathRemapper();
        List<String> result1 = u.getMappedUrlPaths("fmrc/NCEP/GFS/Alaska_191km/files/");
        assert (result1.size() == 1);
        assert (result1.get(0) == "grib/NCEP/GFS/Alaska_191km/files/");
        System.out.println(result1.toString());
        List<String> result2 = u.getMappedUrlPaths("fmrc/NCEP/GFS/Alaska_191km/files/", "files");
        assert (result1 == result2);
        System.out.println(result2.toString());
    }

    private class Remapper {
        String oldUrl;
        String newUrl;
        List<UrlRemapperBean> newUrls = new ArrayList<UrlRemapperBean>();
        HashMap<String, UrlRemapperBean> newUrlMap = new HashMap();

        public Remapper() {
        }

        public Remapper(String oldUrl) {
            this.oldUrl = oldUrl;
        }

        void add(UrlRemapperBean vbean) {
            this.newUrlMap.put(vbean.getNewUrlPath(), vbean);
            this.newUrls.add(vbean);
        }

        void finish() {
            if (this.newUrlMap.values().size() == 1) {
                this.newUrl = this.newUrls.get(0).getNewUrlPath();
            }
        }

        public int getCount() {
            return this.newUrls.size();
        }

        public String getOldUrl() {
            return this.oldUrl;
        }
    }

    public static class UrlRemapperBean
    implements Comparable<UrlRemapperBean> {
        String urlType;
        String oldUrlPath;
        String newUrlPath;

        public UrlRemapperBean() {
        }

        public UrlRemapperBean(String dsType, String oldUrlPath, String newUrlPath) {
            this.urlType = dsType;
            this.oldUrlPath = oldUrlPath;
            this.newUrlPath = newUrlPath;
        }

        public String getUrlType() {
            return this.urlType;
        }

        public String getOldUrlPath() {
            return this.oldUrlPath;
        }

        public String getNewUrlPath() {
            return this.newUrlPath;
        }

        @Override
        public int compareTo(UrlRemapperBean o) {
            return this.newUrlPath.compareTo(o.getNewUrlPath());
        }
    }
}

