/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.Float1D;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.StriddenFloat1D;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public class FloatScalar
extends Scalar
implements FloatArray {
    final float[] data;
    final int offset;
    final boolean flat;

    public FloatScalar() {
        this.data = new float[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public FloatScalar create() {
        return new FloatScalar();
    }

    public FloatScalar(float[] fArray, int n) {
        this.data = fArray;
        this.offset = n;
        this.flat = n == 0 && fArray.length == 1;
        this.checkSanity();
    }

    public static FloatScalar wrap(float[] fArray, int n) {
        return new FloatScalar(fArray, n);
    }

    public FloatScalar(float f) {
        this.data = new float[]{f};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final float get() {
        return this.data[this.offset];
    }

    public final void set(float f) {
        this.data[this.offset] = f;
    }

    @Override
    public final void fill(float f) {
        this.data[this.offset] = f;
    }

    @Override
    public final void fill(FloatGenerator floatGenerator) {
        this.data[this.offset] = floatGenerator.nextFloat();
    }

    @Override
    public final void increment(float f) {
        int n = this.offset;
        this.data[n] = this.data[n] + f;
    }

    @Override
    public final void decrement(float f) {
        int n = this.offset;
        this.data[n] = this.data[n] - f;
    }

    @Override
    public final void scale(float f) {
        int n = this.offset;
        this.data[n] = this.data[n] * f;
    }

    @Override
    public final void map(FloatFunction floatFunction) {
        this.data[this.offset] = floatFunction.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(FloatScanner floatScanner) {
        floatScanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final float[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        return new float[]{this.data[this.offset]};
    }

    @Override
    public final float[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public float min() {
        return this.data[this.offset];
    }

    @Override
    public float max() {
        return this.data[this.offset];
    }

    @Override
    public float[] getMinAndMax() {
        float[] fArray = new float[2];
        this.getMinAndMax(fArray);
        return fArray;
    }

    @Override
    public void getMinAndMax(float[] fArray) {
        float f;
        fArray[0] = f = this.data[this.offset];
        fArray[1] = f;
    }

    @Override
    public float sum() {
        return this.data[this.offset];
    }

    @Override
    public double average() {
        return this.data[this.offset];
    }

    @Override
    public final ByteArray toByte() {
        return new ByteScalar((byte)this.data[this.offset]);
    }

    @Override
    public final ShortArray toShort() {
        return new ShortScalar((short)this.data[this.offset]);
    }

    @Override
    public final IntArray toInt() {
        return new IntScalar((int)this.data[this.offset]);
    }

    @Override
    public final LongArray toLong() {
        return new LongScalar((long)this.data[this.offset]);
    }

    @Override
    public final FloatArray toFloat() {
        return this;
    }

    @Override
    public final DoubleArray toDouble() {
        return new DoubleScalar(this.data[this.offset]);
    }

    @Override
    public final Float1D as1D() {
        if (this.offset == 0) {
            return new FlatFloat1D(this.data, 1);
        }
        return new StriddenFloat1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray shapedArray) {
        if (!shape.equals(shapedArray.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (shapedArray.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)shapedArray).get();
                break;
            }
            case 1: {
                this.data[this.offset] = ((ShortScalar)shapedArray).get();
                break;
            }
            case 2: {
                this.data[this.offset] = ((IntScalar)shapedArray).get();
                break;
            }
            case 3: {
                this.data[this.offset] = ((LongScalar)shapedArray).get();
                break;
            }
            case 4: {
                this.data[this.offset] = ((FloatScalar)shapedArray).get();
                break;
            }
            case 5: {
                this.data[this.offset] = (float)((DoubleScalar)shapedArray).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector shapedVector) {
        if (!shape.equals(shapedVector.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = (float)shapedVector.get(0);
    }

    @Override
    public final FloatScalar copy() {
        return new FloatScalar(this.data[this.offset]);
    }
}

