/*
 * Decompiled with CFR 0.152.
 */
package com.imaging100x.tracker;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import mmcorej.Configuration;
import mmcorej.MMCoreJ;
import org.micromanager.api.MMPlugin;
import org.micromanager.api.ScriptInterface;
import org.micromanager.metadata.AcquisitionData;
import org.micromanager.metadata.MMAcqDataException;
import org.micromanager.utils.Annotator;
import org.micromanager.utils.MMFrame;
import org.micromanager.utils.TextUtils;

public class TrackerControl
extends MMFrame
implements MMPlugin {
    private JTextField nameField_;
    private JTextField rootField_;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private static final long serialVersionUID = 1L;
    private JTextField resField_;
    private JTextField offsetField_;
    private JTextField pixelSizeField_;
    private JTextField intervalField_;
    private ScriptInterface app_;
    private int intervalMs_ = 1000;
    private double pixelSizeUm_ = 1.0;
    private int resolutionPix_ = 5;
    private int offsetPix_ = 100;
    private Timer timer_;
    private ImageProcessor ipPrevious_ = null;
    private ImageProcessor ipCurrent_ = null;
    private String stage_ = "XYStage";
    private Roi roi_;
    private ImageStack stack_;
    private boolean mirrorX_ = false;
    private boolean mirrorY_ = false;
    private boolean rotate_ = false;
    private Preferences prefs_;
    private MMRect limits_ = new MMRect();
    private AcquisitionData acq_;
    private int imageCounter_ = 0;
    private static final String RESOLUTION_PIX = "resolution_pix";
    private static final String OFFSET_PIX = "offset_pix";
    private static final String INTERVAL_MS = "interval_pix";
    private static final String DISK_RECORDING = "disk_recording";
    private static final String ROOT = "root";
    private static final String NAME = "name";
    private static final String TRACK_Y = "TRACK_X_UM";
    private static final String TRACK_X = "TRACK_Y_UM";
    private static final String TRACK_DY = "TRACK_DX_PIX";
    private static final String TRACK_DX = "TRACK_DY_PIX";
    private static final String D = "STEP_UM";
    private static final String V = "VELOCITY_UMPS";
    private static final String L = "TOTAL_TRAVEL_UM";
    private static final String RECT_X = "RECT_X";
    private static final String RECT_Y = "RECT_Y";
    private static final String RECT_W = "RECT_W";
    private static final String RECT_H = "RECT_H";
    private JLabel labelTopLeft_;
    private JLabel labelBottomRight_;
    private JRadioButton stackRadioButton_;
    private JRadioButton image5dRadioButton_;
    private JLabel speedLabel_;
    private double distUm_;
    private JButton topLeftButton_;
    private JButton bottomRightButton_;

    public TrackerControl() {
        this.prefs_ = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                TrackerControl.this.resolutionPix_ = TrackerControl.this.prefs_.getInt(TrackerControl.RESOLUTION_PIX, TrackerControl.this.resolutionPix_);
                TrackerControl.this.offsetPix_ = TrackerControl.this.prefs_.getInt(TrackerControl.OFFSET_PIX, TrackerControl.this.offsetPix_);
                TrackerControl.this.intervalMs_ = TrackerControl.this.prefs_.getInt(TrackerControl.INTERVAL_MS, TrackerControl.this.intervalMs_);
                TrackerControl.this.image5dRadioButton_.setSelected(TrackerControl.this.prefs_.getBoolean(TrackerControl.DISK_RECORDING, TrackerControl.this.image5dRadioButton_.isSelected()));
                TrackerControl.this.rootField_.setText(TrackerControl.this.prefs_.get(TrackerControl.ROOT, ""));
                TrackerControl.this.nameField_.setText(TrackerControl.this.prefs_.get(TrackerControl.NAME, ""));
                TrackerControl.this.resField_.setText(Integer.toString(TrackerControl.this.resolutionPix_));
                TrackerControl.this.offsetField_.setText(Integer.toString(TrackerControl.this.offsetPix_));
                TrackerControl.this.pixelSizeField_.setText(Double.toString(TrackerControl.this.pixelSizeUm_));
                TrackerControl.this.intervalField_.setText(Integer.toString(TrackerControl.this.intervalMs_));
            }

            public void windowClosing(WindowEvent windowEvent) {
                TrackerControl.this.prefs_.putInt(TrackerControl.RESOLUTION_PIX, TrackerControl.this.resolutionPix_);
                TrackerControl.this.prefs_.putInt(TrackerControl.OFFSET_PIX, TrackerControl.this.offsetPix_);
                TrackerControl.this.prefs_.putInt(TrackerControl.INTERVAL_MS, TrackerControl.this.intervalMs_);
                TrackerControl.this.prefs_.putBoolean(TrackerControl.DISK_RECORDING, TrackerControl.this.image5dRadioButton_.isSelected());
                TrackerControl.this.prefs_.put(TrackerControl.ROOT, TrackerControl.this.rootField_.getText());
                TrackerControl.this.prefs_.put(TrackerControl.NAME, TrackerControl.this.nameField_.getText());
            }
        });
        this.setTitle("MM Tracker");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setBounds(100, 100, 412, 346);
        JLabel jLabel = new JLabel();
        jLabel.setText("Interval [ms]");
        jLabel.setBounds(10, 10, 76, 14);
        this.getContentPane().add(jLabel);
        this.intervalField_ = new JTextField();
        this.intervalField_.setBounds(10, 30, 84, 19);
        this.getContentPane().add(this.intervalField_);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerControl.this.intervalMs_ = Integer.parseInt(TrackerControl.this.intervalField_.getText());
                TrackerControl.this.pixelSizeUm_ = Double.parseDouble(TrackerControl.this.pixelSizeField_.getText());
                TrackerControl.this.offsetPix_ = Integer.parseInt(TrackerControl.this.offsetField_.getText());
                TrackerControl.this.resolutionPix_ = Integer.parseInt(TrackerControl.this.resField_.getText());
                TrackerControl.this.ipPrevious_ = null;
                TrackerControl.this.ipCurrent_ = null;
                TrackerControl.this.stack_ = null;
                TrackerControl.this.timer_.setDelay(TrackerControl.this.intervalMs_);
                TrackerControl.this.track();
            }
        });
        jButton.setText("Track!");
        jButton.setBounds(303, 10, 93, 23);
        this.getContentPane().add(jButton);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Pixel size [um]");
        jLabel2.setBounds(10, 55, 110, 14);
        this.getContentPane().add(jLabel2);
        this.pixelSizeField_ = new JTextField();
        this.pixelSizeField_.setBounds(10, 75, 84, 19);
        this.getContentPane().add(this.pixelSizeField_);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Offset [pixels]");
        jLabel3.setBounds(140, 10, 122, 14);
        this.getContentPane().add(jLabel3);
        this.offsetField_ = new JTextField();
        this.offsetField_.setBounds(140, 30, 93, 19);
        this.getContentPane().add(this.offsetField_);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Resolution [pixels]");
        jLabel4.setBounds(140, 55, 129, 14);
        this.getContentPane().add(jLabel4);
        this.resField_ = new JTextField();
        this.resField_.setBounds(140, 75, 93, 19);
        this.getContentPane().add(this.resField_);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerControl.this.stopTracking();
            }
        });
        jButton2.setText("Stop");
        jButton2.setBounds(303, 39, 93, 26);
        this.getContentPane().add(jButton2);
        this.topLeftButton_ = new JButton();
        this.topLeftButton_.setText("Top Left");
        this.topLeftButton_.setBounds(10, 140, 106, 26);
        this.getContentPane().add(this.topLeftButton_);
        this.bottomRightButton_ = new JButton();
        this.bottomRightButton_.setText("Bottom Right");
        this.bottomRightButton_.setBounds(10, 170, 106, 26);
        this.getContentPane().add(this.bottomRightButton_);
        this.labelTopLeft_ = new JLabel();
        this.labelTopLeft_.setText("not set");
        this.labelTopLeft_.setBounds(140, 145, 93, 16);
        this.getContentPane().add(this.labelTopLeft_);
        this.labelBottomRight_ = new JLabel();
        this.labelBottomRight_.setText("not set");
        this.labelBottomRight_.setBounds(140, 175, 93, 16);
        this.getContentPane().add(this.labelBottomRight_);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("XY Stage Limits:");
        jLabel5.setBounds(10, 120, 217, 16);
        this.getContentPane().add(jLabel5);
        this.stackRadioButton_ = new JRadioButton();
        this.buttonGroup.add(this.stackRadioButton_);
        this.stackRadioButton_.setText("Stack (in-memory)");
        this.stackRadioButton_.setBounds(253, 185, 143, 24);
        this.getContentPane().add(this.stackRadioButton_);
        this.stackRadioButton_.setSelected(true);
        this.image5dRadioButton_ = new JRadioButton();
        this.buttonGroup.add(this.image5dRadioButton_);
        this.image5dRadioButton_.setText("Image5D (disk)");
        this.image5dRadioButton_.setBounds(253, 203, 129, 24);
        this.getContentPane().add(this.image5dRadioButton_);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Sequence data:");
        jLabel6.setBounds(259, 170, 123, 16);
        this.getContentPane().add(jLabel6);
        this.rootField_ = new JTextField();
        this.rootField_.setBounds(64, 263, 286, 20);
        this.getContentPane().add(this.rootField_);
        this.nameField_ = new JTextField();
        this.nameField_.setBounds(64, 289, 286, 20);
        this.getContentPane().add(this.nameField_);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Root:");
        jLabel7.setBounds(10, 265, 29, 16);
        this.getContentPane().add(jLabel7);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Name:");
        jLabel8.setBounds(10, 291, 48, 16);
        this.getContentPane().add(jLabel8);
        JButton jButton3 = new JButton();
        jButton3.setText("...");
        jButton3.setBounds(358, 260, 38, 26);
        this.getContentPane().add(jButton3);
        JButton jButton4 = new JButton();
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerControl.this.limits_.clear();
                TrackerControl.this.labelBottomRight_.setText("not set");
                TrackerControl.this.labelTopLeft_.setText("not set");
            }
        });
        jButton4.setText("Clear");
        jButton4.setBounds(10, 202, 106, 26);
        this.getContentPane().add(jButton4);
        this.speedLabel_ = new JLabel();
        this.speedLabel_.setBorder(new BevelBorder(1));
        this.speedLabel_.setBounds(10, 100, 386, 19);
        this.getContentPane().add(this.speedLabel_);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Data location");
        jLabel9.setBounds(10, 241, 143, 16);
        this.getContentPane().add(jLabel9);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TrackerControl.this.snapSingleImage();
                TrackerControl.this.processOneFrame(true);
            }
        };
        this.timer_ = new Timer(this.intervalMs_, actionListener);
        this.timer_.stop();
    }

    protected void browse() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setCurrentDirectory(new File(this.rootField_.getText()));
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            this.rootField_.setText(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void track() {
        this.imageCounter_ = 0;
        this.distUm_ = 0.0;
        IJ.write((String)("Tracking started at " + GregorianCalendar.getInstance().getTime()));
        if (this.image5dRadioButton_.isSelected()) {
            this.acq_ = new AcquisitionData();
            try {
                this.acq_.createNew(this.nameField_.getText(), this.rootField_.getText(), true);
                this.acq_.setDimensions(0, 1, 1);
                this.acq_.setImagePhysicalDimensions((int)this.app_.getMMCore().getImageWidth(), (int)this.app_.getMMCore().getImageHeight(), (int)this.app_.getMMCore().getBytesPerPixel());
                this.acq_.setImageIntervalMs((double)this.intervalMs_);
                this.acq_.setPixelSizeUm(this.pixelSizeUm_);
            }
            catch (MMAcqDataException mMAcqDataException) {
                IJ.write((String)mMAcqDataException.getMessage());
            }
        } else {
            this.acq_ = null;
        }
        this.timer_.start();
    }

    public void stopTracking() {
        IJ.write((String)("Tracking stopped at " + GregorianCalendar.getInstance().getTime()));
        this.timer_.stop();
        if (this.acq_ == null) {
            this.createStack();
        }
    }

    private boolean snapSingleImage() {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.write((String)"There are no windows open.\nTracker plugin is now exiting.");
            this.timer_.stop();
            return false;
        }
        this.roi_ = imagePlus.getRoi();
        if (this.roi_ == null || this.roi_.getType() != 0) {
            IJ.write((String)"Rectangular roi requred.");
            this.timer_.stop();
            return false;
        }
        try {
            this.app_.getMMCore().snapImage();
            Object object = this.app_.getMMCore().getImage();
            imagePlus.getProcessor().setPixels(object);
            imagePlus.updateAndDraw();
            ImageWindow imageWindow = imagePlus.getWindow();
            imageWindow.getCanvas().paint(imageWindow.getCanvas().getGraphics());
            this.ipCurrent_ = imagePlus.getProcessor();
            if (this.acq_ == null && this.stack_ == null) {
                this.stack_ = new ImageStack(imagePlus.getProcessor().getWidth(), imagePlus.getHeight());
            }
            if (this.acq_ != null) {
                IJ.write((String)("Frame: " + this.imageCounter_));
                this.acq_.insertImage(object, this.imageCounter_, 0, 0);
                Configuration configuration = this.app_.getMMCore().getSystemStateCache();
                Annotator.setStateMetadata((AcquisitionData)this.acq_, (int)this.imageCounter_, (int)0, (int)0, (Configuration)configuration);
            } else {
                this.stack_.addSlice(Integer.toString(this.stack_.getSize() + 1), imagePlus.getProcessor());
            }
        }
        catch (Exception exception) {
            IJ.error((String)exception.getMessage());
            this.timer_.stop();
            return false;
        }
        return true;
    }

    private void createStack() {
        ImagePlus imagePlus = new ImagePlus("Tracker stack", this.stack_);
        imagePlus.show();
        imagePlus.draw();
    }

    private void processOneFrame(boolean bl) {
        double d;
        double d2;
        double d3;
        block17: {
            if (this.ipPrevious_ == null) {
                this.ipPrevious_ = this.ipCurrent_;
                return;
            }
            int n = 0;
            int n2 = 0;
            Rectangle rectangle = this.roi_.getBoundingRect();
            double d4 = rectangle.width * rectangle.height;
            double d5 = 0.0;
            for (int i = -this.offsetPix_; i < this.offsetPix_; i += this.resolutionPix_) {
                for (int j = -this.offsetPix_; j < this.offsetPix_; j += this.resolutionPix_) {
                    d3 = 0.0;
                    double d6 = 0.0;
                    d2 = 0.0;
                    for (int k = 0; k < rectangle.height; ++k) {
                        for (int i2 = 0; i2 < rectangle.width; ++i2) {
                            int n3 = this.ipPrevious_.getPixel(rectangle.x + i2 + j, rectangle.y + k + i);
                            int n4 = this.ipCurrent_.getPixel(rectangle.x + i2 + j, rectangle.y + k + i);
                            d3 += (double)n3 * (double)n4;
                            d6 += (double)n3;
                            d2 += (double)n4;
                        }
                    }
                    d3 /= d4;
                    if (!((d3 /= (d6 /= d4) * (d2 /= d4)) > d5)) continue;
                    d5 = d3;
                    n = i;
                    n2 = j;
                }
            }
            this.ipPrevious_ = this.ipCurrent_;
            d = (double)n2 * this.pixelSizeUm_;
            d3 = (double)n * this.pixelSizeUm_;
            if (bl) {
                try {
                    double[] dArray = new double[1];
                    double[] dArray2 = new double[1];
                    this.app_.getMMCore().getXYPosition(this.stage_, dArray, dArray2);
                    if (this.acq_ != null) {
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, TRACK_X, dArray[0]);
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, TRACK_Y, dArray2[0]);
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, TRACK_DX, n2);
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, TRACK_DY, n);
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, RECT_X, rectangle.x);
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, RECT_Y, rectangle.y);
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, RECT_W, rectangle.width);
                        this.acq_.setImageValue(this.imageCounter_, 0, 0, RECT_H, rectangle.height);
                    }
                    if (this.mirrorX_) {
                        d = -d;
                    }
                    if (this.mirrorY_) {
                        d3 = -d3;
                    }
                    if (this.rotate_) {
                        d2 = d;
                        d3 = d = d3;
                    }
                    d2 = dArray[0] - d;
                    double d7 = dArray2[0] - d3;
                    if (this.limits_.isValid() && this.limits_.isWithin(d2, d7) || !this.limits_.isValid()) {
                        this.app_.getMMCore().setXYPosition(this.stage_, d2, d7);
                        this.app_.getMMCore().waitForDevice(this.stage_);
                        this.app_.getMMCore().getXYPosition(this.stage_, dArray, dArray2);
                        IJ.write((String)(dArray[0] + "," + dArray2[0]));
                        break block17;
                    }
                    IJ.write((String)"Skipped. Stage limits reached.");
                }
                catch (Exception exception) {
                    IJ.error((String)exception.getMessage());
                    this.timer_.stop();
                }
            } else {
                this.roi_.setLocation(rectangle.x + n2, rectangle.y + n);
            }
        }
        double d8 = Math.sqrt(d * d + d3 * d3);
        this.distUm_ += d8;
        d2 = d8 / (double)this.intervalMs_ * 1000.0;
        this.speedLabel_.setText("n=" + this.imageCounter_ + ", t=" + TextUtils.FMT2.format((double)this.imageCounter_ * (double)this.intervalMs_ / 1000.0) + " s, d=" + TextUtils.FMT2.format(d8) + " um, l=" + TextUtils.FMT2.format(this.distUm_) + " um, v=" + TextUtils.FMT2.format(d2) + " um/s");
        if (this.acq_ != null) {
            try {
                this.acq_.setImageValue(this.imageCounter_, 0, 0, D, d8);
                this.acq_.setImageValue(this.imageCounter_, 0, 0, V, d2);
                this.acq_.setImageValue(this.imageCounter_, 0, 0, L, this.distUm_);
            }
            catch (MMAcqDataException mMAcqDataException) {
                IJ.write((String)mMAcqDataException.getMessage());
                this.timer_.stop();
            }
        }
        ++this.imageCounter_;
    }

    public void setApp(ScriptInterface scriptInterface) {
        this.app_ = scriptInterface;
        this.initialize();
    }

    private void initialize() {
        if (this.app_ == null) {
            return;
        }
        this.stage_ = this.app_.getMMCore().getXYStageDevice();
        this.pixelSizeUm_ = this.app_.getMMCore().getPixelSizeUm();
        String string = this.app_.getMMCore().getCameraDevice();
        try {
            this.mirrorX_ = this.app_.getMMCore().getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorX()).equals("1");
            this.mirrorY_ = this.app_.getMMCore().getProperty(string, MMCoreJ.getG_Keyword_Transpose_MirrorY()).equals("1");
            this.rotate_ = this.app_.getMMCore().getProperty(string, MMCoreJ.getG_Keyword_Transpose_SwapXY()).equals("1");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.topLeftButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                try {
                    TrackerControl.this.app_.getMMCore().getXYPosition(TrackerControl.this.stage_, dArray, dArray2);
                    ((TrackerControl)TrackerControl.this).limits_.xmin = dArray[0];
                    ((TrackerControl)TrackerControl.this).limits_.ymin = dArray2[0];
                    TrackerControl.this.labelTopLeft_.setText(Double.toString(dArray[0]) + "," + Double.toString(dArray2[0]));
                    TrackerControl.this.limits_.normalize();
                }
                catch (Exception exception) {
                    IJ.error((String)exception.getMessage());
                }
            }
        });
        this.bottomRightButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                try {
                    TrackerControl.this.app_.getMMCore().getXYPosition(TrackerControl.this.stage_, dArray, dArray2);
                    ((TrackerControl)TrackerControl.this).limits_.xmax = dArray[0];
                    ((TrackerControl)TrackerControl.this).limits_.ymax = dArray2[0];
                    TrackerControl.this.labelBottomRight_.setText(Double.toString(dArray[0]) + "," + Double.toString(dArray2[0]));
                    TrackerControl.this.limits_.normalize();
                }
                catch (Exception exception) {
                    IJ.error((String)exception.getMessage());
                }
            }
        });
    }

    private class MMRect {
        public double xmin = 0.0;
        public double xmax = 0.0;
        public double ymin = 0.0;
        public double ymax = 0.0;

        public boolean isValid() {
            return this.xmax - this.xmin > 0.0 && this.ymax - this.ymin > 0.0;
        }

        public boolean isWithin(double d, double d2) {
            return d > this.xmin && d < this.xmax && d2 > this.ymin && d2 < this.ymax;
        }

        public void clear() {
            this.xmin = 0.0;
            this.xmax = 0.0;
            this.ymin = 0.0;
            this.ymax = 0.0;
        }

        public void normalize() {
            double d;
            if (this.xmin > this.xmax) {
                d = this.xmin;
                this.xmin = this.xmax;
                this.xmax = d;
            }
            if (this.ymin > this.ymax) {
                d = this.ymin;
                this.ymin = this.ymax;
                this.ymax = d;
            }
        }
    }
}

