/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import cern.colt.ConcurrencyUtils;
import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.ref.DoubleAbstractHistogram1D;
import hep.aida.tdouble.ref.DoubleFixedAxis;
import hep.aida.tdouble.ref.DoubleHistogram1DContents;
import hep.aida.tdouble.ref.DoubleVariableAxis;
import java.util.concurrent.Future;

public class DoubleHistogram1D
extends DoubleAbstractHistogram1D
implements DoubleIHistogram1D {
    private static final long serialVersionUID = 1L;
    private double[] errors;
    private double[] heights;
    private int[] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double mean;
    private double rms;

    public DoubleHistogram1D(String title, double[] edges) {
        this(title, new DoubleVariableAxis(edges));
    }

    public DoubleHistogram1D(String title, DoubleIAxis axis) {
        super(title);
        this.xAxis = axis;
        int bins = axis.bins();
        this.entries = new int[bins + 2];
        this.heights = new double[bins + 2];
        this.errors = new double[bins + 2];
    }

    public DoubleHistogram1D(String title, int bins, double min, double max) {
        this(title, new DoubleFixedAxis(bins, min, max));
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int index) {
        return this.entries[this.map(index)];
    }

    @Override
    public double binError(int index) {
        return Math.sqrt(this.errors[this.map(index)]);
    }

    @Override
    public double binHeight(int index) {
        return this.heights[this.map(index)];
    }

    @Override
    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(double x) {
        int bin;
        int n = bin = this.map(this.xAxis.coordToIndex(x));
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + 1.0;
        int n3 = bin;
        this.errors[n3] = this.errors[n3] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.mean += x;
        this.rms += x * x;
    }

    @Override
    public void fill(double x, double weight) {
        int bin;
        int n = bin = this.map(this.xAxis.coordToIndex(x));
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + weight;
        int n3 = bin;
        this.errors[n3] = this.errors[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.mean += x * weight;
        this.rms += x * weight * weight;
    }

    @Override
    public void fill_2D(final double[] data, int rows, final int columns, final int zero, final int rowStride, final int columnStride) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, rows);
            Future[] futures = new Future[nthreads];
            int k = rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int i;
                        double[] errors_loc = new double[DoubleHistogram1D.this.errors.length];
                        double[] heights_loc = new double[DoubleHistogram1D.this.heights.length];
                        int[] entries_loc = new int[DoubleHistogram1D.this.entries.length];
                        int nEntry_loc = 0;
                        double sumWeight_loc = 0.0;
                        double sumWeightSquared_loc = 0.0;
                        double mean_loc = 0.0;
                        double rms_loc = 0.0;
                        int idx = zero + firstRow * rowStride;
                        int r = firstRow;
                        while (r < lastRow) {
                            i = idx;
                            int c = 0;
                            while (c < columns) {
                                int bin;
                                int n = bin = DoubleHistogram1D.this.map(DoubleHistogram1D.this.xAxis.coordToIndex(data[i]));
                                entries_loc[n] = entries_loc[n] + 1;
                                int n2 = bin;
                                heights_loc[n2] = heights_loc[n2] + 1.0;
                                int n3 = bin;
                                errors_loc[n3] = errors_loc[n3] + 1.0;
                                ++nEntry_loc;
                                sumWeight_loc += 1.0;
                                sumWeightSquared_loc += 1.0;
                                mean_loc += data[i];
                                rms_loc += data[i] * data[i];
                                i += columnStride;
                                ++c;
                            }
                            idx += rowStride;
                            ++r;
                        }
                        1 var14_11 = this;
                        synchronized (var14_11) {
                            i = 0;
                            while (i < DoubleHistogram1D.this.entries.length) {
                                double[] dArray = DoubleHistogram1D.this.errors;
                                int n = i;
                                dArray[n] = dArray[n] + errors_loc[i];
                                double[] dArray2 = DoubleHistogram1D.this.heights;
                                int n4 = i;
                                dArray2[n4] = dArray2[n4] + heights_loc[i];
                                int[] nArray = DoubleHistogram1D.this.entries;
                                int n5 = i;
                                nArray[n5] = nArray[n5] + entries_loc[i];
                                ++i;
                            }
                            DoubleHistogram1D doubleHistogram1D = DoubleHistogram1D.this;
                            doubleHistogram1D.nEntry = doubleHistogram1D.nEntry + nEntry_loc;
                            DoubleHistogram1D doubleHistogram1D2 = DoubleHistogram1D.this;
                            doubleHistogram1D2.sumWeight = doubleHistogram1D2.sumWeight + sumWeight_loc;
                            DoubleHistogram1D doubleHistogram1D3 = DoubleHistogram1D.this;
                            doubleHistogram1D3.sumWeightSquared = doubleHistogram1D3.sumWeightSquared + sumWeightSquared_loc;
                            DoubleHistogram1D doubleHistogram1D4 = DoubleHistogram1D.this;
                            doubleHistogram1D4.mean = doubleHistogram1D4.mean + mean_loc;
                            DoubleHistogram1D doubleHistogram1D5 = DoubleHistogram1D.this;
                            doubleHistogram1D5.rms = doubleHistogram1D5.rms + rms_loc;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < rows) {
                int i = idx;
                int c = 0;
                while (c < columns) {
                    int bin;
                    int n = bin = this.map(this.xAxis.coordToIndex(data[i]));
                    this.entries[n] = this.entries[n] + 1;
                    int n2 = bin;
                    this.heights[n2] = this.heights[n2] + 1.0;
                    int n3 = bin;
                    this.errors[n3] = this.errors[n3] + 1.0;
                    ++this.nEntry;
                    this.sumWeight += 1.0;
                    this.sumWeightSquared += 1.0;
                    this.mean += data[i];
                    this.rms += data[i] * data[i];
                    i += columnStride;
                    ++c;
                }
                idx += rowStride;
                ++r;
            }
        }
    }

    @Override
    public void fill_2D(final double[] data, final double[] weights, int rows, final int columns, final int zero, final int rowStride, final int columnStride) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, rows);
            Future[] futures = new Future[nthreads];
            int k = rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int i;
                        int idx = zero + firstRow * rowStride;
                        double[] errors_loc = new double[DoubleHistogram1D.this.errors.length];
                        double[] heights_loc = new double[DoubleHistogram1D.this.heights.length];
                        int[] entries_loc = new int[DoubleHistogram1D.this.entries.length];
                        int nEntry_loc = 0;
                        double sumWeight_loc = 0.0;
                        double sumWeightSquared_loc = 0.0;
                        double mean_loc = 0.0;
                        double rms_loc = 0.0;
                        int r = firstRow;
                        while (r < lastRow) {
                            i = idx;
                            int c = 0;
                            while (c < columns) {
                                int bin = DoubleHistogram1D.this.map(DoubleHistogram1D.this.xAxis.coordToIndex(data[i]));
                                int widx = r * columns + c;
                                double w2 = weights[widx] * weights[widx];
                                int n = bin;
                                entries_loc[n] = entries_loc[n] + 1;
                                int n2 = bin;
                                heights_loc[n2] = heights_loc[n2] + weights[widx];
                                int n3 = bin;
                                errors_loc[n3] = errors_loc[n3] + w2;
                                ++nEntry_loc;
                                sumWeight_loc += weights[widx];
                                sumWeightSquared_loc += w2;
                                mean_loc += data[i] * weights[widx];
                                rms_loc += data[i] * w2;
                                i += columnStride;
                                ++c;
                            }
                            idx += rowStride;
                            ++r;
                        }
                        2 var14_11 = this;
                        synchronized (var14_11) {
                            i = 0;
                            while (i < DoubleHistogram1D.this.entries.length) {
                                double[] dArray = DoubleHistogram1D.this.errors;
                                int n = i;
                                dArray[n] = dArray[n] + errors_loc[i];
                                double[] dArray2 = DoubleHistogram1D.this.heights;
                                int n4 = i;
                                dArray2[n4] = dArray2[n4] + heights_loc[i];
                                int[] nArray = DoubleHistogram1D.this.entries;
                                int n5 = i;
                                nArray[n5] = nArray[n5] + entries_loc[i];
                                ++i;
                            }
                            DoubleHistogram1D doubleHistogram1D = DoubleHistogram1D.this;
                            doubleHistogram1D.nEntry = doubleHistogram1D.nEntry + nEntry_loc;
                            DoubleHistogram1D doubleHistogram1D2 = DoubleHistogram1D.this;
                            doubleHistogram1D2.sumWeight = doubleHistogram1D2.sumWeight + sumWeight_loc;
                            DoubleHistogram1D doubleHistogram1D3 = DoubleHistogram1D.this;
                            doubleHistogram1D3.sumWeightSquared = doubleHistogram1D3.sumWeightSquared + sumWeightSquared_loc;
                            DoubleHistogram1D doubleHistogram1D4 = DoubleHistogram1D.this;
                            doubleHistogram1D4.mean = doubleHistogram1D4.mean + mean_loc;
                            DoubleHistogram1D doubleHistogram1D5 = DoubleHistogram1D.this;
                            doubleHistogram1D5.rms = doubleHistogram1D5.rms + rms_loc;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = zero;
            int r = 0;
            while (r < rows) {
                int i = idx;
                int c = 0;
                while (c < columns) {
                    int bin = this.map(this.xAxis.coordToIndex(data[i]));
                    int widx = r * columns + c;
                    double w2 = weights[widx] * weights[widx];
                    int n = bin;
                    this.entries[n] = this.entries[n] + 1;
                    int n2 = bin;
                    this.heights[n2] = this.heights[n2] + weights[widx];
                    int n3 = bin;
                    this.errors[n3] = this.errors[n3] + w2;
                    ++this.nEntry;
                    this.sumWeight += weights[widx];
                    this.sumWeightSquared += w2;
                    this.mean += data[i] * weights[widx];
                    this.rms += data[i] * w2;
                    i += columnStride;
                    ++c;
                }
                idx += rowStride;
                ++r;
            }
        }
    }

    public DoubleHistogram1DContents getContents() {
        return new DoubleHistogram1DContents(this.entries, this.heights, this.errors, this.nEntry, this.sumWeight, this.sumWeightSquared, this.mean, this.rms);
    }

    @Override
    public double mean() {
        return this.mean / this.sumWeight;
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.entries.length) {
            this.entries[i] = 0;
            this.heights[i] = 0.0;
            this.errors[i] = 0.0;
            ++i;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.mean = 0.0;
        this.rms = 0.0;
    }

    @Override
    public double rms() {
        return Math.sqrt(this.rms / this.sumWeight - this.mean * this.mean / this.sumWeight / this.sumWeight);
    }

    public void setContents(DoubleHistogram1DContents contents) {
        this.entries = contents.getEntries();
        this.heights = contents.getHeights();
        this.errors = contents.getErrors();
        this.nEntry = contents.getNentry();
        this.sumWeight = contents.getSumWeight();
        this.sumWeightSquared = contents.getSumWeightSquared();
        this.mean = contents.getMean();
        this.rms = contents.getRms();
    }

    void setContents(int[] entries, double[] heights, double[] errors) {
        this.entries = entries;
        this.heights = heights;
        this.errors = errors;
        int i = 0;
        while (i < entries.length) {
            this.nEntry += entries[i];
            this.sumWeight += heights[i];
            ++i;
        }
        this.sumWeightSquared = Double.NaN;
        this.mean = Double.NaN;
        this.rms = Double.NaN;
    }
}

