/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.test;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import org.netlib.blas.Dgemm;
import org.netlib.lapack.Dlange;

public class DgesvTest {
    public static void main(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 4) {
            System.out.print(" Proper Usage is : java edu.emory.mathcs.jplasma.test.DgesvTest N LDA NRHS LDB with \n - N : the size of the matrix \n - LDA : leading dimension of the matrix A \n - NRHS : number of RHS \n - LDB : leading dimension of the matrix B \n");
            System.exit(1);
        }
        int n3 = Integer.parseInt(stringArray[0]);
        int n4 = Integer.parseInt(stringArray[1]);
        int n5 = Integer.parseInt(stringArray[2]);
        int n6 = Integer.parseInt(stringArray[3]);
        double[] dArray = new double[n4 * n3];
        double[] dArray2 = new double[n4 * n3];
        double[] dArray3 = new double[n6 * n5];
        double[] dArray4 = new double[n6 * n5];
        Dplasma.plasma_Init(n3, n3, n5);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d = 0.5 - Math.random();
                dArray2[n4 * n + n2] = d;
                dArray[n4 * n + n2] = d;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                double d = 0.5 - Math.random();
                dArray4[n6 * n + n2] = d;
                dArray3[n6 * n + n2] = d;
            }
        }
        double[] dArray5 = Dplasma.plasma_Allocate_L(n3, n3);
        int[] nArray = Dplasma.plasma_Allocate_IPIV(n3, n3);
        Dplasma.plasma_DGESV(n3, n5, dArray2, 0, n4, dArray5, 0, nArray, 0, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        double d = 1.0E-10;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGESV ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n3));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int n7 = DgesvTest.check_solution(n3, n5, dArray, n4, dArray3, dArray4, n6, d);
        if (n7 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGESV ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGESV ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d2 = 0.5 - Math.random();
                dArray2[n4 * n2 + n] = d2;
                dArray[n4 * n2 + n] = d2;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                double d3 = 0.5 - Math.random();
                dArray4[n6 * n + n2] = d3;
                dArray3[n6 * n + n2] = d3;
            }
        }
        Dplasma.plasma_Init(n3, n3, n5);
        dArray5 = Dplasma.plasma_Allocate_L(n3, n3);
        nArray = Dplasma.plasma_Allocate_IPIV(n3, n3);
        Dplasma.plasma_DGETRF(n3, n3, dArray2, 0, n4, dArray5, 0, nArray, 0);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DGETRS(n3, n5, n3, dArray2, 0, n4, dArray5, 0, nArray, 0, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGETRF + DGETRS ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n3));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        n7 = DgesvTest.check_solution(n3, n5, dArray, n4, dArray3, dArray4, n6, d);
        if (n7 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DGETRS ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DGETRS ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                double d4 = 0.5 - Math.random();
                dArray2[n4 * n2 + n] = d4;
                dArray[n4 * n2 + n] = d4;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                double d5 = 0.5 - Math.random();
                dArray4[n6 * n + n2] = d5;
                dArray3[n6 * n + n2] = d5;
            }
        }
        Dplasma.plasma_Init(n3, n3, n5);
        dArray5 = Dplasma.plasma_Allocate_L(n3, n3);
        nArray = Dplasma.plasma_Allocate_IPIV(n3, n3);
        Dplasma.plasma_DGETRF(n3, n3, dArray2, 0, n4, dArray5, 0, nArray, 0);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DTRSMPL(n3, n5, n3, dArray2, 0, n4, dArray5, 0, nArray, 0, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(n3, n3, n5);
        Dplasma.plasma_DTRSM(141, 121, 111, 131, n3, n5, dArray2, 0, n4, dArray4, 0, n6);
        Dplasma.plasma_Finalize();
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGETRF + DTRSMPL + DTRSM  ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", n3, n3));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", d));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        n7 = DgesvTest.check_solution(n3, n5, dArray, n4, dArray3, dArray4, n6, d);
        if (n7 == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DTRSMPL + DTRSM ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DTRSMPL + DTRSM ... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int check_solution(int n, int n2, double[] dArray, int n3, double[] dArray2, double[] dArray3, int n4, double d) {
        int n5;
        String string = "I";
        double[] dArray4 = new double[n];
        double d2 = 1.0;
        double d3 = -1.0;
        double d4 = Dlange.dlange((String)string, (int)n, (int)n2, (double[])dArray3, (int)0, (int)n4, (double[])dArray4, (int)0);
        double d5 = Dlange.dlange((String)string, (int)n, (int)n, (double[])dArray, (int)0, (int)n3, (double[])dArray4, (int)0);
        double d6 = Dlange.dlange((String)string, (int)n, (int)n2, (double[])dArray2, (int)0, (int)n4, (double[])dArray4, (int)0);
        Dgemm.dgemm((String)"N", (String)"N", (int)n, (int)n2, (int)n, (double)d2, (double[])dArray, (int)0, (int)n3, (double[])dArray3, (int)0, (int)n4, (double)d3, (double[])dArray2, (int)0, (int)n4);
        double d7 = Dlange.dlange((String)string, (int)n, (int)n2, (double[])dArray2, (int)0, (int)n4, (double[])dArray4, (int)0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", d7 / ((d5 * d4 + d6) * (double)n * d)));
        if (d7 / ((d5 * d4 + d6) * (double)n * d) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            n5 = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            n5 = 0;
        }
        return n5;
    }
}

