/*
 * Decompiled with CFR 0.152.
 */
package mitiv.tests;

public class MinPack1Tests {
    public static final int TEST18_NMAX = 50;
    public static final int SUCCESS = 0;
    public static final int FAILURE = -1;
    protected static final double TPI = Math.PI * 2;
    protected static final double AP = 1.0E-5;
    protected static final double BP = 1.0;
    private static final double[] um_y = new double[]{9.0E-4, 0.0044, 0.0175, 0.054, 0.1295, 0.242, 0.3521, 0.3989, 0.3521, 0.242, 0.1295, 0.054, 0.0175, 0.0044, 9.0E-4};

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[1];
        int[] nArray = new int[]{0, 3, 6, 3, 2, 3, 1, 2, 1, 1, 2, 4, 3, 1, 2, 4, 2, 4, 1};
        int[] nArray2 = new int[]{0, 3, 6, 3, 2, 3, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2, 4, 3, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2, 4, 50};
        int[] nArray3 = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 1, 1, 1};
        for (int i = 1; i < nArray.length; ++i) {
            int n = nArray[i] == nArray2[i] ? nArray[i] : (nArray2[i] < Integer.MAX_VALUE ? nArray2[i] : MinPack1Tests.roundUp(20, nArray3[i]));
            int n2 = MinPack1Tests.umck(stringArray2, n, i);
            if (n2 != 0) {
                System.out.println("FAILURE prob = " + i + " (with n = " + n + "): " + stringArray2[0]);
                continue;
            }
            System.out.println("SUCCESS prob = " + i + " (with n = " + n + "): " + stringArray2[0]);
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            MinPack1Tests.umipt(dArray, i, 1.0);
            double d = MinPack1Tests.umobj(dArray, i);
            System.out.println("   initial cost: " + d);
            MinPack1Tests.umgrd(dArray, dArray2, i);
            double d2 = 0.01;
            for (int j = 0; j < n; ++j) {
                int n3 = j;
                dArray[n3] = dArray[n3] - d2 * dArray2[j];
            }
            double d3 = MinPack1Tests.umobj(dArray, i);
            System.out.println("   cost after a small descent step: " + d3);
        }
    }

    private static int roundUp(int n, int n2) {
        return (n + (n2 - 1)) / n2 * n2;
    }

    private static int check(boolean bl, String[] stringArray, String string, String string2) {
        if (bl) {
            if (stringArray != null && stringArray.length >= 1) {
                stringArray[0] = string;
            }
            return 0;
        }
        if (stringArray != null && stringArray.length >= 1) {
            stringArray[0] = string2;
        }
        return -1;
    }

    public static int umck(String[] stringArray, int n, int n2) {
        int n3;
        switch (n2) {
            case 1: {
                n3 = MinPack1Tests.check(n == 3, stringArray, "Helical valley function.", "N must be 3 for problem #1");
                break;
            }
            case 2: {
                n3 = MinPack1Tests.check(n == 6, stringArray, "Biggs exp6 function.", "N must be 6 for problem #2");
                break;
            }
            case 3: {
                n3 = MinPack1Tests.check(n == 3, stringArray, "Gaussian function.", "N must be 3 for problem #3");
                break;
            }
            case 4: {
                n3 = MinPack1Tests.check(n == 2, stringArray, "Powell badly scaled function.", "N must be 2 for problem #4");
                break;
            }
            case 5: {
                n3 = MinPack1Tests.check(n == 3, stringArray, "Box 3-dimensional function.", "N must be 3 for problem #5");
                break;
            }
            case 6: {
                n3 = MinPack1Tests.check(n >= 1, stringArray, "Variably dimensioned function.", "N must be >= 1 in problem #6");
                break;
            }
            case 7: {
                n3 = MinPack1Tests.check(n >= 2, stringArray, "Watson function.", "N may be 2 or greater but is usually 6 or 9 for problem #7");
                break;
            }
            case 8: {
                n3 = MinPack1Tests.check(n >= 1, stringArray, "Penalty function I.", "N must be >= 1 in problem #8");
                break;
            }
            case 9: {
                n3 = MinPack1Tests.check(n >= 1, stringArray, "Penalty function II.", "N must be >= 1 in problem #9");
                break;
            }
            case 10: {
                n3 = MinPack1Tests.check(n == 2, stringArray, "Brown badly scaled function.", "N must be 2 for problem #10");
                break;
            }
            case 11: {
                n3 = MinPack1Tests.check(n == 4, stringArray, "Brown and Dennis function.", "N must be 4 for problem #11");
                break;
            }
            case 12: {
                n3 = MinPack1Tests.check(n == 3, stringArray, "Gulf research and development function.", "N must be 3 for problem #12");
                break;
            }
            case 13: {
                n3 = MinPack1Tests.check(n >= 1, stringArray, "Trigonometric function.", "N must be >= 1 in problem #13");
                break;
            }
            case 14: {
                n3 = MinPack1Tests.check(n >= 1 && n % 2 == 0, stringArray, "Extended Rosenbrock function.", "N must be a multiple of 2 in problem #14");
                break;
            }
            case 15: {
                n3 = MinPack1Tests.check(n >= 1 && n % 4 == 0, stringArray, "Extended Powell function.", "N must be a multiple of 4 in problem #15");
                break;
            }
            case 16: {
                n3 = MinPack1Tests.check(n == 2, stringArray, "Beale function.", "N must be 2 for problem #16");
                break;
            }
            case 17: {
                n3 = MinPack1Tests.check(n == 4, stringArray, "Wood function.", "N must be 4 for problem #17");
                break;
            }
            case 18: {
                n3 = MinPack1Tests.check(n >= 1 && n <= 50, stringArray, "Chebyquad function.", "N must be <= 50 for problem #18");
                break;
            }
            default: {
                n3 = -1;
                if (stringArray == null || stringArray.length < 1) break;
                stringArray[0] = "PROB must be an integer between 1 and 18";
            }
        }
        return n3;
    }

    public static void umipt(double[] dArray, int n, double d) {
        block32: {
            int n2;
            int n3 = dArray.length;
            switch (n) {
                case 1: {
                    dArray[0] = -1.0;
                    dArray[1] = 0.0;
                    dArray[2] = 0.0;
                    break;
                }
                case 2: {
                    dArray[0] = 1.0;
                    dArray[1] = 2.0;
                    dArray[2] = 1.0;
                    dArray[3] = 1.0;
                    dArray[4] = 1.0;
                    dArray[5] = 1.0;
                    break;
                }
                case 3: {
                    dArray[0] = 0.4;
                    dArray[1] = 1.0;
                    dArray[2] = 0.0;
                    break;
                }
                case 4: {
                    dArray[0] = 0.0;
                    dArray[1] = 1.0;
                    break;
                }
                case 5: {
                    dArray[0] = 0.0;
                    dArray[1] = 10.0;
                    dArray[2] = 20.0;
                    break;
                }
                case 6: {
                    double d2 = 1.0 / (double)n3;
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[n2] = 1.0 - (double)(n2 + 1) * d2;
                    }
                    break;
                }
                case 7: {
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[n2] = 0.0;
                    }
                    break;
                }
                case 8: {
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[n2] = n2 + 1;
                    }
                    break;
                }
                case 9: {
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[n2] = 0.5;
                    }
                    break;
                }
                case 10: {
                    dArray[0] = 1.0;
                    dArray[1] = 1.0;
                    break;
                }
                case 11: {
                    dArray[0] = 25.0;
                    dArray[1] = 5.0;
                    dArray[2] = -5.0;
                    dArray[3] = -1.0;
                    break;
                }
                case 12: {
                    dArray[0] = 5.0;
                    dArray[1] = 2.5;
                    dArray[2] = 0.15;
                    break;
                }
                case 13: {
                    double d2 = 1.0 / (double)n3;
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[n2] = d2;
                    }
                    break;
                }
                case 14: {
                    for (n2 = 0; n2 < n3; n2 += 2) {
                        dArray[n2] = -1.2;
                        dArray[n2 + 1] = 1.0;
                    }
                    break;
                }
                case 15: {
                    for (n2 = 0; n2 < n3; n2 += 4) {
                        dArray[n2] = 3.0;
                        dArray[n2 + 1] = -1.0;
                        dArray[n2 + 2] = 0.0;
                        dArray[n2 + 3] = 1.0;
                    }
                    break;
                }
                case 16: {
                    dArray[0] = 1.0;
                    dArray[1] = 1.0;
                    break;
                }
                case 17: {
                    dArray[0] = -3.0;
                    dArray[1] = -1.0;
                    dArray[2] = -3.0;
                    dArray[3] = -1.0;
                    break;
                }
                case 18: {
                    double d2 = 1.0 / (double)(n3 + 1);
                    for (n2 = 0; n2 < n3; ++n2) {
                        dArray[n2] = (double)(n2 + 1) * d2;
                    }
                    break;
                }
            }
            if (d == 1.0) break block32;
            if (n == 7) {
                for (n2 = 0; n2 < n3; ++n2) {
                    dArray[n2] = d;
                }
            } else {
                n2 = 0;
                while (n2 < n3) {
                    int n4 = n2++;
                    dArray[n4] = dArray[n4] * d;
                }
            }
        }
    }

    public static double umobj(double[] dArray, int n) {
        double d;
        double[] dArray2 = new double[50];
        int n2 = dArray.length;
        switch (n) {
            case 1: {
                double d2 = dArray[0] > 0.0 ? Math.atan(dArray[1] / dArray[0]) / (Math.PI * 2) : (dArray[0] < 0.0 ? Math.atan(dArray[1] / dArray[0]) / (Math.PI * 2) + 0.5 : (dArray[1] >= 0.0 ? 0.25 : -0.25));
                double d3 = dArray[0] * dArray[0] + dArray[1] * dArray[1];
                double d4 = Math.sqrt(d3) - 1.0;
                double d5 = dArray[2] - 10.0 * d2;
                d = 100.0 * (d5 * d5 + d4 * d4) + dArray[2] * dArray[2];
                break;
            }
            case 2: {
                d = 0.0;
                for (int i = 1; i <= 13; ++i) {
                    double d6 = (double)i / 10.0;
                    double d7 = Math.exp(-d6) - 5.0 * Math.exp(-10.0 * d6) + 3.0 * Math.exp(-4.0 * d6);
                    double d8 = Math.exp(-d6 * dArray[0]);
                    double d9 = Math.exp(-d6 * dArray[1]);
                    double d10 = Math.exp(-d6 * dArray[4]);
                    double d11 = dArray[2] * d8 - dArray[3] * d9 + dArray[5] * d10 - d7;
                    d += d11 * d11;
                }
                break;
            }
            case 3: {
                d = 0.0;
                for (int i = 0; i < 15; ++i) {
                    double d12 = 0.5 * (double)i;
                    double d13 = 3.5 - d12 - dArray[2];
                    double d14 = -0.5 * dArray[1] * (d13 * d13);
                    double d15 = Math.exp(d14);
                    double d16 = dArray[0] * d15 - um_y[i];
                    d += d16 * d16;
                }
                break;
            }
            case 4: {
                double d17 = 10000.0 * dArray[0] * dArray[1] - 1.0;
                double d18 = Math.exp(-dArray[0]);
                double d19 = Math.exp(-dArray[1]);
                double d20 = d18 + d19 - 1.0001;
                d = d17 * d17 + d20 * d20;
                break;
            }
            case 5: {
                d = 0.0;
                for (int i = 1; i <= 10; ++i) {
                    double d21 = i;
                    double d22 = d21 / 10.0;
                    double d23 = Math.exp(-d22 * dArray[0]);
                    double d24 = Math.exp(-d22 * dArray[1]);
                    double d25 = Math.exp(-d22) - Math.exp(-d21);
                    double d26 = d23 - d24 - d25 * dArray[2];
                    d += d26 * d26;
                }
                break;
            }
            case 6: {
                double d27;
                double d28 = 0.0;
                double d29 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d28 += (double)(i + 1) * (dArray[i] - 1.0);
                    d27 = dArray[i] - 1.0;
                    d29 += d27 * d27;
                }
                d27 = d28 * d28;
                d = d29 + d27 * (1.0 + d27);
                break;
            }
            case 7: {
                double d30;
                d = 0.0;
                for (int i = 1; i <= 29; ++i) {
                    int n3;
                    double d31 = (double)i / 29.0;
                    double d32 = 0.0;
                    double d33 = 1.0;
                    for (n3 = 1; n3 < n2; ++n3) {
                        d32 += (double)n3 * d33 * dArray[n3];
                        d33 *= d31;
                    }
                    double d34 = 0.0;
                    d33 = 1.0;
                    for (n3 = 0; n3 < n2; ++n3) {
                        d34 += d33 * dArray[n3];
                        d33 *= d31;
                    }
                    d30 = d32 - d34 * d34 - 1.0;
                    d += d30 * d30;
                }
                d30 = dArray[0] * dArray[0];
                double d35 = dArray[1] - d30 - 1.0;
                d += d30 + d35 * d35;
                break;
            }
            case 8: {
                double d36 = -0.25;
                double d37 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d36 += dArray[i] * dArray[i];
                    double d38 = dArray[i] - 1.0;
                    d37 += d38 * d38;
                }
                d = 1.0E-5 * d37 + 1.0 * (d36 * d36);
                break;
            }
            case 9: {
                double d39;
                double d40 = -1.0;
                double d41 = 0.0;
                double d42 = 0.0;
                double d43 = Math.exp(0.1);
                double d44 = 1.0;
                double d45 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d40 += (double)(n2 - i) * (dArray[i] * dArray[i]);
                    double d46 = Math.exp(dArray[i] / 10.0);
                    if (i > 0) {
                        double d47 = d46 + d45 - d44 * (d43 + 1.0);
                        d41 += d47 * d47;
                        d39 = d46 - 1.0 / d43;
                        d42 += d39 * d39;
                    }
                    d45 = d46;
                    d44 *= d43;
                }
                d39 = dArray[0] - 0.2;
                d = 1.0E-5 * (d41 + d42) + 1.0 * (d40 * d40 + d39 * d39);
                break;
            }
            case 10: {
                double d48 = dArray[0] - 1000000.0;
                double d49 = dArray[1] - 2.0E-6;
                double d50 = dArray[0] * dArray[1] - 2.0;
                d = d48 * d48 + d49 * d49 + d50 * d50;
                break;
            }
            case 11: {
                d = 0.0;
                for (int i = 1; i <= 20; ++i) {
                    double d51 = (double)i / 5.0;
                    double d52 = Math.sin(d51);
                    double d53 = dArray[0] + d51 * dArray[1] - Math.exp(d51);
                    double d54 = dArray[2] + d52 * dArray[3] - Math.cos(d51);
                    double d55 = d53 * d53 + d54 * d54;
                    d += d55 * d55;
                }
                break;
            }
            case 12: {
                d = 0.0;
                double d56 = 0.6666666666666666;
                for (int i = 1; i <= 99; ++i) {
                    double d57 = (double)i / 100.0;
                    double d58 = Math.abs(Math.pow(-50.0 * Math.log(d57), d56) + 25.0 - dArray[1]);
                    double d59 = Math.pow(d58, dArray[2]) / dArray[0];
                    double d60 = Math.exp(-d59);
                    double d61 = d60 - d57;
                    d += d61 * d61;
                }
                break;
            }
            case 13: {
                int n4;
                double d62 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    d62 += Math.cos(dArray[n4]);
                }
                d = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    double d63 = (double)(n2 + 1 + n4) - Math.sin(dArray[n4]) - d62 - (double)(1 + n4) * Math.cos(dArray[n4]);
                    d += d63 * d63;
                }
                break;
            }
            case 14: {
                d = 0.0;
                for (int i = 0; i < n2; i += 2) {
                    double d64 = 1.0 - dArray[i];
                    double d65 = 10.0 * (dArray[i + 1] - dArray[i] * dArray[i]);
                    d += d64 * d64 + d65 * d65;
                }
                break;
            }
            case 15: {
                d = 0.0;
                for (int i = 0; i < n2; i += 4) {
                    double d66 = dArray[i] + 10.0 * dArray[i + 1];
                    double d67 = dArray[i + 2] - dArray[i + 3];
                    double d68 = 5.0 * d67;
                    double d69 = dArray[i + 1] - 2.0 * dArray[i + 2];
                    double d70 = d69 * d69 * d69;
                    double d71 = dArray[i] - dArray[i + 3];
                    double d72 = 10.0 * (d71 * d71 * d71);
                    d += d66 * d66 + d68 * d67 + d70 * d69 + d72 * d71;
                }
                break;
            }
            case 16: {
                double d73 = 1.0 - dArray[1];
                double d74 = 1.5 - dArray[0] * d73;
                double d75 = 1.0 - dArray[1] * dArray[1];
                double d76 = 2.25 - dArray[0] * d75;
                double d77 = 1.0 - dArray[1] * dArray[1] * dArray[1];
                double d78 = 2.625 - dArray[0] * d77;
                d = d74 * d74 + d76 * d76 + d78 * d78;
                break;
            }
            case 17: {
                double d79 = dArray[1] - dArray[0] * dArray[0];
                double d80 = 1.0 - dArray[0];
                double d81 = dArray[1] - 1.0;
                double d82 = dArray[3] - dArray[2] * dArray[2];
                double d83 = 1.0 - dArray[2];
                double d84 = dArray[3] - 1.0;
                double d85 = d81 + d84;
                double d86 = d81 - d84;
                d = 100.0 * (d79 * d79) + d80 * d80 + 90.0 * (d82 * d82) + d83 * d83 + 10.0 * (d85 * d85) + d86 * d86 / 10.0;
                break;
            }
            case 18: {
                double d87;
                int n5;
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray2[n5] = 0.0;
                }
                for (int i = 0; i < n2; ++i) {
                    double d88 = 1.0;
                    double d89 = 2.0 * dArray[i] - 1.0;
                    d87 = 2.0 * d89;
                    n5 = 0;
                    while (n5 < n2) {
                        int n6 = n5++;
                        dArray2[n6] = dArray2[n6] + d89;
                        double d90 = d87 * d89 - d88;
                        d88 = d89;
                        d89 = d90;
                    }
                }
                d = 0.0;
                double d91 = 1.0 / (double)n2;
                int n7 = -1;
                for (n5 = 0; n5 < n2; ++n5) {
                    d87 = d91 * dArray2[n5];
                    if (n7 > 0) {
                        double d92 = n5 + 1;
                        d87 += 1.0 / (d92 * d92 - 1.0);
                    }
                    d += d87 * d87;
                    n7 = -n7;
                }
                break;
            }
            default: {
                d = 0.0;
            }
        }
        return d;
    }

    public static void umgrd(double[] dArray, double[] dArray2, int n) {
        double[] dArray3 = new double[50];
        int n2 = dArray.length;
        switch (n) {
            case 1: {
                double d = dArray[0] > 0.0 ? Math.atan(dArray[1] / dArray[0]) / (Math.PI * 2) : (dArray[0] < 0.0 ? Math.atan(dArray[1] / dArray[0]) / (Math.PI * 2) + 0.5 : (dArray[1] >= 0.0 ? 0.25 : -0.25));
                double d2 = dArray[0] * dArray[0] + dArray[1] * dArray[1];
                double d3 = Math.sqrt(d2);
                double d4 = dArray[2] - 10.0 * d;
                double d5 = 10.0 * d4 / (Math.PI * 2 * d2);
                dArray2[0] = 200.0 * (dArray[0] - dArray[0] / d3 + dArray[1] * d5);
                dArray2[1] = 200.0 * (dArray[1] - dArray[1] / d3 - dArray[0] * d5);
                dArray2[2] = 2.0 * (100.0 * d4 + dArray[2]);
                break;
            }
            case 2: {
                for (int i = 0; i < 6; ++i) {
                    dArray2[i] = 0.0;
                }
                for (int i = 1; i <= 13; ++i) {
                    double d = (double)i / 10.0;
                    double d6 = Math.exp(-d) - 5.0 * Math.exp(-10.0 * d) + 3.0 * Math.exp(-4.0 * d);
                    double d7 = Math.exp(-d * dArray[0]);
                    double d8 = Math.exp(-d * dArray[1]);
                    double d9 = Math.exp(-d * dArray[4]);
                    double d10 = dArray[2] * d7 - dArray[3] * d8 + dArray[5] * d9 - d6;
                    double d11 = d * d10;
                    dArray2[0] = dArray2[0] - d7 * d11;
                    dArray2[1] = dArray2[1] + d8 * d11;
                    dArray2[2] = dArray2[2] + d7 * d10;
                    dArray2[3] = dArray2[3] - d8 * d10;
                    dArray2[4] = dArray2[4] - d9 * d11;
                    dArray2[5] = dArray2[5] + d9 * d10;
                }
                dArray2[0] = dArray2[0] * (2.0 * dArray[2]);
                dArray2[1] = dArray2[1] * (2.0 * dArray[3]);
                dArray2[2] = dArray2[2] * 2.0;
                dArray2[3] = dArray2[3] * 2.0;
                dArray2[4] = dArray2[4] * (2.0 * dArray[5]);
                dArray2[5] = dArray2[5] * 2.0;
                break;
            }
            case 3: {
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                for (int i = 0; i < 15; ++i) {
                    double d = 0.5 * (double)i;
                    double d12 = 3.5 - d - dArray[2];
                    double d13 = -0.5 * dArray[1] * (d12 * d12);
                    double d14 = Math.exp(d13);
                    double d15 = dArray[0] * d14 - um_y[i];
                    double d16 = d14 * d15;
                    double d17 = d12 * d16;
                    dArray2[0] = dArray2[0] + d16;
                    dArray2[1] = dArray2[1] - d12 * d17;
                    dArray2[2] = dArray2[2] + d17;
                }
                dArray2[0] = dArray2[0] * 2.0;
                dArray2[1] = dArray2[1] * dArray[0];
                dArray2[2] = dArray2[2] * (2.0 * dArray[0] * dArray[1]);
                break;
            }
            case 4: {
                double d = 10000.0 * dArray[0] * dArray[1] - 1.0;
                double d18 = Math.exp(-dArray[0]);
                double d19 = Math.exp(-dArray[1]);
                double d20 = d18 + d19 - 1.0001;
                dArray2[0] = 2.0 * (10000.0 * dArray[1] * d - d18 * d20);
                dArray2[1] = 2.0 * (10000.0 * dArray[0] * d - d19 * d20);
                break;
            }
            case 5: {
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                for (int i = 1; i <= 10; ++i) {
                    double d = i;
                    double d21 = d / 10.0;
                    double d22 = Math.exp(-d21 * dArray[0]);
                    double d23 = Math.exp(-d21 * dArray[1]);
                    double d24 = Math.exp(-d21) - Math.exp(-d);
                    double d25 = d22 - d23 - d24 * dArray[2];
                    double d26 = d21 * d25;
                    dArray2[0] = dArray2[0] - d22 * d26;
                    dArray2[1] = dArray2[1] + d23 * d26;
                    dArray2[2] = dArray2[2] - d24 * d25;
                }
                dArray2[0] = dArray2[0] * 2.0;
                dArray2[1] = dArray2[1] * 2.0;
                dArray2[2] = dArray2[2] * 2.0;
                break;
            }
            case 6: {
                int n3;
                double d = 0.0;
                for (n3 = 0; n3 < n2; ++n3) {
                    d += (double)(n3 + 1) * (dArray[n3] - 1.0);
                }
                double d27 = d * (1.0 + 2.0 * (d * d));
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray2[n3] = 2.0 * (dArray[n3] - 1.0 + (double)(n3 + 1) * d27);
                }
                break;
            }
            case 7: {
                int n4;
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray2[n4] = 0.0;
                }
                for (int i = 1; i <= 29; ++i) {
                    double d = (double)i / 29.0;
                    double d28 = 0.0;
                    double d29 = 1.0;
                    for (n4 = 1; n4 < n2; ++n4) {
                        d28 += (double)n4 * d29 * dArray[n4];
                        d29 *= d;
                    }
                    double d30 = 0.0;
                    d29 = 1.0;
                    for (n4 = 0; n4 < n2; ++n4) {
                        d30 += d29 * dArray[n4];
                        d29 *= d;
                    }
                    double d31 = d28 - d30 * d30 - 1.0;
                    double d32 = 2.0 * d * d30;
                    d29 = 2.0 / d;
                    for (n4 = 0; n4 < n2; ++n4) {
                        int n5 = n4;
                        dArray2[n5] = dArray2[n5] + d29 * ((double)n4 - d32) * d31;
                        d29 *= d;
                    }
                }
                double d = dArray[1] - dArray[0] * dArray[0] - 1.0;
                dArray2[0] = dArray2[0] + dArray[0] * (2.0 - 4.0 * d);
                dArray2[1] = dArray2[1] + 2.0 * d;
                break;
            }
            case 8: {
                int n6;
                double d = -0.25;
                for (n6 = 0; n6 < n2; ++n6) {
                    d += dArray[n6] * dArray[n6];
                }
                double d33 = 2.0E-5;
                double d34 = 4.0 * d;
                for (n6 = 0; n6 < n2; ++n6) {
                    dArray2[n6] = d33 * (dArray[n6] - 1.0) + dArray[n6] * d34;
                }
                break;
            }
            case 9: {
                int n7;
                double d = 0.0;
                double d35 = -1.0;
                for (n7 = 0; n7 < n2; ++n7) {
                    d35 += (double)(n2 - n7) * (dArray[n7] * dArray[n7]);
                }
                double d36 = Math.exp(0.1);
                double d37 = 1.0;
                double d38 = 4.0 * d35;
                for (n7 = 0; n7 < n2; ++n7) {
                    dArray2[n7] = (double)(n2 - n7) * dArray[n7] * d38;
                    double d39 = Math.exp(dArray[n7] / 10.0);
                    if (n7 > 0) {
                        double d40 = d39 + d - d37 * (d36 + 1.0);
                        int n8 = n7;
                        dArray2[n8] = dArray2[n8] + 1.0E-5 * d39 * (d40 + d39 - 1.0 / d36) / 5.0;
                        int n9 = n7 - 1;
                        dArray2[n9] = dArray2[n9] + 1.0E-5 * d * d40 / 5.0;
                    }
                    d = d39;
                    d37 *= d36;
                }
                dArray2[0] = dArray2[0] + 2.0 * (dArray[0] - 0.2);
                break;
            }
            case 10: {
                double d = dArray[0] - 1000000.0;
                double d41 = dArray[1] - 2.0E-6;
                double d42 = dArray[0] * dArray[1] - 2.0;
                dArray2[0] = 2.0 * (d + dArray[1] * d42);
                dArray2[1] = 2.0 * (d41 + dArray[0] * d42);
                break;
            }
            case 11: {
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                dArray2[3] = 0.0;
                for (int i = 1; i <= 20; ++i) {
                    double d = (double)i / 5.0;
                    double d43 = Math.sin(d);
                    double d44 = dArray[0] + d * dArray[1] - Math.exp(d);
                    double d45 = dArray[2] + d43 * dArray[3] - Math.cos(d);
                    double d46 = d44 * d44 + d45 * d45;
                    double d47 = d44 * d46;
                    double d48 = d45 * d46;
                    dArray2[0] = dArray2[0] + d47;
                    dArray2[1] = dArray2[1] + d * d47;
                    dArray2[2] = dArray2[2] + d48;
                    dArray2[3] = dArray2[3] + d43 * d48;
                }
                dArray2[0] = dArray2[0] * 4.0;
                dArray2[1] = dArray2[1] * 4.0;
                dArray2[2] = dArray2[2] * 4.0;
                dArray2[3] = dArray2[3] * 4.0;
                break;
            }
            case 12: {
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
                dArray2[2] = 0.0;
                double d = 0.6666666666666666;
                for (int i = 1; i <= 99; ++i) {
                    double d49 = (double)i / 100.0;
                    double d50 = Math.abs(Math.pow(-50.0 * Math.log(d49), d) + 25.0 - dArray[1]);
                    double d51 = Math.pow(d50, dArray[2]) / dArray[0];
                    double d52 = Math.exp(-d51);
                    double d53 = d52 - d49;
                    double d54 = d51 * d52 * d53;
                    dArray2[0] = dArray2[0] + d54;
                    dArray2[1] = dArray2[1] + d54 / d50;
                    dArray2[2] = dArray2[2] - d54 * Math.log(d50);
                }
                dArray2[0] = dArray2[0] * (2.0 / dArray[0]);
                dArray2[1] = dArray2[1] * (2.0 * dArray[2]);
                dArray2[2] = dArray2[2] * 2.0;
                break;
            }
            case 13: {
                int n10;
                double d = 0.0;
                for (n10 = 0; n10 < n2; ++n10) {
                    dArray2[n10] = Math.cos(dArray[n10]);
                    d += dArray2[n10];
                }
                double d55 = 0.0;
                for (n10 = 0; n10 < n2; ++n10) {
                    double d56 = Math.sin(dArray[n10]);
                    double d57 = (double)(n2 + 1 + n10) - d56 - d - (double)(1 + n10) * dArray2[n10];
                    d55 += d57;
                    dArray2[n10] = ((double)(1 + n10) * d56 - dArray2[n10]) * d57;
                }
                for (n10 = 0; n10 < n2; ++n10) {
                    dArray2[n10] = 2.0 * (dArray2[n10] + Math.sin(dArray[n10]) * d55);
                }
                break;
            }
            case 14: {
                for (int i = 0; i < n2; i += 2) {
                    double d = 1.0 - dArray[i];
                    dArray2[i + 1] = 200.0 * (dArray[i + 1] - dArray[i] * dArray[i]);
                    dArray2[i] = -2.0 * (dArray[i] * dArray2[i + 1] + d);
                }
                break;
            }
            case 15: {
                for (int i = 0; i < n2; i += 4) {
                    double d = dArray[i] + 10.0 * dArray[i + 1];
                    double d58 = dArray[i + 2] - dArray[i + 3];
                    double d59 = 5.0 * d58;
                    double d60 = dArray[i + 1] - 2.0 * dArray[i + 2];
                    double d61 = 4.0 * (d60 * d60 * d60);
                    double d62 = dArray[i] - dArray[i + 3];
                    double d63 = 20.0 * (d62 * d62 * d62);
                    dArray2[i] = 2.0 * (d + d63);
                    dArray2[i + 1] = 20.0 * d + d61;
                    dArray2[i + 2] = 2.0 * (d59 - d61);
                    dArray2[i + 3] = -2.0 * (d59 + d63);
                }
                break;
            }
            case 16: {
                double d = 1.0 - dArray[1];
                double d64 = 1.5 - dArray[0] * d;
                double d65 = 1.0 - dArray[1] * dArray[1];
                double d66 = 2.25 - dArray[0] * d65;
                double d67 = 1.0 - dArray[1] * dArray[1] * dArray[1];
                double d68 = 2.625 - dArray[0] * d67;
                dArray2[0] = -2.0 * (d * d64 + d65 * d66 + d67 * d68);
                dArray2[1] = 2.0 * dArray[0] * (d64 + dArray[1] * (2.0 * d66 + 3.0 * dArray[1] * d68));
                break;
            }
            case 17: {
                double d = dArray[1] - dArray[0] * dArray[0];
                double d69 = 1.0 - dArray[0];
                double d70 = dArray[1] - 1.0;
                double d71 = dArray[3] - dArray[2] * dArray[2];
                double d72 = 1.0 - dArray[2];
                double d73 = dArray[3] - 1.0;
                dArray2[0] = -2.0 * (200.0 * dArray[0] * d + d69);
                dArray2[1] = 200.0 * d + 20.2 * d70 + 19.8 * d73;
                dArray2[2] = -2.0 * (180.0 * dArray[2] * d71 + d72);
                dArray2[3] = 180.0 * d71 + 20.2 * d73 + 19.8 * d70;
                break;
            }
            case 18: {
                double d;
                double d74;
                double d75;
                double d76;
                int n11;
                int n12;
                for (n12 = 0; n12 < n2; ++n12) {
                    dArray3[n12] = 0.0;
                }
                for (n11 = 0; n11 < n2; ++n11) {
                    d76 = 1.0;
                    d75 = 2.0 * dArray[n11] - 1.0;
                    d74 = 2.0 * d75;
                    n12 = 0;
                    while (n12 < n2) {
                        int n13 = n12++;
                        dArray3[n13] = dArray3[n13] + d75;
                        d = d74 * d75 - d76;
                        d76 = d75;
                        d75 = d;
                    }
                }
                double d77 = 1.0 / (double)n2;
                int n14 = -1;
                for (n12 = 0; n12 < n2; ++n12) {
                    int n15 = n12;
                    dArray3[n15] = dArray3[n15] * d77;
                    if (n14 > 0) {
                        double d78 = n12 + 1;
                        int n16 = n12;
                        dArray3[n16] = dArray3[n16] + 1.0 / (d78 * d78 - 1.0);
                    }
                    n14 = -n14;
                }
                for (n11 = 0; n11 < n2; ++n11) {
                    dArray2[n11] = 0.0;
                    d76 = 1.0;
                    d75 = 2.0 * dArray[n11] - 1.0;
                    d74 = 2.0 * d75;
                    double d79 = 0.0;
                    double d80 = 2.0;
                    for (n12 = 0; n12 < n2; ++n12) {
                        int n17 = n11;
                        dArray2[n17] = dArray2[n17] + dArray3[n12] * d80;
                        d = 4.0 * d75 + d74 * d80 - d79;
                        d79 = d80;
                        d80 = d;
                        d = d74 * d75 - d76;
                        d76 = d75;
                        d75 = d;
                    }
                }
                double d81 = 2.0 * d77;
                n11 = 0;
                while (n11 < n2) {
                    int n18 = n11++;
                    dArray2[n18] = dArray2[n18] * d81;
                }
                break;
            }
            default: {
                for (int i = 0; i < n2; ++i) {
                    dArray2[i] = 0.0;
                }
            }
        }
    }
}

