/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

public class FFTUtils {
    protected FFTUtils() {
    }

    public static int bestPowerOfTwo(int n) {
        int n2;
        if (n > 0x40000000) {
            throw new IllegalArgumentException("Integer overflow");
        }
        for (n2 = 1; n2 < n; n2 *= 2) {
        }
        return n2;
    }

    public static int bestDimension(int n) {
        int n2 = 2 * n;
        for (int i = 1; i < n2; i *= 5) {
            for (int j = i; j < n2; j *= 3) {
                int n3;
                for (n3 = j; n3 < n; n3 *= 2) {
                }
                if (n3 == n) {
                    return n;
                }
                if (n2 <= n3) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    public static int[] generateFrequels(int n) {
        int[] nArray = new int[n];
        FFTUtils.generateFrequels(nArray);
        return nArray;
    }

    public static void generateFrequels(int[] nArray) {
        int n;
        int n2 = nArray.length;
        int n3 = n2 / 2;
        for (n = 0; n <= n3; ++n) {
            nArray[n] = n;
        }
        for (n = n3 + 1; n < n2; ++n) {
            nArray[n] = n - n2;
        }
    }
}

