/*******************************************************************************
 * Copyright (c) 2012 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th?venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C?dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     P?sp?ki Zsuzsanna (zsuzsanna.puspoki@epfl.ch)
 ******************************************************************************/
package plugins.big.steerablej.core;

/**
 * Offers global parameters (settings) and functions used by the plug-in.
 * 
 * Settings makes use of the Singleton design pattern: There's at most one
 * instance present, which can only be accessed through
 * <code>getInstance()</code>.
 * 
 * @version April 23, 2013
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Settings {

	/** Set to true to enable DEBUG mode. */
	public static final boolean DEBUG = false;

	/** The unique instance of Settings (Singleton design pattern). */
	private static Settings instance_ = null;

	/** Name of the application */
	private String appName_ = "Feature Detector";

	/** Version of the application. */
	private String appVersion_ = "1.2";

	/** Minimal version of ICY required to run the plug-in. */
	private String icyRequiredVersion_ = "1.3.2.0";

	// ============================================================================
	// PUBLIC METHODS

	/** Get Settings instance */
	static public Settings getInstance() {
		if (instance_ == null)
			instance_ = new Settings();
		return instance_;
	}

	// ============================================================================
	// SETTERS AND GETTERS

	/** Returns the name of the plug-in. */
	public String getAppName() {
		return appName_;
	}

	// ----------------------------------------------------------------------------

	/** Returns the version of the plug-in. */
	public String getAppVersion() {
		return appVersion_;
	}

	// ----------------------------------------------------------------------------

	/** Returns the minimum version of Icy in which the plug-in works properly. */
	public String getIcyRequiredVersion() {
		return icyRequiredVersion_;
	}
}
