/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tdouble.demo;

import edu.emory.mathcs.csparsej.tdouble.Dcs_common;
import edu.emory.mathcs.csparsej.tdouble.Dcs_dmperm;
import edu.emory.mathcs.csparsej.tdouble.Dcs_qrsol;
import edu.emory.mathcs.csparsej.tdouble.demo.Dcs_demo;

public class Dcs_QRbenchmark {
    public static void main(String[] stringArray) {
        Dcs_demo.Dproblem dproblem = null;
        if (stringArray.length != 3) {
            throw new IllegalArgumentException("Usage: java edu.emory.mathcs.csparsej.tdouble.demo.Dcs_QRbenchmark fileName niters order");
        }
        dproblem = Dcs_demo.get_problem(stringArray[0], true, 1.0E-14);
        Dcs_QRbenchmark.benchmarkQR(dproblem, Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
    }

    public static boolean benchmarkQR(Dcs_demo.Dproblem dproblem, int n, int n2) {
        if (dproblem == null) {
            return false;
        }
        Dcs_common.Dcs dcs = dproblem.A;
        Dcs_common.Dcs dcs2 = dproblem.C;
        double[] dArray = dproblem.b;
        double[] dArray2 = dproblem.x;
        int n3 = dcs.m;
        int n4 = dcs.n;
        double d = dproblem.sym != 0 ? 0.001 : 1.0;
        Dcs_common.Dcsd dcsd = Dcs_dmperm.cs_dmperm(dcs2, 1);
        if (dcsd == null) {
            return false;
        }
        int n5 = dcsd.nb;
        int[] nArray = dcsd.r;
        int[] nArray2 = dcsd.s;
        int[] nArray3 = dcsd.rr;
        int n6 = nArray3[3];
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            if (nArray[i + 1] != nArray[i] + 1 || nArray2[i + 1] != nArray2[i] + 1) continue;
            ++n7;
        }
        System.out.print(String.format("blocks: %d singletons: %d structural rank: %d\n", n5, n7, n6));
        if (n3 != n4 || n6 < n4) {
            throw new IllegalArgumentException("Matrix is rectangular or singlular");
        }
        dcsd = null;
        System.out.println("Solve Ax=b with QR benchmark  (order = " + Dcs_QRbenchmark.get_order(n2) + ")");
        Dcs_QRbenchmark.rhs(dArray2, dArray, n3);
        boolean bl = Dcs_qrsol.cs_qrsol(n2, dcs2, dArray2);
        bl = Dcs_qrsol.cs_qrsol(n2, dcs2, dArray2);
        if (!bl) {
            throw new IllegalArgumentException("Error occured while solving the system");
        }
        double d2 = Dcs_QRbenchmark.tic();
        for (int i = 0; i < n; ++i) {
            bl = Dcs_qrsol.cs_qrsol(n2, dcs2, dArray2);
        }
        if (!bl) {
            throw new IllegalArgumentException("Error occured while solving the system");
        }
        System.out.print(String.format("Average execution time: %8.2f seconds", Dcs_QRbenchmark.toc(d2) / (double)n));
        return true;
    }

    private static String get_order(int n) {
        switch (n) {
            case 0: {
                return "natural";
            }
            case 1: {
                return "amd(A+A')";
            }
            case 2: {
                return "amd(S'*S)";
            }
            case 3: {
                return "amd(A'*A)";
            }
        }
        return null;
    }

    private static void rhs(double[] dArray, double[] dArray2, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            dArray2[n2] = 1.0 + (double)n2 / (double)n;
        }
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = dArray2[n2];
        }
    }

    private static double tic() {
        return System.nanoTime();
    }

    private static double toc(double d) {
        double d2 = Dcs_QRbenchmark.tic();
        return Math.max(0.0, d2 - d) / 1.0E9;
    }
}

