/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import java.util.ArrayList;
import java.util.Arrays;
import mcib3d.image3d.Coordinate3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import mcib3d.image3d.comparator.ComparatorByte;
import mcib3d.image3d.comparator.ComparatorFloat;
import mcib3d.image3d.comparator.ComparatorInvByte;
import mcib3d.image3d.comparator.ComparatorInvFloat;
import mcib3d.image3d.comparator.ComparatorInvShort;
import mcib3d.image3d.comparator.ComparatorShort;

public class MaskIterator {
    ImageHandler mask;
    public Integer[] coords;
    private Coordinate3D c3D;
    public int limit;

    public MaskIterator(ImageHandler mask) {
        if (mask instanceof ImageByte) {
            int xy;
            int z;
            ImageByte im = (ImageByte)mask;
            int count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (im.pixels[z][xy] == 0) continue;
                    ++count;
                }
            }
            this.coords = new Integer[count];
            count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (im.pixels[z][xy] == 0) continue;
                    this.coords[count] = z * mask.sizeXY + xy;
                    ++count;
                }
            }
        } else if (mask instanceof ImageShort) {
            int xy;
            int z;
            ImageShort im = (ImageShort)mask;
            int count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (im.pixels[z][xy] == 0) continue;
                    ++count;
                }
            }
            this.coords = new Integer[count];
            count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (im.pixels[z][xy] == 0) continue;
                    this.coords[count] = z * mask.sizeXY + xy;
                    ++count;
                }
            }
        } else if (mask instanceof ImageFloat) {
            int xy;
            int z;
            ImageFloat im = (ImageFloat)mask;
            int count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (im.pixels[z][xy] == 0.0f) continue;
                    ++count;
                }
            }
            this.coords = new Integer[count];
            count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (im.pixels[z][xy] == 0.0f) continue;
                    this.coords[count] = z * mask.sizeXY + xy;
                    ++count;
                }
            }
        }
        this.c3D = new Coordinate3D(0, mask.sizeX, mask.sizeY, mask.sizeZ);
    }

    public MaskIterator(ImageHandler mask, float thld) {
        if (mask instanceof ImageByte) {
            int xy;
            int z;
            ImageByte im = (ImageByte)mask;
            int count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (!((float)(im.pixels[z][xy] & 0xFF) >= thld)) continue;
                    ++count;
                }
            }
            this.coords = new Integer[count];
            count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (!((float)(im.pixels[z][xy] & 0xFF) >= thld)) continue;
                    this.coords[count] = z * mask.sizeXY + xy;
                    ++count;
                }
            }
        } else if (mask instanceof ImageShort) {
            int xy;
            int z;
            ImageShort im = (ImageShort)mask;
            int count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (!((float)(im.pixels[z][xy] & 0xFFFF) >= thld)) continue;
                    ++count;
                }
            }
            this.coords = new Integer[count];
            count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (!((float)(im.pixels[z][xy] & 0xFFFF) >= thld)) continue;
                    this.coords[count] = z * mask.sizeXY + xy;
                    ++count;
                }
            }
        } else if (mask instanceof ImageFloat) {
            int xy;
            int z;
            ImageFloat im = (ImageFloat)mask;
            int count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (!(im.pixels[z][xy] >= thld)) continue;
                    ++count;
                }
            }
            this.coords = new Integer[count];
            count = 0;
            for (z = 0; z < mask.sizeZ; ++z) {
                for (xy = 0; xy < mask.sizeXY; ++xy) {
                    if (!(im.pixels[z][xy] >= thld)) continue;
                    this.coords[count] = z * mask.sizeXY + xy;
                    ++count;
                }
            }
        }
        this.c3D = new Coordinate3D(0, mask.sizeX, mask.sizeY, mask.sizeZ);
    }

    public MaskIterator(int sizeX, int sizeY, int sizeZ) {
        this.coords = new Integer[sizeX * sizeY * sizeZ];
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = i;
        }
        this.c3D = new Coordinate3D(0, sizeX, sizeY, sizeZ);
    }

    public void sort(boolean inv, ImageHandler image) {
        if (image instanceof ImageByte) {
            if (inv) {
                Arrays.sort(this.coords, new ComparatorInvByte((ImageByte)image));
            } else {
                Arrays.sort(this.coords, new ComparatorByte((ImageByte)image));
            }
        } else if (image instanceof ImageShort) {
            if (inv) {
                Arrays.sort(this.coords, new ComparatorInvShort((ImageShort)image));
            } else {
                Arrays.sort(this.coords, new ComparatorShort((ImageShort)image));
            }
        } else if (image instanceof ImageFloat) {
            if (inv) {
                Arrays.sort(this.coords, new ComparatorInvFloat((ImageFloat)image));
            } else {
                Arrays.sort(this.coords, new ComparatorFloat((ImageFloat)image));
            }
        }
    }

    public boolean isIn(int xx, int yy, int zz) {
        if (xx >= 0 && xx < this.mask.sizeX && yy >= 0 && yy < this.mask.sizeY && zz >= 0 && zz < this.mask.sizeZ) {
            return this.mask.getPixel(xx, yy, zz) != 0.0f;
        }
        return false;
    }

    public ArrayList<Integer> getVois1(int coord) {
        this.c3D.setCoord(coord);
        if (this.mask != null) {
            return this.c3D.getVois1(this.mask);
        }
        return this.c3D.getVois1();
    }

    public ArrayList<Integer> getVois15(int coord) {
        this.c3D.setCoord(coord);
        if (this.mask != null) {
            return this.c3D.getVois15(this.mask);
        }
        return this.c3D.getVois15();
    }

    public void setVois(float radius, float radiusZ) {
        this.c3D.setVois(radius, radiusZ);
    }

    public ArrayList<Integer> getVois(int coord) {
        this.c3D.setCoord(coord);
        if (this.mask != null) {
            return this.c3D.getVois(this.mask);
        }
        return this.c3D.getVois();
    }
}

