/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsConfiguration;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.MasterControl;
import javax.media.j3d.VirtualUniverse;

abstract class NativeConfigTemplate3D {
    static final int RED_SIZE = 0;
    static final int GREEN_SIZE = 1;
    static final int BLUE_SIZE = 2;
    static final int ALPHA_SIZE = 3;
    static final int ACCUM_BUFFER = 4;
    static final int DEPTH_SIZE = 5;
    static final int DOUBLEBUFFER = 6;
    static final int STEREO = 7;
    static final int ANTIALIASING = 8;
    static final int STENCIL_SIZE = 9;
    static final int NUM_ITEMS = 10;
    private static final String x11ClassName = "javax.media.j3d.X11NativeConfigTemplate3D";
    private static final String win32ClassName = "javax.media.j3d.Win32NativeConfigTemplate3D";
    private static NativeConfigTemplate3D nativeConfigTemplate3D = null;

    protected NativeConfigTemplate3D() {
    }

    static synchronized void createNativeConfigTemplate3D() {
        String string = MasterControl.isWindows() ? win32ClassName : x11ClassName;
        final String string2 = string;
        nativeConfigTemplate3D = (NativeConfigTemplate3D)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName(string2);
                    return clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    static NativeConfigTemplate3D getNativeConfigTemplate3D() {
        return nativeConfigTemplate3D;
    }

    abstract GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate3D var1, GraphicsConfiguration[] var2);

    abstract boolean isGraphicsConfigSupported(GraphicsConfigTemplate3D var1, GraphicsConfiguration var2);

    abstract boolean hasStereo(Canvas3D var1);

    abstract int getStencilSize(Canvas3D var1);

    abstract boolean hasDoubleBuffer(Canvas3D var1);

    abstract boolean hasSceneAntialiasingAccum(Canvas3D var1);

    abstract boolean hasSceneAntialiasingMultisample(Canvas3D var1);

    static {
        VirtualUniverse.loadLibraries();
    }
}

