/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.Byte3D;
import mitiv.array.Byte4D;
import mitiv.array.impl.FlatByte1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte4D;
import mitiv.array.impl.StriddenByte3D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.random.ByteGenerator;

public class StriddenByte4D
extends Byte4D {
    final int order;
    final byte[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final int stride4;
    final boolean flat;

    public StriddenByte4D(byte[] byArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 4) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = byArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.stride3 = nArray[2];
        this.stride4 = nArray[3];
        this.order = Byte4D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.stride4, this.dim1, this.dim2, this.dim3, this.dim4);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2 && this.stride4 == this.dim3 * this.stride3;
    }

    public StriddenByte4D(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(n6, n7, n8, n9);
        this.data = byArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.stride4 = n5;
        this.order = Byte4D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.flat = n == 0 && n2 == 1 && n3 == n6 && n4 == n7 * n3 && n5 == n8 * n4;
    }

    @Override
    public void checkSanity() {
        Byte4D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.stride4, this.dim1, this.dim2, this.dim3, this.dim4);
    }

    final int index(int n, int n2, int n3, int n4) {
        return this.offset + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final byte get(int n, int n2, int n3, int n4) {
        return this.data[this.offset + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, byte by) {
        this.data[this.offset + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = by;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            this.data[n4] = by;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                int n = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n5 = this.stride3 * j + n;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n6 = this.stride2 * k + n5;
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            int n7 = this.stride1 * i3 + n6;
                            this.data[n7] = by;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            this.data[n4] = byteGenerator.nextByte();
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                int n = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n5 = this.stride3 * j + n;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n6 = this.stride2 * k + n5;
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            int n7 = this.stride1 * i3 + n6;
                            this.data[n7] = byteGenerator.nextByte();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4;
                            int n5 = n4 = this.stride4 * i2 + n3;
                            this.data[n5] = (byte)(this.data[n5] + by);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                int n = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n6 = this.stride3 * j + n;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n7 = this.stride2 * k + n6;
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            int n8;
                            int n9 = n8 = this.stride1 * i3 + n7;
                            this.data[n9] = (byte)(this.data[n9] + by);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4;
                            int n5 = n4 = this.stride4 * i2 + n3;
                            this.data[n5] = (byte)(this.data[n5] - by);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                int n = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n6 = this.stride3 * j + n;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n7 = this.stride2 * k + n6;
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            int n8;
                            int n9 = n8 = this.stride1 * i3 + n7;
                            this.data[n9] = (byte)(this.data[n9] - by);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4;
                            int n5 = n4 = this.stride4 * i2 + n3;
                            this.data[n5] = (byte)(this.data[n5] * by);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                int n = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n6 = this.stride3 * j + n;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n7 = this.stride2 * k + n6;
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            int n8;
                            int n9 = n8 = this.stride1 * i3 + n7;
                            this.data[n9] = (byte)(this.data[n9] * by);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            this.data[n4] = byteFunction.apply(this.data[n4]);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                int n = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n5 = this.stride3 * j + n;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n6 = this.stride2 * k + n5;
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            int n7 = this.stride1 * i3 + n6;
                            this.data[n7] = byteFunction.apply(this.data[n7]);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            if (bl) {
                                byteScanner.update(this.data[n4]);
                                continue;
                            }
                            byteScanner.initialize(this.data[n4]);
                            bl = true;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                int n = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n5 = this.stride3 * j + n;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n6 = this.stride2 * k + n5;
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            int n7 = this.stride1 * i3 + n6;
                            if (bl) {
                                byteScanner.update(this.data[n7]);
                                continue;
                            }
                            byteScanner.initialize(this.data[n7]);
                            bl = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public byte[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        byte[] byArray = new byte[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, byArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                int n2 = this.stride4 * i + this.offset;
                for (int j = 0; j < this.dim3; ++j) {
                    int n3 = this.stride3 * j + n2;
                    for (int k = 0; k < this.dim2; ++k) {
                        int n4 = this.stride2 * k + n3;
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            int n5 = this.stride1 * i2 + n4;
                            byArray[++n] = this.data[n5];
                        }
                    }
                }
            }
        }
        return byArray;
    }

    @Override
    public byte[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Byte3D slice(int n) {
        return new StriddenByte3D(this.data, this.offset + this.stride4 * n, this.stride1, this.stride2, this.stride3, this.dim1, this.dim2, this.dim3);
    }

    @Override
    public Byte3D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (n2 < 0) {
            n2 += 4;
        }
        if (n2 == 0) {
            n9 = this.offset + this.stride1 * n;
            n8 = this.stride2;
            n7 = this.stride3;
            n6 = this.stride4;
            n5 = this.dim2;
            n4 = this.dim3;
            n3 = this.dim4;
        } else if (n2 == 1) {
            n9 = this.offset + this.stride2 * n;
            n8 = this.stride1;
            n7 = this.stride3;
            n6 = this.stride4;
            n5 = this.dim1;
            n4 = this.dim3;
            n3 = this.dim4;
        } else if (n2 == 2) {
            n9 = this.offset + this.stride3 * n;
            n8 = this.stride1;
            n7 = this.stride2;
            n6 = this.stride4;
            n5 = this.dim1;
            n4 = this.dim2;
            n3 = this.dim4;
        } else if (n2 == 3) {
            n9 = this.offset + this.stride4 * n;
            n8 = this.stride1;
            n7 = this.stride2;
            n6 = this.stride3;
            n5 = this.dim1;
            n4 = this.dim2;
            n3 = this.dim3;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenByte3D(this.data, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Byte4D view(Range range, Range range2, Range range3, Range range4) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.stride4);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing()) {
            return this;
        }
        return new StriddenByte4D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber());
    }

    @Override
    public Byte4D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray6 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray7 = Helper.select(0, this.stride3, this.dim3, nArray3);
        int[] nArray8 = Helper.select(0, this.stride4, this.dim4, nArray4);
        return new SelectedByte4D(this.data, nArray5, nArray6, nArray7, nArray8);
    }

    @Override
    public Byte1D as1D() {
        return new FlatByte1D(this.flatten(), this.number);
    }
}

