/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ArrayUtils;
import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.Convolution;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

abstract class ConvolutionDouble
extends Convolution {
    private double[] wrk = null;
    private double[] mtf = null;

    protected ConvolutionDouble(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        super(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
        if (this.getType() != 5) {
            throw new IllegalArgumentException("Input and output vector spaces must be for double data type");
        }
    }

    public double[] getWorkArray() {
        if (this.wrk == null) {
            this.wrk = new double[2 * this.getNumberOfFrequencies()];
        }
        return this.wrk;
    }

    @Override
    public void push(ShapedVector shapedVector, boolean bl) {
        if (bl) {
            if (!shapedVector.belongsTo(this.outputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to output space");
            }
        } else if (!shapedVector.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to input space");
        }
        this.push(this.getWorkArray(), ((DoubleShapedVector)shapedVector).getData(), bl);
    }

    @Override
    public void pull(ShapedVector shapedVector, boolean bl) {
        if (bl) {
            if (!shapedVector.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to input space");
            }
        } else if (!shapedVector.belongsTo(this.outputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to output space");
        }
        this.pull(((DoubleShapedVector)shapedVector).getData(), this.getWorkArray(), bl);
    }

    public abstract void push(double[] var1, double[] var2, boolean var3);

    public abstract void pull(double[] var1, double[] var2, boolean var3);

    public abstract void forwardFFT(double[] var1);

    @Override
    public void forwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    public abstract void backwardFFT(double[] var1);

    @Override
    public void backwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    @Override
    public void convolve(boolean bl) {
        if (this.mtf == null) {
            throw new IllegalArgumentException("You must set the PSF or the MTF first");
        }
        double[] dArray = this.mtf;
        double[] dArray2 = this.getWorkArray();
        int n = this.getNumberOfFrequencies();
        this.forwardFFT();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                int n2 = i + i;
                int n3 = n2 + 1;
                double d = dArray[n2];
                double d2 = dArray[n3];
                double d3 = dArray2[n2];
                double d4 = dArray2[n3];
                dArray2[n2] = d * d3 + d2 * d4;
                dArray2[n3] = d * d4 - d2 * d3;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n4 = i + i;
                int n5 = n4 + 1;
                double d = dArray[n4];
                double d5 = dArray[n5];
                double d6 = dArray2[n4];
                double d7 = dArray2[n5];
                dArray2[n4] = d * d6 - d5 * d7;
                dArray2[n5] = d * d7 + d5 * d6;
            }
        }
        this.backwardFFT(dArray2);
    }

    @Override
    public void setPSF(ShapedVector shapedVector) {
        if (!shapedVector.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("PSF does not belong to the correct space");
        }
        this.computeMTF(((DoubleShapedVector)shapedVector).getData());
    }

    @Override
    public void setPSF(ShapedArray shapedArray, int[] nArray, boolean bl) {
        double d;
        boolean bl2 = false;
        if (shapedArray.getType() != 5) {
            shapedArray = shapedArray.toDouble();
            bl2 = true;
        }
        if (bl && (d = ArrayUtils.sum(shapedArray)) != 1.0) {
            if (!bl2) {
                shapedArray = shapedArray.copy();
            }
            ((DoubleArray)shapedArray).scale(1.0 / d);
        }
        shapedArray = this.adjustPSF(shapedArray, nArray);
        this.computeMTF(((DoubleArray)shapedArray).flatten());
    }

    private final void computeMTF(double[] dArray) {
        int n = this.getNumberOfFrequencies();
        double d = 1.0 / (double)n;
        if (this.mtf == null) {
            this.mtf = new double[2 * n];
        }
        for (int i = 0; i < n; ++i) {
            int n2 = i + i;
            int n3 = n2 + 1;
            this.mtf[n2] = dArray[i] * d;
            this.mtf[n3] = 0.0;
        }
        this.forwardFFT(this.mtf);
    }

    @Override
    public DoubleShapedVectorSpace getInputSpace() {
        return (DoubleShapedVectorSpace)this.inputSpace;
    }

    @Override
    public DoubleShapedVectorSpace getOutputSpace() {
        return (DoubleShapedVectorSpace)this.outputSpace;
    }
}

