/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.base.Traits;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.ReverseCommunicationOptimizerWithLineSearch;
import mitiv.tests.MinPack1Tests;

public class NonLinearConjugateGradient
extends ReverseCommunicationOptimizerWithLineSearch {
    public static final double SFTOL = 0.05;
    public static final double SGTOL = 0.1;
    public static final double SXTOL = Traits.DBL_EPSILON;
    public static final double STPMIN = 1.0E-20;
    public static final double STPMAX = 1.0E20;
    public static final double DELTA = 0.05;
    public static final double EPSILON = 0.01;
    public static final int FLETCHER_REEVES = 1;
    public static final int HESTENES_STIEFEL = 2;
    public static final int POLAK_RIBIERE_POLYAK = 3;
    public static final int FLETCHER = 4;
    public static final int LIU_STOREY = 5;
    public static final int DAI_YUAN = 6;
    public static final int PERRY_SHANNO = 7;
    public static final int HAGER_ZHANG = 8;
    public static final int POWELL = 256;
    public static final int SHANNO_PHUA = 512;
    public static final int DEFAULT_METHOD = 771;
    private double f0;
    private double g0norm;
    private double gnorm;
    private double dtg0;
    private double dtg;
    private double grtol;
    private double gatol;
    private double ginit;
    private double fmin;
    private final double delta;
    private final double epsilon;
    private double beta;
    private final double stpmin;
    private final double stpmax;
    private final Vector x0;
    private final Vector g0;
    private final Vector d;
    private final Vector y;
    private final int method;
    private boolean fmin_given;
    private final boolean update_Hager_Zhang_orig = false;

    public NonLinearConjugateGradient(VectorSpace vectorSpace) {
        this(vectorSpace, 771);
    }

    public NonLinearConjugateGradient(VectorSpace vectorSpace, int n) {
        this(vectorSpace, n, new MoreThuenteLineSearch(0.05, 0.1, SXTOL));
    }

    public NonLinearConjugateGradient(VectorSpace vectorSpace, int n, LineSearch lineSearch) {
        super(vectorSpace, lineSearch);
        boolean bl;
        boolean bl2;
        if (n == 0) {
            n = 771;
        }
        switch (n & 0xFF) {
            case 1: {
                bl2 = false;
                bl = false;
                break;
            }
            case 2: {
                bl2 = true;
                bl = true;
                break;
            }
            case 3: {
                bl2 = true;
                bl = true;
                break;
            }
            case 4: {
                bl2 = false;
                bl = false;
                break;
            }
            case 5: {
                bl2 = true;
                bl = true;
                break;
            }
            case 6: {
                bl2 = true;
                bl = true;
                break;
            }
            case 7: {
                bl2 = true;
                bl = true;
                break;
            }
            case 8: {
                bl2 = true;
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal method value");
            }
        }
        this.unsetFMin();
        this.method = n;
        this.grtol = 0.001;
        this.gatol = 0.0;
        this.ginit = 0.0;
        this.stpmin = 1.0E-20;
        this.stpmax = 1.0E20;
        this.delta = 0.05;
        this.epsilon = 0.01;
        this.x0 = vectorSpace.create();
        this.g0 = bl2 ? vectorSpace.create() : null;
        this.d = vectorSpace.create();
        this.y = bl ? vectorSpace.create() : null;
        this.evaluations = 0;
        this.failure(OptimStatus.LNSRCH_NOT_STARTED);
    }

    private int update0(Vector vector, double d) {
        this.beta = d;
        if (this.beta != 0.0) {
            this.d.combine(1.0, vector, d, this.d);
            return 0;
        }
        return -1;
    }

    private int update1(Vector vector, double d) {
        if ((this.method & 0x100) == 256 && d < 0.0) {
            ++this.restarts;
            this.beta = 0.0;
        } else {
            this.beta = d;
        }
        if (this.beta != 0.0) {
            this.d.combine(1.0, vector, d, this.d);
            return 0;
        }
        return -1;
    }

    private void form_y(Vector vector) {
        this.y.combine(1.0, vector, -1.0, this.g0);
    }

    private int update_Hestenes_Stiefel(Vector vector, Vector vector2) {
        this.form_y(vector2);
        double d = vector2.dot(this.y);
        double d2 = -this.d.dot(this.y);
        double d3 = d2 != 0.0 ? d / d2 : 0.0;
        return this.update1(vector2, d3);
    }

    private int update_Fletcher_Reeves(Vector vector, Vector vector2) {
        double d = this.gnorm / this.g0norm;
        return this.update0(vector2, d * d);
    }

    private int update_Polak_Ribiere_Polyak(Vector vector, Vector vector2) {
        this.form_y(vector2);
        double d = vector2.dot(this.y) / this.g0norm / this.g0norm;
        return this.update1(vector2, d);
    }

    private int update_Fletcher(Vector vector, Vector vector2) {
        double d = -this.gnorm * (this.gnorm / this.dtg0);
        return this.update0(vector2, d);
    }

    private int update_Liu_Storey(Vector vector, Vector vector2) {
        this.form_y(vector2);
        double d = vector2.dot(this.y);
        double d2 = -d / this.dtg0;
        return this.update1(vector2, d2);
    }

    private int update_Dai_Yuan(Vector vector, Vector vector2) {
        this.form_y(vector2);
        double d = -this.d.dot(this.y);
        double d2 = d != 0.0 ? this.gnorm * (this.gnorm / d) : 0.0;
        return this.update1(vector2, d2);
    }

    private int update_Hager_Zhang(Vector vector, Vector vector2) {
        double d;
        this.form_y(vector2);
        double d2 = -this.d.dot(this.y);
        if (d2 != 0.0) {
            double d3 = this.y.dot(vector2);
            double d4 = this.y.norm2();
            d = (d3 - 2.0 * (d4 / d2) * d4 * this.dtg) / d2;
        } else {
            d = 0.0;
        }
        return this.update1(vector2, d);
    }

    private int update_Perry_Shanno(Vector vector, Vector vector2) {
        this.form_y(vector2);
        double d = this.y.dot(this.y);
        if (d <= 0.0) {
            return -1;
        }
        double d2 = -this.d.dot(this.y);
        if (d2 == 0.0) {
            return -1;
        }
        double d3 = vector2.dot(this.y);
        double d4 = d2 / d;
        double d5 = d3 / d - 2.0 * this.dtg / d2;
        double d6 = -this.dtg / d;
        this.beta = d5 / d4;
        this.d.combine(d4, vector2, d5, this.d, d6, this.y);
        return 0;
    }

    private int update(Vector vector, Vector vector2) {
        switch (this.method & 0xFF) {
            case 1: {
                return this.update_Fletcher_Reeves(vector, vector2);
            }
            case 2: {
                return this.update_Hestenes_Stiefel(vector, vector2);
            }
            case 3: {
                return this.update_Polak_Ribiere_Polyak(vector, vector2);
            }
            case 4: {
                return this.update_Fletcher(vector, vector2);
            }
            case 5: {
                return this.update_Liu_Storey(vector, vector2);
            }
            case 6: {
                return this.update_Dai_Yuan(vector, vector2);
            }
            case 7: {
                return this.update_Perry_Shanno(vector, vector2);
            }
            case 8: {
                return this.update_Hager_Zhang(vector, vector2);
            }
        }
        return -1;
    }

    @Override
    public OptimTask start() {
        this.iterations = 0;
        this.evaluations = 0;
        this.restarts = 0;
        this.ginit = 0.0;
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector vector, double d, Vector vector2) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                ++this.evaluations;
                if (this.evaluations > 1) {
                    this.dtg = -this.d.dot(vector2);
                    LineSearchTask lineSearchTask = this.lnsrch.iterate(d, this.dtg);
                    if (lineSearchTask != LineSearchTask.CONVERGENCE) {
                        if (lineSearchTask == LineSearchTask.SEARCH) break;
                        OptimStatus optimStatus = this.lnsrch.getStatus();
                        if (lineSearchTask != LineSearchTask.WARNING || optimStatus != OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS) {
                            return this.failure(optimStatus);
                        }
                    }
                    ++this.iterations;
                }
                this.gnorm = vector2.norm2();
                if (this.evaluations <= 1) {
                    this.ginit = this.gnorm;
                }
                return this.success(this.gnorm <= this.getGradientThreshold(this.ginit) ? OptimTask.FINAL_X : OptimTask.NEW_X);
            }
            case NEW_X: 
            case FINAL_X: {
                if (this.evaluations <= 1 || this.update(vector, vector2) != 0) {
                    this.dtg = 0.0;
                } else {
                    this.dtg = -this.d.dot(vector2);
                    if (this.epsilon > 0.0 && this.dtg > -this.epsilon * this.d.norm2() * this.gnorm) {
                        this.dtg = 0.0;
                    }
                }
                double d2 = this.lnsrch.getStep();
                if (this.dtg < 0.0) {
                    if ((this.method & 0x200) == 512) {
                        d2 *= this.dtg0 / this.dtg;
                    }
                } else {
                    if (this.evaluations > 1) {
                        ++this.restarts;
                    }
                    this.d.copy(vector2);
                    this.dtg = -this.gnorm * this.gnorm;
                    if (d != 0.0) {
                        d2 = 2.0 * Math.abs(d / this.dtg);
                    } else {
                        double d3 = this.gnorm;
                        double d4 = vector.norm2();
                        d2 = d4 > 0.0 ? this.delta * d4 / d3 : this.delta / d3;
                    }
                    this.beta = 0.0;
                }
                this.x0.copy(vector);
                this.f0 = d;
                if (this.g0 != null) {
                    this.g0.copy(vector2);
                }
                this.g0norm = this.gnorm;
                this.dtg0 = this.dtg;
                if (this.lnsrch.start(this.f0, this.dtg0, d2, this.stpmin * d2, this.stpmax * d2) == LineSearchTask.SEARCH) break;
                return this.failure(this.lnsrch.getStatus());
            }
            default: {
                return this.getTask();
            }
        }
        vector.combine(1.0, this.x0, -this.lnsrch.getStep(), this.d);
        return this.success(OptimTask.COMPUTE_FG);
    }

    public void setAbsoluteTolerance(double d) {
        this.gatol = d;
    }

    public void setRelativeTolerance(double d) {
        this.grtol = d;
    }

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public double getGradientThreshold(double d) {
        return NonLinearConjugateGradient.max(0.0, this.gatol, this.grtol * d);
    }

    private static final double max(double d, double d2, double d3) {
        if (d3 >= d2) {
            return d3 >= d ? d3 : d;
        }
        return d2 >= d ? d2 : d;
    }

    public double getFMin() {
        return this.fmin_given ? this.fmin : Double.NaN;
    }

    public void setFMin(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            this.unsetFMin();
        } else {
            this.fmin = d;
            this.fmin_given = true;
        }
    }

    public void unsetFMin() {
        this.fmin = Double.NaN;
        this.fmin_given = false;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
        int[] nArray2 = new int[]{3, 6, 3, 2, 3, 5, 6, 9, 6, 8, 2, 4, 3, 8, 8, 12, 2, 4, 30};
        MoreThuenteLineSearch moreThuenteLineSearch = new MoreThuenteLineSearch(0.05, 0.1, 1.0E-8);
        block0: for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = nArray2[i];
            DoubleShapedVectorSpace doubleShapedVectorSpace = new DoubleShapedVectorSpace(new int[]{n2});
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            int n3 = -1;
            int n4 = 0;
            int n5 = 0;
            double d = 0.0;
            DoubleShapedVector doubleShapedVector = doubleShapedVectorSpace.wrap(dArray);
            DoubleShapedVector doubleShapedVector2 = doubleShapedVectorSpace.wrap(dArray2);
            MinPack1Tests.umipt(dArray, n, 1.0);
            NonLinearConjugateGradient nonLinearConjugateGradient = new NonLinearConjugateGradient(doubleShapedVectorSpace, 8, moreThuenteLineSearch);
            OptimTask optimTask = nonLinearConjugateGradient.start();
            while (true) {
                if (optimTask == OptimTask.COMPUTE_FG) {
                    d = MinPack1Tests.umobj(dArray, n);
                    ++n4;
                    MinPack1Tests.umgrd(dArray, dArray2, n);
                    ++n5;
                } else if (optimTask == OptimTask.NEW_X) {
                    if (++n3 == 0) {
                        System.out.println("\nProblem #" + n + " with " + n2 + " variables.");
                        System.out.println("|x0| = " + doubleShapedVector.norm2() + " f0 = " + d + " |g0| = " + doubleShapedVector2.norm2());
                    }
                } else {
                    if (optimTask == OptimTask.FINAL_X) {
                        System.out.println("|xn| = " + doubleShapedVector.norm2() + " f(xn) = " + d + " |g(xn)| = " + doubleShapedVector2.norm2());
                        System.out.println("in " + ++n3 + " iterations, " + n4 + " function calls and " + n5 + " gradient calls");
                        continue block0;
                    }
                    System.err.println("TiPi: NonLinearConjugateGradient, error/warning: " + (Object)((Object)optimTask));
                    continue block0;
                }
                optimTask = nonLinearConjugateGradient.iterate(doubleShapedVector, d, doubleShapedVector2);
            }
        }
        System.out.flush();
        System.err.flush();
    }
}

