/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.hessenberg;

import org.ejml.alg.block.BlockVectorOps;
import org.ejml.alg.block.decomposition.qr.BlockHouseHolder;
import org.ejml.data.D1Submatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalBlockHelper {
    public static void tridiagUpperRow(int n, D1Submatrix64F d1Submatrix64F, double[] dArray, D1Submatrix64F d1Submatrix64F2) {
        int n2 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        if (n2 <= 1) {
            return;
        }
        int n3 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        int n4 = Math.min(n3 - 1, n2);
        int n5 = Math.min(n3, n2);
        for (int i = 0; i < n4; ++i) {
            BlockHouseHolder.computeHouseHolderRow(n, d1Submatrix64F, dArray, i);
            double d = dArray[d1Submatrix64F.row0 + i];
            TridiagonalBlockHelper.computeY(n, d1Submatrix64F, d1Submatrix64F2, i, d);
            TridiagonalBlockHelper.computeRowOfV(n, d1Submatrix64F, d1Submatrix64F2, i, d);
            if (i + 1 >= n5) continue;
            TridiagonalBlockHelper.applyReflectorsToRow(n, d1Submatrix64F, d1Submatrix64F2, i + 1);
        }
    }

    public static void computeW_row(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, double[] dArray, int n2) {
        int n3 = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        CommonOps.set(d1Submatrix64F2.original, 0.0);
        BlockHouseHolder.scale_row(n, d1Submatrix64F, d1Submatrix64F2, 0, 1, -dArray[n2++]);
        int n4 = Math.min(n3, d1Submatrix64F2.col1 - d1Submatrix64F2.col0);
        for (int i = 1; i < n4; ++i) {
            double d = -dArray[n2++];
            for (int j = 0; j < i; ++j) {
                double d2 = BlockHouseHolder.innerProdRow(n, d1Submatrix64F, i, d1Submatrix64F, j, 1);
                BlockVectorOps.add_row(n, d1Submatrix64F2, i, 1.0, d1Submatrix64F2, j, d * d2, d1Submatrix64F2, i, 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
            }
            BlockHouseHolder.add_row(n, d1Submatrix64F, i, d, d1Submatrix64F2, i, 1.0, d1Submatrix64F2, i, 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        }
    }

    public static void computeV_blockVector(int n, D1Submatrix64F d1Submatrix64F, double[] dArray, D1Submatrix64F d1Submatrix64F2) {
        int n2 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        if (n2 <= 1) {
            return;
        }
        int n3 = d1Submatrix64F.col1 - d1Submatrix64F.col0;
        int n4 = Math.min(n3 - 1, n2);
        for (int i = 0; i < n4; ++i) {
            double d = dArray[d1Submatrix64F.row0 + i];
            TridiagonalBlockHelper.computeY(n, d1Submatrix64F, d1Submatrix64F2, i, d);
            TridiagonalBlockHelper.computeRowOfV(n, d1Submatrix64F, d1Submatrix64F2, i, d);
        }
    }

    public static void applyReflectorsToRow(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, int n2) {
        int n3 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        double[] dArray = d1Submatrix64F.original.data;
        double[] dArray2 = d1Submatrix64F2.original.data;
        for (int i = 0; i < n2; ++i) {
            int n4 = Math.min(n, d1Submatrix64F.col1 - d1Submatrix64F.col0);
            int n5 = d1Submatrix64F.original.numCols * d1Submatrix64F.row0 + n3 * d1Submatrix64F.col0 + i * n4 + n2;
            int n6 = d1Submatrix64F2.original.numCols * d1Submatrix64F2.row0 + n3 * d1Submatrix64F2.col0 + i * n4 + n2;
            double d = i + 1 == n2 ? 1.0 : dArray[n5];
            double d2 = dArray2[n6];
            double d3 = d1Submatrix64F.get(i, i + 1);
            d1Submatrix64F.set(i, i + 1, 1.0);
            BlockVectorOps.add_row(n, d1Submatrix64F, n2, 1.0, d1Submatrix64F2, i, d, d1Submatrix64F, n2, n2, d1Submatrix64F.col1 - d1Submatrix64F.col0);
            BlockVectorOps.add_row(n, d1Submatrix64F, n2, 1.0, d1Submatrix64F, i, d2, d1Submatrix64F, n2, n2, d1Submatrix64F.col1 - d1Submatrix64F.col0);
            d1Submatrix64F.set(i, i + 1, d3);
        }
    }

    public static void computeY(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, int n2, double d) {
        TridiagonalBlockHelper.multA_u(n, d1Submatrix64F, d1Submatrix64F2, n2);
        for (int i = 0; i < n2; ++i) {
            double d2 = BlockHouseHolder.innerProdRow(n, d1Submatrix64F, n2, d1Submatrix64F2, i, 1);
            double d3 = BlockHouseHolder.innerProdRow(n, d1Submatrix64F, n2, d1Submatrix64F, i, 1);
            BlockVectorOps.add_row(n, d1Submatrix64F2, n2, 1.0, d1Submatrix64F, i, d2, d1Submatrix64F2, n2, n2 + 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
            BlockVectorOps.add_row(n, d1Submatrix64F2, n2, 1.0, d1Submatrix64F2, i, d3, d1Submatrix64F2, n2, n2 + 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        }
        BlockVectorOps.scale_row(n, d1Submatrix64F2, n2, -d, d1Submatrix64F2, n2, n2 + 1, d1Submatrix64F2.col1 - d1Submatrix64F2.col0);
    }

    public static void multA_u(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, int n2) {
        int n3 = d1Submatrix64F.row1 - d1Submatrix64F.row0;
        for (int i = n2 + 1; i < n3; ++i) {
            double d = TridiagonalBlockHelper.innerProdRowSymm(n, d1Submatrix64F, n2, d1Submatrix64F, i, 1);
            d1Submatrix64F2.set(n2, i, d);
        }
    }

    public static double innerProdRowSymm(int n, D1Submatrix64F d1Submatrix64F, int n2, D1Submatrix64F d1Submatrix64F2, int n3, int n4) {
        int n5 = n2 + n4;
        if (n5 + d1Submatrix64F2.col0 >= d1Submatrix64F2.col1) {
            return 0.0;
        }
        if (n5 < n3) {
            double d = d1Submatrix64F2.get(n5, n3);
            d += BlockVectorOps.dot_row_col(n, d1Submatrix64F, n2, d1Submatrix64F2, n3, n5 + 1, n3);
            return d += BlockVectorOps.dot_row(n, d1Submatrix64F, n2, d1Submatrix64F2, n3, n3, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        }
        double d = d1Submatrix64F2.get(n3, n5);
        return d += BlockVectorOps.dot_row(n, d1Submatrix64F, n2, d1Submatrix64F2, n3, n5 + 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
    }

    public static void computeRowOfV(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, int n2, double d) {
        double d2 = BlockHouseHolder.innerProdRow(n, d1Submatrix64F, n2, d1Submatrix64F2, n2, 1);
        double d3 = d1Submatrix64F.get(n2, n2 + 1);
        d1Submatrix64F.set(n2, n2 + 1, 1.0);
        BlockVectorOps.add_row(n, d1Submatrix64F2, n2, 1.0, d1Submatrix64F, n2, -0.5 * d * d2, d1Submatrix64F2, n2, n2 + 1, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        d1Submatrix64F.set(n2, n2 + 1, d3);
    }
}

