/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.block.decomposition.hessenberg;

import org.ejml.alg.block.BlockInnerMultiplication;
import org.ejml.alg.block.BlockMultiplication;
import org.ejml.alg.block.decomposition.hessenberg.TridiagonalBlockHelper;
import org.ejml.alg.block.decomposition.qr.BlockMatrix64HouseholderQR;
import org.ejml.alg.dense.decomposition.hessenberg.TridiagonalSimilarDecomposition;
import org.ejml.data.BlockMatrix64F;
import org.ejml.data.D1Submatrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class TridiagonalDecompositionBlockHouseholder
implements TridiagonalSimilarDecomposition<BlockMatrix64F> {
    protected BlockMatrix64F A;
    protected BlockMatrix64F V = new BlockMatrix64F(1, 1);
    protected BlockMatrix64F tmp = new BlockMatrix64F(1, 1);
    protected double[] gammas = new double[1];
    protected DenseMatrix64F zerosM = new DenseMatrix64F(1, 1);

    @Override
    public BlockMatrix64F getT(BlockMatrix64F blockMatrix64F) {
        if (blockMatrix64F == null) {
            blockMatrix64F = new BlockMatrix64F(this.A.numRows, this.A.numCols, this.A.blockLength);
        } else {
            if (blockMatrix64F.numRows != this.A.numRows || blockMatrix64F.numCols != this.A.numCols) {
                throw new IllegalArgumentException("T must have the same dimensions as the input matrix");
            }
            CommonOps.set(blockMatrix64F, 0.0);
        }
        blockMatrix64F.set(0, 0, this.A.data[0]);
        for (int i = 1; i < this.A.numRows; ++i) {
            double d = this.A.get(i - 1, i);
            blockMatrix64F.set(i, i, this.A.get(i, i));
            blockMatrix64F.set(i - 1, i, d);
            blockMatrix64F.set(i, i - 1, d);
        }
        return blockMatrix64F;
    }

    @Override
    public BlockMatrix64F getQ(BlockMatrix64F blockMatrix64F, boolean bl) {
        blockMatrix64F = BlockMatrix64HouseholderQR.initializeQ(blockMatrix64F, this.A.numRows, this.A.numCols, this.A.blockLength, false);
        int n = Math.min(this.A.blockLength, this.A.numRows);
        this.V.reshape(n, this.A.numCols, false);
        this.tmp.reshape(n, this.A.numCols, false);
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(blockMatrix64F);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(this.A);
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(this.V);
        D1Submatrix64F d1Submatrix64F4 = new D1Submatrix64F(this.tmp);
        int n2 = this.A.numRows;
        int n3 = n2 - n2 % this.A.blockLength;
        if (n3 == n2) {
            n3 -= this.A.blockLength;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        for (int i = n3; i >= 0; i -= this.A.blockLength) {
            int n4 = Math.min(this.A.blockLength, n2 - i);
            d1Submatrix64F3.col0 = i;
            d1Submatrix64F3.row1 = n4;
            d1Submatrix64F3.original.reshape(d1Submatrix64F3.row1, d1Submatrix64F3.col1, false);
            if (bl) {
                d1Submatrix64F4.row0 = i;
                d1Submatrix64F4.row1 = this.A.numCols;
                d1Submatrix64F4.col0 = 0;
                d1Submatrix64F4.col1 = n4;
            } else {
                d1Submatrix64F4.col0 = i;
                d1Submatrix64F4.row1 = n4;
            }
            d1Submatrix64F4.original.reshape(d1Submatrix64F4.row1, d1Submatrix64F4.col1, false);
            d1Submatrix64F2.col0 = i;
            d1Submatrix64F2.row0 = i;
            d1Submatrix64F2.row1 = d1Submatrix64F2.row0 + n4;
            this.copyZeros(d1Submatrix64F2);
            TridiagonalBlockHelper.computeW_row(this.A.blockLength, d1Submatrix64F2, d1Submatrix64F3, this.gammas, i);
            d1Submatrix64F.col0 = i;
            d1Submatrix64F.row0 = i;
            if (bl) {
                BlockMultiplication.multTransB(this.A.blockLength, d1Submatrix64F, d1Submatrix64F2, d1Submatrix64F4);
            } else {
                BlockMultiplication.mult(this.A.blockLength, d1Submatrix64F2, d1Submatrix64F, d1Submatrix64F4);
            }
            if (bl) {
                BlockMultiplication.multPlus(this.A.blockLength, d1Submatrix64F4, d1Submatrix64F3, d1Submatrix64F);
            } else {
                BlockMultiplication.multPlusTransA(this.A.blockLength, d1Submatrix64F3, d1Submatrix64F4, d1Submatrix64F);
            }
            this.replaceZeros(d1Submatrix64F2);
        }
        return blockMatrix64F;
    }

    private void copyZeros(D1Submatrix64F d1Submatrix64F) {
        int n = Math.min(this.A.blockLength, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.zerosM.unsafe_set(i, j, d1Submatrix64F.get(i, j));
                d1Submatrix64F.set(i, j, 0.0);
            }
            if (d1Submatrix64F.col0 + i + 1 >= d1Submatrix64F.original.numCols) continue;
            this.zerosM.unsafe_set(i, i + 1, d1Submatrix64F.get(i, i + 1));
            d1Submatrix64F.set(i, i + 1, 1.0);
        }
    }

    private void replaceZeros(D1Submatrix64F d1Submatrix64F) {
        int n = Math.min(this.A.blockLength, d1Submatrix64F.col1 - d1Submatrix64F.col0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                d1Submatrix64F.set(i, j, this.zerosM.get(i, j));
            }
            if (d1Submatrix64F.col0 + i + 1 >= d1Submatrix64F.original.numCols) continue;
            d1Submatrix64F.set(i, i + 1, this.zerosM.get(i, i + 1));
        }
    }

    @Override
    public void getDiagonal(double[] dArray, double[] dArray2) {
        dArray[0] = this.A.data[0];
        for (int i = 1; i < this.A.numRows; ++i) {
            dArray[i] = this.A.get(i, i);
            dArray2[i - 1] = this.A.get(i - 1, i);
        }
    }

    @Override
    public boolean decompose(BlockMatrix64F blockMatrix64F) {
        if (blockMatrix64F.numCols != blockMatrix64F.numRows) {
            throw new IllegalArgumentException("Input matrix must be square.");
        }
        this.init(blockMatrix64F);
        D1Submatrix64F d1Submatrix64F = new D1Submatrix64F(this.A);
        D1Submatrix64F d1Submatrix64F2 = new D1Submatrix64F(this.V);
        D1Submatrix64F d1Submatrix64F3 = new D1Submatrix64F(this.A);
        int n = blockMatrix64F.numCols;
        for (int i = 0; i < n; i += this.A.blockLength) {
            int n2 = Math.min(this.A.blockLength, this.A.numRows - i);
            d1Submatrix64F.col0 = d1Submatrix64F3.col0 = i;
            d1Submatrix64F.row0 = d1Submatrix64F3.row0 = i;
            d1Submatrix64F3.row1 = d1Submatrix64F3.row0 + n2;
            d1Submatrix64F2.col0 = i;
            d1Submatrix64F2.row1 = n2;
            d1Submatrix64F2.original.reshape(d1Submatrix64F2.row1, d1Submatrix64F2.col1, false);
            TridiagonalBlockHelper.tridiagUpperRow(this.A.blockLength, d1Submatrix64F, this.gammas, d1Submatrix64F2);
            if (d1Submatrix64F3.row1 >= blockMatrix64F.numCols) continue;
            double d = d1Submatrix64F3.get(this.A.blockLength - 1, this.A.blockLength);
            d1Submatrix64F3.set(this.A.blockLength - 1, this.A.blockLength, 1.0);
            TridiagonalDecompositionBlockHouseholder.multPlusTransA(this.A.blockLength, d1Submatrix64F3, d1Submatrix64F2, d1Submatrix64F);
            TridiagonalDecompositionBlockHouseholder.multPlusTransA(this.A.blockLength, d1Submatrix64F2, d1Submatrix64F3, d1Submatrix64F);
            d1Submatrix64F3.set(this.A.blockLength - 1, this.A.blockLength, d);
        }
        return true;
    }

    public static void multPlusTransA(int n, D1Submatrix64F d1Submatrix64F, D1Submatrix64F d1Submatrix64F2, D1Submatrix64F d1Submatrix64F3) {
        int n2 = Math.min(n, d1Submatrix64F.row1 - d1Submatrix64F.row0);
        for (int i = d1Submatrix64F3.row0 + n; i < d1Submatrix64F3.row1; i += n) {
            int n3 = Math.min(n, d1Submatrix64F3.row1 - i);
            int n4 = d1Submatrix64F.row0 * d1Submatrix64F.original.numCols + (i - d1Submatrix64F3.row0 + d1Submatrix64F.col0) * n2;
            for (int j = i; j < d1Submatrix64F3.col1; j += n) {
                int n5 = Math.min(n, d1Submatrix64F3.col1 - j);
                int n6 = i * d1Submatrix64F3.original.numCols + j * n3;
                int n7 = d1Submatrix64F2.row0 * d1Submatrix64F2.original.numCols + (j - d1Submatrix64F3.col0 + d1Submatrix64F2.col0) * n2;
                BlockInnerMultiplication.blockMultPlusTransA(d1Submatrix64F.original.data, d1Submatrix64F2.original.data, d1Submatrix64F3.original.data, n4, n7, n6, n2, n3, n5);
            }
        }
    }

    private void init(BlockMatrix64F blockMatrix64F) {
        this.A = blockMatrix64F;
        int n = Math.min(this.A.blockLength, this.A.numRows);
        this.V.reshape(n, this.A.numCols, this.A.blockLength, false);
        this.tmp.reshape(n, this.A.numCols, this.A.blockLength, false);
        if (this.gammas.length < this.A.numCols) {
            this.gammas = new double[this.A.numCols];
        }
        this.zerosM.reshape(this.A.blockLength, this.A.blockLength + 1, false);
    }

    @Override
    public boolean inputModified() {
        return true;
    }
}

