/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.SingularOperatorException;
import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class ScaleOperator
extends LinearEndomorphism {
    protected double scale = 1.0;

    public ScaleOperator(VectorSpace vectorSpace) {
        super(vectorSpace);
    }

    public ScaleOperator(VectorSpace vectorSpace, double d) {
        super(vectorSpace);
        this.scale = d;
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) {
        if (n == DIRECT || n == ADJOINT) {
            this.space._scale(vector, this.scale, vector2);
        } else if (this.scale != 0.0) {
            this.space._scale(vector, 1.0 / this.scale, vector2);
        } else {
            throw new SingularOperatorException();
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        this.scale = d;
    }
}

