/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.RandomEngine;

public class UniformDistribution
implements FloatGenerator,
DoubleGenerator {
    public static final double DEFAULT_INF = 0.0;
    public static final double DEFAULT_SUP = 1.0;
    protected RandomEngine engine;
    protected double inf;
    protected double sup;
    protected double pdfLevel;
    protected double scaleDouble;
    protected double biasDouble;
    protected float scaleFloat;
    protected float biasFloat;

    public UniformDistribution(double d, double d2) {
        this.engine = RandomEngine.NewDefaultEngine();
        this.setState(d, d2);
    }

    public UniformDistribution(int n, double d, double d2) {
        this.engine = RandomEngine.NewDefaultEngine(n);
        this.setState(d, d2);
    }

    public UniformDistribution(RandomEngine randomEngine, double d, double d2) {
        this.engine = randomEngine;
        this.setState(d, d2);
    }

    public UniformDistribution() {
        this(0.0, 1.0);
    }

    public UniformDistribution(int n) {
        this(n, 0.0, 1.0);
    }

    public UniformDistribution(RandomEngine randomEngine) {
        this(randomEngine, 0.0, 1.0);
    }

    public void reset(int n) {
        this.engine.reset(n);
    }

    public void setState(double d, double d2) {
        this.inf = Math.min(d, d2);
        this.sup = Math.max(d, d2);
        this.pdfLevel = this.sup > this.inf ? 1.0 / (this.sup - this.inf) : Double.POSITIVE_INFINITY;
        double d3 = this.engine.min();
        double d4 = this.engine.max();
        this.scaleDouble = (this.sup - this.inf) / (d4 - d3 + 1.0);
        this.biasDouble = ((d4 + d3) * this.scaleDouble - (this.inf + this.sup)) / 2.0;
        this.scaleFloat = (float)this.scaleDouble;
        this.biasFloat = (float)this.biasDouble;
    }

    @Override
    public float nextFloat() {
        return (float)this.engine.next() * this.scaleFloat - this.biasFloat;
    }

    @Override
    public double nextDouble() {
        return (double)this.engine.next() * this.scaleDouble - this.biasDouble;
    }

    public double getInf() {
        return this.inf;
    }

    public double getSup() {
        return this.sup;
    }

    public double cdf(double d) {
        if (d <= this.inf) {
            return 0.0;
        }
        if (d >= this.sup) {
            return 1.0;
        }
        return (d - this.inf) / (this.sup - this.inf);
    }

    public double pdf(double d) {
        if (d <= this.inf) {
            return 0.0;
        }
        if (d >= this.sup) {
            return 1.0;
        }
        return this.pdfLevel * (d - this.inf);
    }
}

