/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.FilterSet;
import ome.xml.model.Instrument;
import ome.xml.model.LightPath;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Dichroic
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Dichroic.class);
    private String id;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Instrument instrument;
    private List<FilterSet> filterSets = new ReferenceList<FilterSet>();
    private List<LightPath> lightPaths = new ReferenceList<LightPath>();

    public Dichroic() {
    }

    public Dichroic(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Dichroic(Dichroic orig) {
        super(orig);
        this.id = orig.id;
        this.annotationLinks = orig.annotationLinks;
        this.instrument = orig.instrument;
        this.filterSets = orig.filterSets;
        this.lightPaths = orig.lightPaths;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Dichroic missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        List<Element> AnnotationRef_nodeList = Dichroic.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkDichroic(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", (Object)reference.getClass());
        return false;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkDichroic(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkDichroic(this);
        return this.annotationLinks.remove(o);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    public int sizeOfLinkedFilterSetList() {
        return this.filterSets.size();
    }

    public List<FilterSet> copyLinkedFilterSetList() {
        return new ArrayList<FilterSet>(this.filterSets);
    }

    public FilterSet getLinkedFilterSet(int index) {
        return this.filterSets.get(index);
    }

    public FilterSet setLinkedFilterSet(int index, FilterSet o) {
        return this.filterSets.set(index, o);
    }

    public boolean linkFilterSet(FilterSet o) {
        return this.filterSets.add(o);
    }

    public boolean unlinkFilterSet(FilterSet o) {
        return this.filterSets.remove(o);
    }

    public int sizeOfLinkedLightPathList() {
        return this.lightPaths.size();
    }

    public List<LightPath> copyLinkedLightPathList() {
        return new ArrayList<LightPath>(this.lightPaths);
    }

    public LightPath getLinkedLightPath(int index) {
        return this.lightPaths.get(index);
    }

    public LightPath setLinkedLightPath(int index, LightPath o) {
        return this.lightPaths.set(index, o);
    }

    public boolean linkLightPath(LightPath o) {
        return this.lightPaths.add(o);
    }

    public boolean unlinkLightPath(LightPath o) {
        return this.lightPaths.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Dichroic_element) {
        if (Dichroic_element == null) {
            Dichroic_element = document.createElementNS(NAMESPACE, "Dichroic");
        }
        super.asXMLElement(document, Dichroic_element);
        if (this.id != null) {
            Dichroic_element.setAttribute("ID", this.id.toString());
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Dichroic_element.appendChild(child);
            }
        }
        if (this.instrument != null) {
            // empty if block
        }
        if (this.filterSets != null) {
            // empty if block
        }
        if (this.lightPaths != null) {
            // empty if block
        }
        return Dichroic_element;
    }
}

