/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.DoubleArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class DoubleShapedVectorSpace
extends ShapedVectorSpace {
    public DoubleShapedVectorSpace(Shape shape) {
        super(5, shape);
    }

    public DoubleShapedVectorSpace(int ... nArray) {
        super(5, nArray);
    }

    private double[] getData(Vector vector) {
        return ((DoubleShapedVector)vector).getData();
    }

    @Override
    public DoubleShapedVector create() {
        return new DoubleShapedVector(this);
    }

    @Override
    public DoubleShapedVector create(double d) {
        DoubleShapedVector doubleShapedVector = new DoubleShapedVector(this);
        ArrayOps.fill(doubleShapedVector.getData(), this.number, d);
        return doubleShapedVector;
    }

    @Override
    public DoubleShapedVector create(ShapedArray shapedArray) {
        return this.create(shapedArray, false);
    }

    @Override
    public DoubleShapedVector create(ShapedArray shapedArray, boolean bl) {
        this.checkShape(shapedArray);
        DoubleArray doubleArray = shapedArray.toDouble();
        return new DoubleShapedVector(this, doubleArray.flatten(bl && doubleArray == shapedArray));
    }

    public DoubleShapedVector create(DoubleArray doubleArray) {
        return this.create(doubleArray, false);
    }

    public DoubleShapedVector create(DoubleArray doubleArray, boolean bl) {
        this.checkShape(doubleArray);
        return new DoubleShapedVector(this, doubleArray.flatten(bl));
    }

    public DoubleShapedVector clone(DoubleShapedVector doubleShapedVector) {
        this.check(doubleShapedVector);
        return this._clone(doubleShapedVector);
    }

    protected DoubleShapedVector _clone(DoubleShapedVector doubleShapedVector) {
        DoubleShapedVector doubleShapedVector2 = new DoubleShapedVector(this);
        this._copy(doubleShapedVector2, doubleShapedVector);
        return doubleShapedVector2;
    }

    @Override
    protected DoubleShapedVector _clone(Vector vector) {
        return this._clone((DoubleShapedVector)vector);
    }

    public DoubleShapedVector wrap(double[] dArray) {
        return new DoubleShapedVector(this, dArray);
    }

    public void copy(Vector vector, double[] dArray) {
        this.check(vector);
        ArrayOps.copy(this.getData(vector), dArray);
    }

    @Override
    protected void _copy(Vector vector, Vector vector2) {
        if (vector != vector2) {
            System.arraycopy(this.getData(vector2), 0, this.getData(vector), 0, this.number);
        }
    }

    @Override
    protected void _swap(Vector vector, Vector vector2) {
        double[] dArray = this.getData(vector);
        double[] dArray2 = this.getData(vector2);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d = dArray[i];
            dArray[i] = dArray2[i];
            dArray2[i] = d;
        }
    }

    @Override
    protected void _fill(Vector vector, double d) {
        double[] dArray = this.getData(vector);
        for (int i = 0; i < this.number; ++i) {
            dArray[i] = d;
        }
    }

    @Override
    protected double _dot(Vector vector, Vector vector2) {
        return ArrayOps.dot(this.number, this.getData(vector), this.getData(vector2));
    }

    @Override
    protected double _dot(Vector vector, Vector vector2, Vector vector3) {
        return ArrayOps.dot(this.number, this.getData(vector), this.getData(vector2), this.getData(vector3));
    }

    @Override
    protected double _norm2(Vector vector) {
        return ArrayOps.norm2(this.getData(vector));
    }

    @Override
    protected double _norm1(Vector vector) {
        return ArrayOps.norm1(this.getData(vector));
    }

    @Override
    protected double _normInf(Vector vector) {
        return ArrayOps.normInf(this.getData(vector));
    }

    @Override
    protected void _scale(Vector vector, double d) {
        if (d == 0.0) {
            this._fill(vector, 0.0);
        } else if (d != 1.0) {
            double[] dArray = this.getData(vector);
            int n = 0;
            while (n < this.number) {
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
    }

    @Override
    protected void _scale(Vector vector, double d, Vector vector2) {
        if (d == 0.0) {
            this._fill(vector, 0.0);
        } else if (d == 1.0) {
            this._copy(vector, vector2);
        } else {
            double[] dArray = this.getData(vector2);
            double[] dArray2 = this.getData(vector);
            for (int i = 0; i < this.number; ++i) {
                dArray2[i] = d * dArray[i];
            }
        }
    }

    @Override
    protected void _combine(Vector vector, double d, Vector vector2, double d2, Vector vector3) {
        ArrayOps.combine(this.getData(vector), this.number, d, this.getData(vector2), d2, this.getData(vector3));
    }

    @Override
    protected void _combine(Vector vector, double d, Vector vector2, double d2, Vector vector3, double d3, Vector vector4) {
        ArrayOps.combine(this.getData(vector), this.number, d, this.getData(vector2), d2, this.getData(vector3), d3, this.getData(vector4));
    }

    @Override
    protected void _multiply(Vector vector, Vector vector2, Vector vector3) {
        double[] dArray = this.getData(vector2);
        double[] dArray2 = this.getData(vector3);
        double[] dArray3 = this.getData(vector);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] * dArray2[i];
        }
    }
}

