/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tfloat.sampling;

import cern.colt.PersistentObject;
import cern.colt.Timer;
import cern.jet.random.tfloat.AbstractFloatDistribution;
import cern.jet.random.tfloat.engine.FloatRandomEngine;

public class FloatRandomSampler
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    long my_n;
    long my_N;
    long my_low;
    FloatRandomEngine my_RandomGenerator;

    public FloatRandomSampler(long n, long N, long low, FloatRandomEngine randomGenerator) {
        if (n < 0L) {
            throw new IllegalArgumentException("n must be >= 0");
        }
        if (n > N) {
            throw new IllegalArgumentException("n must by <= N");
        }
        this.my_n = n;
        this.my_N = N;
        this.my_low = low;
        if (randomGenerator == null) {
            randomGenerator = AbstractFloatDistribution.makeDefaultGenerator();
        }
        this.my_RandomGenerator = randomGenerator;
    }

    @Override
    public Object clone() {
        FloatRandomSampler copy = (FloatRandomSampler)super.clone();
        copy.my_RandomGenerator = (FloatRandomEngine)this.my_RandomGenerator.clone();
        return copy;
    }

    public static void main(String[] args) {
        long n = Long.parseLong(args[0]);
        long N = Long.parseLong(args[1]);
        long low = Long.parseLong(args[2]);
        int chunkSize = Integer.parseInt(args[3]);
        int times = Integer.parseInt(args[4]);
        FloatRandomSampler.test(n, N, low, chunkSize, times);
    }

    public void nextBlock(int count, long[] values, int fromIndex) {
        if ((long)count > this.my_n) {
            throw new IllegalArgumentException("Random sample exhausted.");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Negative count.");
        }
        if (count == 0) {
            return;
        }
        FloatRandomSampler.sample(this.my_n, this.my_N, count, this.my_low, values, fromIndex, this.my_RandomGenerator);
        long lastSample = values[fromIndex + count - 1];
        this.my_n -= (long)count;
        this.my_N = this.my_N - lastSample - 1L + this.my_low;
        this.my_low = lastSample + 1L;
    }

    protected static void rejectMethodD(long n, long N, int count, long low, long[] values, int fromIndex, FloatRandomEngine randomGenerator) {
        int iter;
        long S;
        n = N - n;
        long chosen = -1L + low;
        long negalphainv = -13L;
        float nreal = n;
        float ninv = (float)(1.0 / (double)nreal);
        float Nreal = N;
        float Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)ninv);
        long qu1 = -n + 1L + N;
        float qu1real = -nreal + 1.0f + Nreal;
        while (n > 1L && count > 0) {
            float negSreal;
            float nmin1inv = (float)(1.0 / (-1.0 + (double)nreal));
            while (true) {
                long limit;
                float bottom;
                float X;
                if ((S = (long)(X = Nreal * (-Vprime + 1.0f))) >= qu1) {
                    Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)ninv);
                    continue;
                }
                float U = randomGenerator.raw();
                negSreal = -S;
                float y1 = (float)Math.exp(Math.log(U * Nreal / qu1real) * (double)nmin1inv);
                Vprime = y1 * (-X / Nreal + 1.0f) * (qu1real / (negSreal + qu1real));
                if ((double)Vprime <= 1.0) break;
                float y2 = 1.0f;
                float top = -1.0f + Nreal;
                if (n - 1L > S) {
                    bottom = -nreal + Nreal;
                    limit = -S + N;
                } else {
                    bottom = -1.0f + negSreal + Nreal;
                    limit = qu1;
                }
                long t = N - 1L;
                while (t >= limit) {
                    y2 = y2 * top / bottom;
                    top -= 1.0f;
                    bottom -= 1.0f;
                    --t;
                }
                if ((double)(Nreal / (-X + Nreal)) >= (double)y1 * Math.exp(Math.log(y2) * (double)nmin1inv)) {
                    Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)nmin1inv);
                    break;
                }
                Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)ninv);
            }
            iter = count;
            if (S < (long)iter) {
                iter = (int)S;
            }
            count -= iter;
            while (--iter >= 0) {
                values[fromIndex++] = ++chosen;
            }
            ++chosen;
            N -= S + 1L;
            Nreal = negSreal + (-1.0f + Nreal);
            --n;
            nreal -= 1.0f;
            ninv = nmin1inv;
            qu1 = -S + qu1;
            qu1real = negSreal + qu1real;
        }
        if (count > 0) {
            S = (long)((float)N * Vprime);
            iter = count;
            if (S < (long)iter) {
                iter = (int)S;
            }
            count -= iter;
            while (--iter >= 0) {
                values[fromIndex++] = ++chosen;
            }
            ++chosen;
            while (--count >= 0) {
                values[fromIndex++] = ++chosen;
            }
        }
    }

    public static void sample(long n, long N, int count, long low, long[] values, int fromIndex, FloatRandomEngine randomGenerator) {
        if (n <= 0L || count <= 0) {
            return;
        }
        if ((long)count > n) {
            throw new IllegalArgumentException("count must not be greater than n");
        }
        if (randomGenerator == null) {
            randomGenerator = AbstractFloatDistribution.makeDefaultGenerator();
        }
        if ((long)count == N) {
            long val = low;
            int limit = fromIndex + count;
            int i = fromIndex;
            while (i < limit) {
                values[i++] = val++;
            }
            return;
        }
        if ((double)n < (double)N * 0.95) {
            FloatRandomSampler.sampleMethodD(n, N, count, low, values, fromIndex, randomGenerator);
        } else {
            FloatRandomSampler.rejectMethodD(n, N, count, low, values, fromIndex, randomGenerator);
        }
    }

    protected static void sampleMethodA(long n, long N, int count, long low, long[] values, int fromIndex, FloatRandomEngine randomGenerator) {
        long S;
        long chosen = -1L + low;
        float top = N - n;
        float Nreal = N;
        while (n >= 2L && count > 0) {
            float V = randomGenerator.raw();
            S = 0L;
            float quot = top / Nreal;
            while (quot > V) {
                ++S;
                quot = quot * (top -= 1.0f) / (Nreal -= 1.0f);
            }
            values[fromIndex++] = chosen += S + 1L;
            --count;
            Nreal -= 1.0f;
            --n;
        }
        if (count > 0) {
            S = (long)((float)Math.round(Nreal) * randomGenerator.raw());
            values[fromIndex] = chosen += S + 1L;
        }
    }

    protected static void sampleMethodD(long n, long N, int count, long low, long[] values, int fromIndex, FloatRandomEngine randomGenerator) {
        long S;
        long chosen = -1L + low;
        long negalphainv = -13L;
        float nreal = n;
        float ninv = (float)(1.0 / (double)nreal);
        float Nreal = N;
        float Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)ninv);
        long qu1 = -n + 1L + N;
        float qu1real = -nreal + 1.0f + Nreal;
        long threshold = -negalphainv * n;
        while (n > 1L && count > 0 && threshold < N) {
            float negSreal;
            float nmin1inv = (float)(1.0 / (-1.0 + (double)nreal));
            while (true) {
                long limit;
                float bottom;
                float X;
                if ((S = (long)(X = Nreal * (-Vprime + 1.0f))) >= qu1) {
                    Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)ninv);
                    continue;
                }
                float U = randomGenerator.raw();
                negSreal = -S;
                float y1 = (float)Math.exp(Math.log(U * Nreal / qu1real) * (double)nmin1inv);
                Vprime = y1 * (-X / Nreal + 1.0f) * (qu1real / (negSreal + qu1real));
                if ((double)Vprime <= 1.0) break;
                float y2 = 1.0f;
                float top = -1.0f + Nreal;
                if (n - 1L > S) {
                    bottom = -nreal + Nreal;
                    limit = -S + N;
                } else {
                    bottom = -1.0f + negSreal + Nreal;
                    limit = qu1;
                }
                long t = N - 1L;
                while (t >= limit) {
                    y2 = y2 * top / bottom;
                    top -= 1.0f;
                    bottom -= 1.0f;
                    --t;
                }
                if ((double)(Nreal / (-X + Nreal)) >= (double)y1 * Math.exp(Math.log(y2) * (double)nmin1inv)) {
                    Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)nmin1inv);
                    break;
                }
                Vprime = (float)Math.exp(Math.log(randomGenerator.raw()) * (double)ninv);
            }
            values[fromIndex++] = chosen += S + 1L;
            --count;
            N -= S + 1L;
            Nreal = negSreal + (-1.0f + Nreal);
            --n;
            nreal -= 1.0f;
            ninv = nmin1inv;
            qu1 = -S + qu1;
            qu1real = negSreal + qu1real;
            threshold += negalphainv;
        }
        if (count > 0) {
            if (n > 1L) {
                FloatRandomSampler.sampleMethodA(n, N, count, chosen + 1L, values, fromIndex, randomGenerator);
            } else {
                S = (long)((float)N * Vprime);
                values[fromIndex++] = chosen += S + 1L;
            }
        }
    }

    public static void test(long n, long N, long low, int chunkSize, int times) {
        long[] values = new long[chunkSize];
        long chunks = n / (long)chunkSize;
        Timer timer = new Timer().start();
        long t = times;
        while (--t >= 0L) {
            FloatRandomSampler sampler = new FloatRandomSampler(n, N, low, AbstractFloatDistribution.makeDefaultGenerator());
            long i = 0L;
            while (i < chunks) {
                sampler.nextBlock(chunkSize, values, 0);
                ++i;
            }
            int toDo = (int)(n - (long)chunkSize * chunks);
            if (toDo <= 0) continue;
            sampler.nextBlock(toDo, values, 0);
        }
        timer.stop();
        System.out.println("single run took " + timer.elapsedTime() / (double)times);
        System.out.println("Good bye.\n");
    }

    protected static void testNegAlphaInv(String[] args) {
    }
}

