/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.array.ArrayFactory;
import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.linalg.ArrayOps;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.random.FloatGenerator;

public class FloatShapedVector
extends ShapedVector {
    protected float[] data;

    public FloatShapedVector(FloatShapedVectorSpace floatShapedVectorSpace) {
        super(floatShapedVectorSpace);
        this.data = new float[floatShapedVectorSpace.getNumber()];
    }

    public FloatShapedVector(FloatShapedVectorSpace floatShapedVectorSpace, float[] fArray) {
        super(floatShapedVectorSpace);
        if (fArray == null || fArray.length != floatShapedVectorSpace.getNumber()) {
            throw new IllegalArgumentException("Array size not compatible with vector space.");
        }
        this.data = fArray;
    }

    @Override
    public FloatShapedVectorSpace getOwner() {
        return (FloatShapedVectorSpace)this.space;
    }

    @Override
    public FloatShapedVectorSpace getSpace() {
        return this.getOwner();
    }

    @Override
    public final double get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, double d) {
        this.data[n] = (float)d;
    }

    public final void set(int n, float f) {
        this.data[n] = f;
    }

    public void set(float[] fArray) {
        ArrayOps.copy(this.data, fArray);
    }

    public float[] getData() {
        return this.data;
    }

    public void fill(FloatGenerator floatGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = floatGenerator.nextFloat();
        }
    }

    @Override
    public FloatShapedVector create() {
        return this.getOwner().create();
    }

    @Override
    public FloatShapedVector clone() {
        return this.getOwner()._clone(this);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        ((ShapedVectorSpace)this.space).checkShape(shapedArray);
        float[] fArray = shapedArray.toFloat().flatten();
        if (fArray != this.data) {
            System.arraycopy(fArray, 0, this.data, 0, this.getNumber());
        }
    }

    @Override
    public FloatArray asShapedArray() {
        return ArrayFactory.wrap(this.data, this.getShape());
    }
}

