package plugins.tprovoost.Microscopy.MicroscopeLive;

import icy.canvas.IcyCanvas;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.util.StringUtil;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Hashtable;

import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.MicroscopeOverlayPreferences;

public class PainterInfoConfig extends Overlay
{
    private MicroscopeOverlayPreferences prefs = MicroscopeOverlayPreferences.getInstance();
    private Hashtable<String, String> dataToDisplay = new Hashtable<String, String>();
    private String exposure = null;
    private String timeCapture = null;
    private boolean displayHelp = true;

    public PainterInfoConfig()
    {
        super("Info Config");
    }

    @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas)
    {
        // ------------
        // Verifications before drawing
        // -----------
        if (!displayHelp || (g == null))
            return;

        // ----------
        // Variables
        // ----------
        int w = sequence.getWidth();
        int h = sequence.getHeight();

        // ------------
        // set the values
        // ------------
        try
        {
            double exp = MicroManager.getExposure();
            if (exp != -1)
            {
                exposure = "Exposure: " + StringUtil.toString(exp, 2) + " ms";
                dataToDisplay.put("exposure", exposure);
            }
            Calendar c = Calendar.getInstance();
            timeCapture = "Date: " + DateFormat.getDateInstance().format(c.getTime()) + " "
                    + DateFormat.getTimeInstance().format(c.getTime());
            dataToDisplay.put("timeCapture", timeCapture);
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        putData("help", "Alt + h: toggle help");

        // set the font
        Font f;
        if (w > h)
            f = g.getFont().deriveFont(12F * h / 512);
        else
            f = g.getFont().deriveFont(12F * w / 512);
        g.setFont(f);
        int fh = g.getFontMetrics().getHeight();

        // ------------------------------
        // Calculate the size of the box
        // ------------------------------
        int nbComponents = 0;
        int largestComponentWidth = -1;
        for (String s : dataToDisplay.values())
        {
            ++nbComponents;
            int wh = g.getFontMetrics().charsWidth(s.toCharArray(), 0, s.length());
            if (wh > largestComponentWidth)
                largestComponentWidth = wh;
        }

        // --------------------------
        // Fill the box with the data
        // --------------------------
        if (nbComponents == 0)
            return;
        g.setColor(prefs.getColor("Background"));
        g.fillRect(0, 0, largestComponentWidth + fh * 2, fh * nbComponents + fh / 2);
        g.setColor(prefs.getColor("Text"));
        int i = 1;
        for (String s : dataToDisplay.values())
        {
            g.drawString(s, fh, fh * i);
            ++i;
        }
    }

    public void putData(String key, String value)
    {
        dataToDisplay.put(key, value);
    }

    @Override
    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas)
    {
        if (e.isConsumed())
            return;

        if (e.isAltDown() && e.getKeyCode() == KeyEvent.VK_H)
        {
            displayHelp = !displayHelp;
            painterChanged();
            e.consume();
        }
    }
}