/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array4D;
import mitiv.array.Byte4D;
import mitiv.array.Double4D;
import mitiv.array.Float4D;
import mitiv.array.Int4D;
import mitiv.array.Long1D;
import mitiv.array.Long3D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short4D;
import mitiv.array.impl.FlatLong4D;
import mitiv.array.impl.StriddenLong4D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long4D
extends Array4D
implements LongArray {
    protected Long4D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    protected Long4D(int[] nArray) {
        super(nArray);
    }

    protected Long4D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2, int var3, int var4);

    public abstract void set(int var1, int var2, int var3, int var4, long var5);

    @Override
    public void fill(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, l);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, l);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) + l);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) + l);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) - l);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) - l);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, this.get(i, j, k, i2) * l);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, this.get(i3, k, j, i) * l);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, longFunction.apply(this.get(i, j, k, i2)));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, longFunction.apply(this.get(i3, k, j, i)));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, longGenerator.nextLong());
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, longGenerator.nextLong());
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                longScanner.update(this.get(i, j, k, i2));
                                continue;
                            }
                            longScanner.initialize(this.get(i, j, k, i2));
                            bl = true;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                longScanner.update(this.get(i3, k, j, i));
                                continue;
                            }
                            longScanner.initialize(this.get(i3, k, j, i));
                            bl = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long l = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            long l2 = this.get(i, j, k, i2);
                            if (l2 >= l) continue;
                            l = l2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            long l3 = this.get(i3, k, j, i);
                            if (l3 >= l) continue;
                            l = l3;
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long max() {
        long l = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            long l2 = this.get(i, j, k, i2);
                            if (l2 <= l) continue;
                            l = l2;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            long l3 = this.get(i3, k, j, i);
                            if (l3 <= l) continue;
                            l = l3;
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        long l2 = l = this.get(0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            long l3 = this.get(i, j, k, i2);
                            if (l3 < l) {
                                l = l3;
                            }
                            if (l3 <= l2) continue;
                            l2 = l3;
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            if (bl) {
                                bl = false;
                                continue;
                            }
                            long l4 = this.get(i3, k, j, i);
                            if (l4 < l) {
                                l = l4;
                            }
                            if (l4 <= l2) continue;
                            l2 = l4;
                        }
                    }
                }
            }
        }
        lArray[0] = l;
        lArray[1] = l2;
    }

    @Override
    public long sum() {
        long l = 0L;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            l += this.get(i, j, k, i2);
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            l += this.get(i3, k, j, i);
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte4D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            byArray[++n] = (byte)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Byte4D.wrap(byArray, this.getShape());
    }

    @Override
    public Short4D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            sArray[++n] = (short)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Short4D.wrap(sArray, this.getShape());
    }

    @Override
    public Int4D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            nArray[++n] = (int)this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Int4D.wrap(nArray, this.getShape());
    }

    @Override
    public Long4D toLong() {
        return this;
    }

    @Override
    public Float4D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            fArray[++n] = this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Float4D.wrap(fArray, this.getShape());
    }

    @Override
    public Double4D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            dArray[++n] = this.get(i2, k, j, i);
                        }
                    }
                }
            }
        }
        return Double4D.wrap(dArray, this.getShape());
    }

    @Override
    public Long4D copy() {
        return new FlatLong4D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long4D long4D = shapedArray.getType() == 3 ? (Long4D)shapedArray : (Long4D)shapedArray.toLong();
        if (this.getOrder() == 2 && long4D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            this.set(i, j, k, i2, long4D.get(i, j, k, i2));
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, long4D.get(i3, k, j, i));
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i2 = 0; i2 < this.dim1; ++i2) {
                            this.set(i2, k, j, i, (long)doubleShapedVector.get(++n));
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim4; ++i) {
                for (int j = 0; j < this.dim3; ++j) {
                    for (int k = 0; k < this.dim2; ++k) {
                        for (int i3 = 0; i3 < this.dim1; ++i3) {
                            this.set(i3, k, j, i, (long)floatShapedVector.get(++n));
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long4D create() {
        return new FlatLong4D(this.getShape());
    }

    public static Long4D create(int n, int n2, int n3, int n4) {
        return new FlatLong4D(n, n2, n3, n4);
    }

    public static Long4D create(int[] nArray) {
        return new FlatLong4D(nArray);
    }

    public static Long4D create(Shape shape) {
        return new FlatLong4D(shape);
    }

    public static Long4D wrap(long[] lArray, int n, int n2, int n3, int n4) {
        return new FlatLong4D(lArray, n, n2, n3, n4);
    }

    public static Long4D wrap(long[] lArray, int[] nArray) {
        return new FlatLong4D(lArray, nArray);
    }

    public static Long4D wrap(long[] lArray, Shape shape) {
        return new FlatLong4D(lArray, shape);
    }

    public static Long4D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new StriddenLong4D(lArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    @Override
    public abstract Long3D slice(int var1);

    @Override
    public abstract Long3D slice(int var1, int var2);

    @Override
    public abstract Long4D view(Range var1, Range var2, Range var3, Range var4);

    @Override
    public abstract Long4D view(int[] var1, int[] var2, int[] var3, int[] var4);

    @Override
    public abstract Long1D as1D();
}

