/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ArrayUtils;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.ConvolutionDouble1D;
import mitiv.deconv.ConvolutionDouble2D;
import mitiv.deconv.ConvolutionDouble3D;
import mitiv.deconv.ConvolutionFloat1D;
import mitiv.deconv.ConvolutionFloat2D;
import mitiv.deconv.ConvolutionFloat3D;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.ShapedLinearOperator;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.utils.FFTUtils;
import mitiv.utils.Timer;

public abstract class Convolution
extends ShapedLinearOperator {
    protected final int rank;
    protected final int type;
    protected final Shape workShape;
    protected final int[] inputOffsets;
    protected final boolean fastInput;
    protected final int[] outputOffsets;
    protected final boolean fastOutput;
    protected Timer timerForFFT = new Timer();
    protected Timer timer = new Timer();

    protected Convolution(ShapedVectorSpace shapedVectorSpace) {
        this(null, shapedVectorSpace, shapedVectorSpace);
    }

    protected Convolution(ShapedVectorSpace shapedVectorSpace, ShapedVectorSpace shapedVectorSpace2) {
        this(null, shapedVectorSpace, shapedVectorSpace2);
    }

    protected Convolution(Shape shape, ShapedVectorSpace shapedVectorSpace, ShapedVectorSpace shapedVectorSpace2) {
        this(shape, shapedVectorSpace, null, shapedVectorSpace2, null);
    }

    protected Convolution(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        super(shapedVectorSpace, shapedVectorSpace2);
        int n;
        this.type = shapedVectorSpace.getType();
        if (this.type != 4 && this.type != 5) {
            throw new IllegalArgumentException("Expecting a floating-point type");
        }
        if (shapedVectorSpace2.getType() != this.type) {
            throw new IllegalTypeException("Input and output spaces must have the same element type");
        }
        this.rank = shapedVectorSpace.getRank();
        if (shapedVectorSpace2.getShape().rank() != this.rank) {
            throw new IllegalTypeException("Input and output spaces must have the same rank");
        }
        if (shape == null) {
            int[] nArray3 = new int[this.rank];
            for (n = 0; n < this.rank; ++n) {
                nArray3[n] = FFTUtils.bestDimension(Math.max(shapedVectorSpace.getDimension(n), shapedVectorSpace2.getDimension(n)));
            }
            shape = new Shape(nArray3);
        } else {
            if (shape.rank() != this.rank) {
                throw new IllegalArgumentException("Bad number of work space dimensions");
            }
            for (int i = 0; i < this.rank; ++i) {
                if (shape.dimension(i) >= Math.max(shapedVectorSpace.getDimension(i), shapedVectorSpace2.getDimension(i))) continue;
                throw new IllegalArgumentException("Work space dimension(s) too small");
            }
        }
        this.workShape = shape;
        boolean bl = true;
        this.inputOffsets = new int[this.rank];
        if (nArray == null) {
            for (n = 0; n < this.rank; ++n) {
                this.inputOffsets[n] = shape.dimension(n) / 2 - shapedVectorSpace.getDimension(n) / 2;
                if (shapedVectorSpace.getDimension(n) == shape.dimension(n)) continue;
                bl = false;
            }
        } else {
            if (nArray.length != this.rank) {
                throw new IllegalArgumentException("Bad number of input offsets");
            }
            for (n = 0; n < this.rank; ++n) {
                if (nArray[n] < 0 || nArray[n] + shapedVectorSpace.getDimension(n) > shape.dimension(n)) {
                    throw new IllegalArgumentException("Out of bound input offset(s)");
                }
                this.inputOffsets[n] = nArray[n];
                if (shapedVectorSpace.getDimension(n) == shape.dimension(n)) continue;
                bl = false;
            }
        }
        this.fastInput = bl;
        bl = true;
        this.outputOffsets = new int[this.rank];
        if (nArray2 == null) {
            for (n = 0; n < this.rank; ++n) {
                this.outputOffsets[n] = shape.dimension(n) / 2 - shapedVectorSpace2.getDimension(n) / 2;
                if (shapedVectorSpace2.getDimension(n) == shape.dimension(n)) continue;
                bl = false;
            }
        } else {
            if (nArray2.length != this.rank) {
                throw new IllegalArgumentException("Bad number of output offsets");
            }
            for (n = 0; n < this.rank; ++n) {
                if (nArray2[n] < 0 || nArray2[n] + shapedVectorSpace2.getDimension(n) > shape.dimension(n)) {
                    throw new IllegalArgumentException("Out of bound output offset(s)");
                }
                this.outputOffsets[n] = nArray2[n];
                if (shapedVectorSpace2.getDimension(n) == shape.dimension(n)) continue;
                bl = false;
            }
        }
        this.fastOutput = bl;
    }

    public final int getRank() {
        return this.rank;
    }

    public final int getType() {
        return this.type;
    }

    public final int getNumberOfFrequencies() {
        long l = this.workShape.number();
        if (2L * l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many frequencies for 32-bit integers");
        }
        return (int)l;
    }

    public final Shape getWorkShape() {
        return this.workShape;
    }

    public static Convolution build(ShapedVectorSpace shapedVectorSpace) {
        return Convolution.build(shapedVectorSpace, shapedVectorSpace);
    }

    public static Convolution build(ShapedVectorSpace shapedVectorSpace, ShapedVectorSpace shapedVectorSpace2) {
        return Convolution.build(null, shapedVectorSpace, null, shapedVectorSpace2, null);
    }

    public static Convolution build(Shape shape, ShapedVectorSpace shapedVectorSpace, ShapedVectorSpace shapedVectorSpace2) {
        return Convolution.build(shape, shapedVectorSpace, null, shapedVectorSpace2, null);
    }

    public static Convolution build(Shape shape, ShapedVectorSpace shapedVectorSpace, int[] nArray, ShapedVectorSpace shapedVectorSpace2, int[] nArray2) {
        int n = shapedVectorSpace.getType();
        int n2 = shapedVectorSpace.getRank();
        switch (n) {
            case 4: {
                switch (n2) {
                    case 1: {
                        return new ConvolutionFloat1D(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
                    }
                    case 2: {
                        return new ConvolutionFloat2D(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
                    }
                    case 3: {
                        return new ConvolutionFloat3D(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
                    }
                }
                break;
            }
            case 5: {
                switch (n2) {
                    case 1: {
                        return new ConvolutionDouble1D(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
                    }
                    case 2: {
                        return new ConvolutionDouble2D(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
                    }
                    case 3: {
                        return new ConvolutionDouble3D(shape, shapedVectorSpace, nArray, shapedVectorSpace2, nArray2);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException("Only float and double types are implemented");
            }
        }
        throw new IllegalArgumentException("Only 1D, 2D and 3D convolution are implemented");
    }

    public abstract void forwardFFT();

    public abstract void backwardFFT();

    public abstract void push(ShapedVector var1, boolean var2);

    public abstract void pull(ShapedVector var1, boolean var2);

    public abstract void convolve(boolean var1);

    public static int[] center(Shape shape) {
        int n = shape.rank();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = shape.dimension(i) / 2;
        }
        return nArray;
    }

    public abstract void setPSF(ShapedVector var1);

    public void setPSF(ShapedArray shapedArray) {
        this.setPSF(shapedArray, null, false);
    }

    public void setPSF(ShapedArray shapedArray, int[] nArray) {
        this.setPSF(shapedArray, nArray, false);
    }

    public void setPSF(ShapedArray shapedArray, boolean bl) {
        this.setPSF(shapedArray, null, bl);
    }

    public abstract void setPSF(ShapedArray var1, int[] var2, boolean var3);

    protected ShapedArray adjustPSF(ShapedArray shapedArray, int[] nArray) {
        Shape shape = shapedArray.getShape();
        Shape shape2 = this.getInputSpace().getShape();
        int n = shape2.rank();
        if (shape.rank() != n) {
            throw new IllegalArgumentException("PSF rank not conformable");
        }
        if (nArray == null) {
            nArray = Convolution.center(shape);
        }
        if (nArray.length != n) {
            throw new IllegalArgumentException("Number of coordinates not conformable");
        }
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = shape.dimension(i);
            if (n3 > (n2 = shape2.dimension(i))) {
                throw new IllegalArgumentException("PSF dimension(s) too large");
            }
            int n4 = n2 / 2 - n3 / 2;
            nArray2[i] = -(n4 + nArray[i]);
        }
        return ArrayUtils.roll(ArrayUtils.pad(shapedArray, shape2), nArray2);
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) {
        if (n != DIRECT && n != ADJOINT) {
            throw new NotImplementedException("For now we do not implement inverse convolution operations (talk to a specialist if you ignore the dangers of doing that!)");
        }
        boolean bl = n == ADJOINT;
        this.push((ShapedVector)vector2, bl);
        this.convolve(bl);
        this.pull((ShapedVector)vector, bl);
    }

    protected static boolean checkPushPullArguments(int n, Shape shape, Shape shape2, int[] nArray) {
        boolean bl = true;
        if (shape == null || shape.rank() != n) {
            throw new IllegalArgumentException(String.format("The work space must have %d dimension(s)", n));
        }
        if (shape2 == null || shape2.rank() != n) {
            throw new IllegalArgumentException(String.format("The user space must have %d dimension(s)", n));
        }
        if (nArray == null) {
            for (int i = 0; i < n; ++i) {
                int n2 = shape.dimension(i);
                int n3 = shape2.dimension(i);
                if (n3 > n2) {
                    throw new IllegalArgumentException("User region is too large");
                }
                if (n3 == n2) continue;
                bl = false;
            }
        } else {
            if (nArray.length != n) {
                throw new IllegalArgumentException(String.format("The offsets must have %d element(s)", n));
            }
            for (int i = 0; i < n; ++i) {
                int n4 = shape.dimension(i);
                int n5 = shape2.dimension(i);
                if (nArray[i] < 0 || nArray[i] >= n4) {
                    throw new IllegalArgumentException("Out of range offset");
                }
                if (nArray[i] + n5 > n4) {
                    throw new IllegalArgumentException("User region beyond limits");
                }
                if (n5 == n4) continue;
                bl = false;
            }
        }
        return bl;
    }

    public void resetTimers() {
        this.timerForFFT.stop();
        this.timerForFFT.reset();
        this.timer.stop();
        this.timer.reset();
    }

    public double getElapsedTime() {
        return this.timer.getElapsedTime();
    }

    public double getElapsedTimeInFFT() {
        return this.timerForFFT.getElapsedTime();
    }
}

