/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.mapping.Mapping;
import mitiv.cost.CostFunction;
import mitiv.cost.WeightedData;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class GaussianLikelihood
implements CostFunction {
    protected final WeightedData weightedData;
    protected final Mapping directModel;
    protected final VectorSpace variableSpace;
    protected final ShapedVectorSpace dataSpace;
    protected ShapedVector work1 = null;
    protected boolean ignoreWeights = false;

    public GaussianLikelihood(WeightedData weightedData, Mapping mapping) {
        if (mapping.getOutputSpace() != weightedData.getDataSpace()) {
            throw new IllegalArgumentException("Output space of the direct model must be the data space");
        }
        this.directModel = mapping;
        this.variableSpace = mapping.getInputSpace();
        this.dataSpace = weightedData.getDataSpace();
        this.weightedData = weightedData;
    }

    @Override
    public final VectorSpace getInputSpace() {
        return this.variableSpace;
    }

    public final VectorSpace getVariableSpace() {
        return this.variableSpace;
    }

    public final ShapedVectorSpace getDataSpace() {
        return this.dataSpace;
    }

    public final ShapedVector getData() {
        return this.weightedData.getData();
    }

    public final ShapedVector getWeights() {
        return this.weightedData.getWeights();
    }

    public final boolean isSinglePrecision() {
        return this.weightedData.isSinglePrecision();
    }

    public final ShapedVector computeModel(ShapedVector shapedVector) {
        ShapedVector shapedVector2 = this.dataSpace.create();
        this.computeModel(shapedVector2, shapedVector);
        return shapedVector2;
    }

    public final void computeModel(ShapedVector shapedVector, Vector vector) {
        this.directModel.apply(shapedVector, vector);
    }

    protected final void computeResiduals(Vector vector) {
        if (this.work1 == null) {
            this.work1 = this.dataSpace.create();
        }
        this.computeModel(this.work1, vector);
        this.work1.add(-1.0, this.getData());
    }

    @Override
    public final double evaluate(double d, Vector vector) {
        this.dataSpace.check(vector);
        if (d == 0.0) {
            return 0.0;
        }
        this.computeResiduals(vector);
        double d2 = 0.0;
        if (this.ignoreWeights) {
            d2 = this.work1.norm2();
        } else if (this.isSinglePrecision()) {
            float[] fArray = ((FloatShapedVector)this.work1).getData();
            float[] fArray2 = ((FloatShapedVector)this.getWeights()).getData();
            for (int i = 0; i < fArray.length; ++i) {
                d2 += (double)(fArray2[i] * fArray[i] * fArray[i]);
            }
        } else {
            double[] dArray = ((DoubleShapedVector)this.work1).getData();
            double[] dArray2 = ((DoubleShapedVector)this.getWeights()).getData();
            for (int i = 0; i < dArray.length; ++i) {
                d2 += dArray2[i] * dArray[i] * dArray[i];
            }
        }
        return d / 2.0 * d2;
    }
}

