package plugins.tprovoost.sequenceblocks.importer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import icy.file.Loader;
import icy.file.SequenceFileImporter;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.util.ClassUtil;
import plugins.adufour.blocks.tools.input.InputBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarString;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * Block to select a SequenceFileImporter from all available ones.
 * 
 * @author Stephane
 */
public class SelectSequenceFileImporter extends Plugin implements InputBlock, PluginLibrary, PluginBundled
{
    final protected VarString importerName;
    final protected Var<PositionedSequenceFileImporter> importer;

    final protected Map<String, SequenceFileImporter> importersMap;

    public SelectSequenceFileImporter()
    {
        super();

        importerName = new VarString("Select importer", "");
        // build importer map
        importersMap = new HashMap<String, SequenceFileImporter>();

        for (SequenceFileImporter importer : Loader.getSequenceFileImporters())
        {
            String className = ClassUtil.getBaseClassName(importer.getClass().getName());
            final int ind = className.lastIndexOf('.');

            // just get final class name without package name
            if (ind > -1)
                className = className.substring(ind + 1, className.length());

            importersMap.put(className, importer);
        }

        final Set<String> importersName = importersMap.keySet();

        // initialize descriptors field
        importerName.setDefaultEditorModel(
                new ValueSelectionModel<String>(importersName.toArray(new String[importersName.size()]), "", false));

        importer = new Var<PositionedSequenceFileImporter>("importer", PositionedSequenceFileImporter.class);
    }

    @Override
    public void run()
    {
        final SequenceFileImporter imp = importersMap.get(importerName.getValue());

        // set importer
        if (imp != null)
            importer.setValue(new PositionedSequenceFileImporter(imp));
        else
            importer.setValue(null);
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("name", importerName);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("importer", importer);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
