/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.MutableGraphicsConfiguration;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.IntBuffer;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLGLCapabilities;

public class EGLGraphicsConfiguration
extends MutableGraphicsConfiguration
implements Cloneable {
    private static final String dbgCfgFailIntro = "Info: EGLConfig could not retrieve ";
    private static final String dbgCfgFailForConfig = " for config ";
    private static final String dbgCfgFailError = ", error ";
    private final GLCapabilitiesChooser chooser;

    public final long getNativeConfig() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfig();
    }

    public final int getNativeConfigID() {
        return ((EGLGLCapabilities)this.capabilitiesChosen).getEGLConfigID();
    }

    EGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, EGLGLCapabilities eGLGLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable);
        this.chooser = gLCapabilitiesChooser;
    }

    public static EGLGraphicsConfiguration create(GLCapabilitiesImmutable gLCapabilitiesImmutable, AbstractGraphicsScreen abstractGraphicsScreen, int n) {
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsScreen.getDevice();
        if (null == abstractGraphicsDevice || !(abstractGraphicsDevice instanceof EGLGraphicsDevice)) {
            throw new GLException("GraphicsDevice must be a valid EGLGraphicsDevice");
        }
        long l = abstractGraphicsDevice.getHandle();
        if (l == 0L) {
            throw new GLException("Invalid EGL display: " + abstractGraphicsDevice);
        }
        long l2 = EGLGraphicsConfiguration.EGLConfigId2EGLConfig(l, n);
        if (0L < l2) {
            GLRendererQuirks gLRendererQuirks = GLRendererQuirks.getStickyDeviceQuirks(GLDrawableFactory.getEGLFactory().getDefaultDevice());
            int n2 = GLGraphicsConfigurationUtil.getExclusiveWinAttributeBits(gLCapabilitiesImmutable);
            EGLGLCapabilities eGLGLCapabilities = EGLGraphicsConfiguration.EGLConfig2Capabilities(gLRendererQuirks, (EGLGraphicsDevice)abstractGraphicsDevice, gLCapabilitiesImmutable.getGLProfile(), l2, n2, false);
            return new EGLGraphicsConfiguration(abstractGraphicsScreen, eGLGLCapabilities, gLCapabilitiesImmutable, new DefaultGLCapabilitiesChooser());
        }
        return null;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    void updateGraphicsConfiguration() {
        CapabilitiesImmutable capabilitiesImmutable = this.getChosenCapabilities();
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(this.getScreen().getDevice(), capabilitiesImmutable).chooseGraphicsConfiguration(capabilitiesImmutable, this.getRequestedCapabilities(), this.chooser, this.getScreen(), 0);
        if (null != eGLGraphicsConfiguration) {
            this.setChosenCapabilities(eGLGraphicsConfiguration.getChosenCapabilities());
            if (DEBUG) {
                System.err.println("updateGraphicsConfiguration(1): " + this);
            }
        }
    }

    public static long EGLConfigId2EGLConfig(long l, int n) {
        IntBuffer intBuffer;
        PointerBuffer pointerBuffer;
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int[])new int[]{12328, n, 12344});
        if (!EGL.eglChooseConfig(l, intBuffer2, pointerBuffer = PointerBuffer.allocateDirect((int)1), 1, intBuffer = Buffers.newDirectIntBuffer((int)1))) {
            return 0L;
        }
        if (intBuffer.get(0) == 0) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    public static boolean isEGLConfigValid(long l, long l2) {
        if (0L == l2) {
            return false;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigAttrib(l, l2, 12328, intBuffer)) {
            int n = EGL.eglGetError();
            if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve EGL_CONFIG_ID for config " + EGLGraphicsConfiguration.toHexString(l2) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(n));
            }
            return false;
        }
        return true;
    }

    static int EGLConfigDrawableTypeBits(EGLGraphicsDevice eGLGraphicsDevice, long l) {
        int n = 0;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)1);
        if (!EGL.eglGetConfigAttrib(eGLGraphicsDevice.getHandle(), l, 12339, intBuffer)) {
            throw new GLException("Could not determine EGL_SURFACE_TYPE");
        }
        int n2 = intBuffer.get(0);
        if (0 != (n2 & 4)) {
            n |= 1;
        }
        if (0 != (n2 & 2)) {
            n |= 2;
        }
        if (0 != (n2 & 1)) {
            n |= 0xC;
        }
        return n;
    }

    public static EGLGLCapabilities EGLConfig2Capabilities(GLRendererQuirks gLRendererQuirks, EGLGraphicsDevice eGLGraphicsDevice, GLProfile gLProfile, long l, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        long l2 = eGLGraphicsDevice.getHandle();
        int[] nArray = new int[]{12328, 12352, 12334, 12327, 12324, 12323, 12322, 12321, 12326, 12325, 12340, 12343, 12342, 12341, 12337, 12512, 12513};
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int[])nArray);
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer((int)intBuffer.remaining());
        EGL.eglGetConfigAttributes(l2, l, intBuffer, intBuffer2);
        if (12328 != intBuffer.get(0)) {
            if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve ConfigID for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            return null;
        }
        int n5 = intBuffer2.get(0);
        if (12352 != intBuffer.get(1)) {
            if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve EGL_RENDERABLE_TYPE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            return null;
        }
        int n6 = intBuffer2.get(1);
        int n7 = gLRendererQuirks.exist(15) && 0 != (4 & n6) ? n6 | 0x40 : n6;
        if (12334 == intBuffer.get(2)) {
            n4 = intBuffer2.get(2);
        } else {
            if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve EGL_NATIVE_VISUAL_ID for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            n4 = 0;
        }
        EGLGLCapabilities eGLGLCapabilities = null;
        try {
            if (null == gLProfile) {
                gLProfile = EGLGLCapabilities.getCompatible(eGLGraphicsDevice, n7);
            }
            if (!EGLGLCapabilities.isCompatible(gLProfile, n7)) {
                if (DEBUG) {
                    System.err.println("config " + EGLGraphicsConfiguration.toHexString(l) + ": Requested GLProfile " + gLProfile + " with quirks " + gLRendererQuirks + " not compatible with EGL-RenderableType[" + EGLGLCapabilities.renderableTypeToString(null, n7) + "]");
                }
                return null;
            }
            eGLGLCapabilities = new EGLGLCapabilities(l, n5, n4, gLProfile, n7);
        }
        catch (GLException gLException) {
            if (DEBUG) {
                System.err.println("config " + EGLGraphicsConfiguration.toHexString(l) + ": " + gLException);
            }
            return null;
        }
        if (12327 == intBuffer.get(3)) {
            if (12368 == intBuffer2.get(3)) {
                eGLGLCapabilities.setHardwareAccelerated(false);
            }
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_CONFIG_CAVEAT for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (12324 == intBuffer.get(4)) {
            eGLGLCapabilities.setRedBits(intBuffer2.get(4));
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_RED_SIZE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (12323 == intBuffer.get(5)) {
            eGLGLCapabilities.setGreenBits(intBuffer2.get(5));
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_GREEN_SIZE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (12322 == intBuffer.get(6)) {
            eGLGLCapabilities.setBlueBits(intBuffer2.get(6));
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_BLUE_SIZE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (12321 == intBuffer.get(7)) {
            eGLGLCapabilities.setAlphaBits(intBuffer2.get(7));
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_ALPHA_SIZE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (12326 == intBuffer.get(8)) {
            eGLGLCapabilities.setStencilBits(intBuffer2.get(8));
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_STENCIL_SIZE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (12325 == intBuffer.get(9)) {
            eGLGLCapabilities.setDepthBits(intBuffer2.get(9));
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_DEPTH_SIZE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (bl) {
            eGLGLCapabilities.setBackgroundOpaque(false);
        } else if (12340 == intBuffer.get(10)) {
            eGLGLCapabilities.setBackgroundOpaque(intBuffer2.get(10) != 12370);
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_TRANSPARENT_TYPE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (!eGLGLCapabilities.isBackgroundOpaque()) {
            if (12343 == intBuffer.get(11)) {
                n3 = intBuffer2.get(11);
                eGLGLCapabilities.setTransparentRedValue(-1 == n3 ? -1 : n3);
            } else if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve EGL_TRANSPARENT_RED_VALUE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            if (12342 == intBuffer.get(12)) {
                n3 = intBuffer2.get(12);
                eGLGLCapabilities.setTransparentGreenValue(-1 == n3 ? -1 : n3);
            } else if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve EGL_TRANSPARENT_GREEN_VALUE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
            if (12341 == intBuffer.get(13)) {
                n3 = intBuffer2.get(13);
                eGLGLCapabilities.setTransparentBlueValue(-1 == n3 ? -1 : n3);
            } else if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve EGL_TRANSPARENT_BLUE_VALUE for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
        }
        if (12337 == intBuffer.get(14)) {
            n3 = intBuffer2.get(14);
            eGLGLCapabilities.setSampleBuffers(n3 > 0);
            eGLGLCapabilities.setNumSamples(n3);
        } else if (DEBUG) {
            System.err.println("Info: EGLConfig could not retrieve EGL_SAMPLES for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
        }
        if (!eGLGLCapabilities.getSampleBuffers() && 12512 == intBuffer.get(15)) {
            int n8 = n3 = intBuffer2.get(15) > 0 ? 1 : 0;
            if (n3 != 0 && 12513 == intBuffer.get(16)) {
                eGLGLCapabilities.setSampleExtension("NV_coverage_sample");
                eGLGLCapabilities.setSampleBuffers(true);
                eGLGLCapabilities.setNumSamples(intBuffer2.get(16));
            } else if (DEBUG) {
                System.err.println("Info: EGLConfig could not retrieve EGL_COVERAGE_SAMPLES_NV for config " + EGLGraphicsConfiguration.toHexString(l) + dbgCfgFailError + EGLGraphicsConfiguration.toHexString(EGL.eglGetError()));
            }
        }
        if (0 == (n2 = n & (n3 = EGLGraphicsConfiguration.EGLConfigDrawableTypeBits(eGLGraphicsDevice, l)))) {
            return null;
        }
        return (EGLGLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(eGLGraphicsDevice, n2, eGLGLCapabilities);
    }

    public static IntBuffer GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        int n;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)32);
        int n2 = 0;
        intBuffer.put(n2++, 12339);
        if (gLCapabilitiesImmutable.isOnscreen()) {
            n = 4;
        } else if (gLCapabilitiesImmutable.isFBO()) {
            n = 1;
        } else if (gLCapabilitiesImmutable.isPBuffer()) {
            n = 1;
        } else if (gLCapabilitiesImmutable.isBitmap()) {
            n = 2;
        } else {
            throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
        }
        intBuffer.put(n2++, n);
        intBuffer.put(n2++, 12324);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getRedBits());
        intBuffer.put(n2++, 12323);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getGreenBits());
        intBuffer.put(n2++, 12322);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getBlueBits());
        if (gLCapabilitiesImmutable.getAlphaBits() > 0) {
            intBuffer.put(n2++, 12321);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getAlphaBits());
        }
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            intBuffer.put(n2++, 12326);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getStencilBits());
        }
        intBuffer.put(n2++, 12325);
        intBuffer.put(n2++, gLCapabilitiesImmutable.getDepthBits());
        if (gLCapabilitiesImmutable.getSampleBuffers()) {
            if (gLCapabilitiesImmutable.getSampleExtension().equals("NV_coverage_sample")) {
                intBuffer.put(n2++, 12512);
                intBuffer.put(n2++, 1);
                intBuffer.put(n2++, 12513);
                intBuffer.put(n2++, gLCapabilitiesImmutable.getNumSamples());
            } else {
                intBuffer.put(n2++, 12338);
                intBuffer.put(n2++, 1);
                intBuffer.put(n2++, 12337);
                intBuffer.put(n2++, gLCapabilitiesImmutable.getNumSamples());
            }
        }
        intBuffer.put(n2++, 12340);
        intBuffer.put(n2++, gLCapabilitiesImmutable.isBackgroundOpaque() ? 12344 : 12340);
        if (!gLCapabilitiesImmutable.isBackgroundOpaque()) {
            intBuffer.put(n2++, 12343);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getTransparentRedValue() >= 0 ? gLCapabilitiesImmutable.getTransparentRedValue() : -1);
            intBuffer.put(n2++, 12342);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getTransparentGreenValue() >= 0 ? gLCapabilitiesImmutable.getTransparentGreenValue() : -1);
            intBuffer.put(n2++, 12341);
            intBuffer.put(n2++, gLCapabilitiesImmutable.getTransparentBlueValue() >= 0 ? gLCapabilitiesImmutable.getTransparentBlueValue() : -1);
        }
        intBuffer.put(n2++, 12352);
        if (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES1()) {
            intBuffer.put(n2++, 1);
        } else if (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES2()) {
            intBuffer.put(n2++, 4);
        } else if (gLCapabilitiesImmutable.getGLProfile().usesNativeGLES3()) {
            if (GLRendererQuirks.existStickyDeviceQuirk(GLDrawableFactory.getEGLFactory().getDefaultDevice(), 15)) {
                intBuffer.put(n2++, 4);
            } else {
                intBuffer.put(n2++, 64);
            }
        } else {
            intBuffer.put(n2++, 8);
        }
        intBuffer.put(n2++, 12344);
        return intBuffer;
    }

    public static IntBuffer CreatePBufferSurfaceAttribList(int n, int n2, int n3) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)16);
        int n4 = 0;
        intBuffer.put(n4++, 12375);
        intBuffer.put(n4++, n);
        intBuffer.put(n4++, 12374);
        intBuffer.put(n4++, n2);
        intBuffer.put(n4++, 12416);
        intBuffer.put(n4++, n3);
        intBuffer.put(n4++, 12417);
        intBuffer.put(n4++, 12380 == n3 ? 12380 : 12383);
        intBuffer.put(n4++, 12344);
        return intBuffer;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getScreen() + ",\n\teglConfigHandle " + EGLGraphicsConfiguration.toHexString(this.getNativeConfig()) + ", eglConfigID " + EGLGraphicsConfiguration.toHexString(this.getNativeConfigID()) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

