/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte3D;
import mitiv.array.Double3D;
import mitiv.array.Float3D;
import mitiv.array.Int1D;
import mitiv.array.Int2D;
import mitiv.array.IntArray;
import mitiv.array.Long3D;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatInt3D;
import mitiv.array.impl.StriddenInt3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int3D
extends Array3D
implements IntArray {
    protected Int3D(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected Int3D(int[] nArray) {
        super(nArray);
    }

    protected Int3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, int var4);

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, n);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, n);
                    }
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) + n);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) + n);
                    }
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) - n);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) - n);
                    }
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) * n);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) * n);
                    }
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, intFunction.apply(this.get(i, j, k)));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, intFunction.apply(this.get(k, j, i)));
                    }
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, intGenerator.nextInt());
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, intGenerator.nextInt());
                    }
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            intScanner.update(this.get(i, j, k));
                            continue;
                        }
                        intScanner.initialize(this.get(i, j, k));
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            intScanner.update(this.get(k, j, i));
                            continue;
                        }
                        intScanner.initialize(this.get(k, j, i));
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n2 = this.get(i, j, k);
                        if (n2 >= n) continue;
                        n = n2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n3 = this.get(k, j, i);
                        if (n3 >= n) continue;
                        n = n3;
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n2 = this.get(i, j, k);
                        if (n2 <= n) continue;
                        n = n2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n3 = this.get(k, j, i);
                        if (n3 <= n) continue;
                        n = n3;
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n3 = this.get(i, j, k);
                        if (n3 < n) {
                            n = n3;
                        }
                        if (n3 <= n2) continue;
                        n2 = n3;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        int n4 = this.get(k, j, i);
                        if (n4 < n) {
                            n = n4;
                        }
                        if (n4 <= n2) continue;
                        n2 = n4;
                    }
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        n += this.get(i, j, k);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        n += this.get(k, j, i);
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        byArray[++n] = (byte)this.get(k, j, i);
                    }
                }
            }
        }
        return Byte3D.wrap(byArray, this.getShape());
    }

    @Override
    public Short3D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        sArray[++n] = (short)this.get(k, j, i);
                    }
                }
            }
        }
        return Short3D.wrap(sArray, this.getShape());
    }

    @Override
    public Int3D toInt() {
        return this;
    }

    @Override
    public Long3D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        lArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Long3D.wrap(lArray, this.getShape());
    }

    @Override
    public Float3D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        fArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Float3D.wrap(fArray, this.getShape());
    }

    @Override
    public Double3D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        dArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Double3D.wrap(dArray, this.getShape());
    }

    @Override
    public Int3D copy() {
        return new FlatInt3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int3D int3D = shapedArray.getType() == 2 ? (Int3D)shapedArray : (Int3D)shapedArray.toInt();
        if (this.getOrder() == 2 && int3D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, int3D.get(i, j, k));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, int3D.get(k, j, i));
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (int)doubleShapedVector.get(++n));
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (int)floatShapedVector.get(++n));
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int3D create() {
        return new FlatInt3D(this.getShape());
    }

    public static Int3D create(int n, int n2, int n3) {
        return new FlatInt3D(n, n2, n3);
    }

    public static Int3D create(int[] nArray) {
        return new FlatInt3D(nArray);
    }

    public static Int3D create(Shape shape) {
        return new FlatInt3D(shape);
    }

    public static Int3D wrap(int[] nArray, int n, int n2, int n3) {
        return new FlatInt3D(nArray, n, n2, n3);
    }

    public static Int3D wrap(int[] nArray, int[] nArray2) {
        return new FlatInt3D(nArray, nArray2);
    }

    public static Int3D wrap(int[] nArray, Shape shape) {
        return new FlatInt3D(nArray, shape);
    }

    public static Int3D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new StriddenInt3D(nArray, n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public abstract Int2D slice(int var1);

    @Override
    public abstract Int2D slice(int var1, int var2);

    @Override
    public abstract Int3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Int3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Int1D as1D();
}

