/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array9D;
import mitiv.array.Byte9D;
import mitiv.array.Double9D;
import mitiv.array.Float9D;
import mitiv.array.Int1D;
import mitiv.array.Int8D;
import mitiv.array.IntArray;
import mitiv.array.Long9D;
import mitiv.array.ShapedArray;
import mitiv.array.Short9D;
import mitiv.array.impl.FlatInt9D;
import mitiv.array.impl.StriddenInt9D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int9D
extends Array9D
implements IntArray {
    protected Int9D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        super(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    protected Int9D(int[] nArray) {
        super(nArray);
    }

    protected Int9D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    public void fill(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, this.get(i, j, k, i2, i3, i4, i5, i6, i7) + n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, this.get(i13, i12, i11, i10, i9, i8, k, j, i) + n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, this.get(i, j, k, i2, i3, i4, i5, i6, i7) - n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, this.get(i13, i12, i11, i10, i9, i8, k, j, i) - n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(int n) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, this.get(i, j, k, i2, i3, i4, i5, i6, i7) * n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, this.get(i13, i12, i11, i10, i9, i8, k, j, i) * n);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, intFunction.apply(this.get(i, j, k, i2, i3, i4, i5, i6, i7)));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, intFunction.apply(this.get(i13, i12, i11, i10, i9, i8, k, j, i)));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, intGenerator.nextInt());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, intGenerator.nextInt());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    intScanner.update(this.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                                    continue;
                                                }
                                                intScanner.initialize(this.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    intScanner.update(this.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                                    continue;
                                                }
                                                intScanner.initialize(this.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                                bl = true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                int n2 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (n2 >= n) continue;
                                                n = n2;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                int n3 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (n3 >= n) continue;
                                                n = n3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                int n2 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (n2 <= n) continue;
                                                n = n2;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                int n3 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (n3 <= n) continue;
                                                n = n3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                int n3 = this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                                if (n3 < n) {
                                                    n = n3;
                                                }
                                                if (n3 <= n2) continue;
                                                n2 = n3;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                if (bl) {
                                                    bl = false;
                                                    continue;
                                                }
                                                int n4 = this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                                if (n4 < n) {
                                                    n = n4;
                                                }
                                                if (n4 <= n2) continue;
                                                n2 = n4;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                n += this.get(i, j, k, i2, i3, i4, i5, i6, i7);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                n += this.get(i13, i12, i11, i10, i9, i8, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte9D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                byArray[++n] = (byte)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte9D.wrap(byArray, this.getShape());
    }

    @Override
    public Short9D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                sArray[++n] = (short)this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short9D.wrap(sArray, this.getShape());
    }

    @Override
    public Int9D toInt() {
        return this;
    }

    @Override
    public Long9D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                lArray[++n] = this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long9D.wrap(lArray, this.getShape());
    }

    @Override
    public Float9D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                fArray[++n] = this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float9D.wrap(fArray, this.getShape());
    }

    @Override
    public Double9D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                dArray[++n] = this.get(i7, i6, i5, i4, i3, i2, k, j, i);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double9D.wrap(dArray, this.getShape());
    }

    @Override
    public Int9D copy() {
        return new FlatInt9D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int9D int9D = shapedArray.getType() == 2 ? (Int9D)shapedArray : (Int9D)shapedArray.toInt();
        if (this.getOrder() == 2 && int9D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            for (int i7 = 0; i7 < this.dim9; ++i7) {
                                                this.set(i, j, k, i2, i3, i4, i5, i6, i7, int9D.get(i, j, k, i2, i3, i4, i5, i6, i7));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, int9D.get(i13, i12, i11, i10, i9, i8, k, j, i));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i2 = 0; i2 < this.dim6; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim4; ++i4) {
                                    for (int i5 = 0; i5 < this.dim3; ++i5) {
                                        for (int i6 = 0; i6 < this.dim2; ++i6) {
                                            for (int i7 = 0; i7 < this.dim1; ++i7) {
                                                this.set(i7, i6, i5, i4, i3, i2, k, j, i, (int)doubleShapedVector.get(++n));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim9; ++i) {
                for (int j = 0; j < this.dim8; ++j) {
                    for (int k = 0; k < this.dim7; ++k) {
                        for (int i8 = 0; i8 < this.dim6; ++i8) {
                            for (int i9 = 0; i9 < this.dim5; ++i9) {
                                for (int i10 = 0; i10 < this.dim4; ++i10) {
                                    for (int i11 = 0; i11 < this.dim3; ++i11) {
                                        for (int i12 = 0; i12 < this.dim2; ++i12) {
                                            for (int i13 = 0; i13 < this.dim1; ++i13) {
                                                this.set(i13, i12, i11, i10, i9, i8, k, j, i, (int)floatShapedVector.get(++n));
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int9D create() {
        return new FlatInt9D(this.getShape());
    }

    public static Int9D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new FlatInt9D(n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static Int9D create(int[] nArray) {
        return new FlatInt9D(nArray);
    }

    public static Int9D create(Shape shape) {
        return new FlatInt9D(shape);
    }

    public static Int9D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return new FlatInt9D(nArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static Int9D wrap(int[] nArray, int[] nArray2) {
        return new FlatInt9D(nArray, nArray2);
    }

    public static Int9D wrap(int[] nArray, Shape shape) {
        return new FlatInt9D(nArray, shape);
    }

    public static Int9D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18, int n19) {
        return new StriddenInt9D(nArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19);
    }

    @Override
    public abstract Int8D slice(int var1);

    @Override
    public abstract Int8D slice(int var1, int var2);

    @Override
    public abstract Int9D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8, Range var9);

    @Override
    public abstract Int9D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8, int[] var9);

    @Override
    public abstract Int1D as1D();
}

