package plugins.jmutterer.plantSeg;

import icy.canvas.IcyCanvas;
import icy.gui.frame.GenericFrame;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.painter.Anchor2D;
import icy.painter.Anchor2D.Anchor2DPositionListener;
import icy.painter.Overlay;
import icy.roi.ROI;
import icy.sequence.Sequence;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import plugins.kernel.roi.roi2d.ROI2DPolygon;

public class PlantSegOverlay extends Overlay implements Anchor2DPositionListener {

	Anchor2D anchorCenter;
	Anchor2D anchorControlPoint;
	double angleOriginal = Math.PI;
	double diagonalDistance;

	Point2D p1p2;
	Point2D p2p3;
	Point2D p3p4;
	Point2D p4p1;

	Point2D centerPoint;
	Point2D p1;
	Point2D p2;
	Point2D p3;
	Point2D p4;

	Sequence HSBsequence;
	ThresholdSlider t;

	public PlantSegOverlay(final Sequence sequence) {
		super("Plant segmentation helper");

		anchorCenter = new Anchor2D(sequence.getWidth() / 2.d, sequence.getHeight() / 2.d);
		anchorCenter.setColor(Color.red);
		anchorControlPoint = new Anchor2D(Math.min(sequence.getWidth() / 3.d, sequence.getHeight() / 3.d), Math.min(
				sequence.getWidth() / 3.d, sequence.getHeight() / 3.d));
		anchorControlPoint.setColor(Color.green);
		sequence.addOverlay(anchorCenter);
		sequence.addOverlay(anchorControlPoint);
		anchorCenter.addPositionListener(this);
		
		t = new ThresholdSlider(sequence);
		IcyFrame f = new GenericFrame("Threshold", t);
		f.addFrameListener(new IcyFrameListener() {
			
			@Override
			public void icyFrameOpened(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void icyFrameInternalized(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void icyFrameIconified(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void icyFrameExternalized(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void icyFrameDeiconified(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void icyFrameDeactivated(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void icyFrameClosing(IcyFrameEvent e) {
				sequence.removeAllROI();
				for (Overlay o: sequence.getOverlays()) sequence.removeOverlay(o);				
			}
			
			@Override
			public void icyFrameClosed(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void icyFrameActivated(IcyFrameEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		f.addToDesktopPane();

	}

	@Override
	public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {

		g.setColor(Color.white);

		centerPoint = anchorCenter.getPosition();
		p1 = anchorControlPoint.getPosition();

		diagonalDistance = p1.distance(centerPoint);

		double vx = (centerPoint.getX() - p1.getX());
		double vy = (centerPoint.getY() - p1.getY());

		double angle = Math.atan2(vy, vx);
		angleOriginal = angle;

		angle -= Math.PI / 2;
		p2 = new Point2D.Double(centerPoint.getX() + Math.cos(angle) * diagonalDistance, centerPoint.getY()
				+ Math.sin(angle) * diagonalDistance);

		angle -= Math.PI;
		p4 = new Point2D.Double(centerPoint.getX() + Math.cos(angle) * diagonalDistance, centerPoint.getY()
				+ Math.sin(angle) * diagonalDistance);

		angle -= Math.PI / 2;
		p3 = new Point2D.Double(centerPoint.getX() + Math.cos(angle) * diagonalDistance, centerPoint.getY()
				+ Math.sin(angle) * diagonalDistance);

		p1p2 = middle(p1, p2);
		p2p3 = middle(p2, p3);
		p3p4 = middle(p3, p4);
		p4p1 = middle(p4, p1);

		Line2D side1 = new Line2D.Double(p1.getX(), p1.getY(), p2.getX(), p2.getY());
		Line2D side2 = new Line2D.Double(p2.getX(), p2.getY(), p3.getX(), p3.getY());
		Line2D side3 = new Line2D.Double(p3.getX(), p3.getY(), p4.getX(), p4.getY());
		Line2D side4 = new Line2D.Double(p4.getX(), p4.getY(), p1.getX(), p1.getY());
		Line2D horizontal = new Line2D.Double(p3p4.getX(), p3p4.getY(), p1p2.getX(), p1p2.getY());
		Line2D vertical = new Line2D.Double(p4p1.getX(), p4p1.getY(), p2p3.getX(), p2p3.getY());

		Stroke stroke = new BasicStroke((float) canvas.canvasToImageLogDeltaX(2));
		g.setStroke(stroke);

		g.setColor(Color.red);
		g.draw(side1);

		g.setColor(Color.blue);
		g.draw(side2);

		g.setColor(Color.blue);
		g.draw(side3);

		g.setColor(Color.blue);
		g.draw(side4);

		g.setColor(Color.white);
		g.draw(horizontal);
		g.draw(vertical);

		int fontSize = (int) canvas.canvasToImageLogDeltaX(30);
		Font font = new Font("Arial", Font.PLAIN, fontSize);
		g.setFont(font);
		AffineTransform originalTransform = g.getTransform();

		g.translate(p1.getX(), p1.getY());
		g.rotate(angle - Math.PI / 4);
		g.drawString("Roi1", (int) (p1.distance(p2) / 8d), (int) (p1.distance(p2) / 12d));
		g.setTransform(originalTransform);
		g.translate(p2.getX(), p2.getY());
		g.rotate(angle - Math.PI / 4);
		g.drawString("Roi2", (int) (p3.distance(p2) / -4d), (int) (p3.distance(p2) / 12d));
		g.setTransform(originalTransform);
		g.translate(p3.getX(), p3.getY());
		g.rotate(angle - Math.PI / 4);
		g.drawString("Roi3", (int) (p3.distance(p4) / -4d), (int) (p3.distance(p4) / -12d));
		g.setTransform(originalTransform);
		g.translate(p4.getX(), p4.getY());
		g.rotate(angle - Math.PI / 4);
		g.drawString("Roi4", (int) (p1.distance(p4) / 8d), (int) (p1.distance(p4) / -12d));
		g.setTransform(originalTransform);
		ArrayList<ROI> rois = createRois();
		t.setRois(rois);
	}


	private Point2D middle(Point2D p1, Point2D p2) {

		Point2D p = new Point2D.Double((p1.getX() + p2.getX()) / 2d, (p1.getY() + p2.getY()) / 2d);
		return p;
	}

	@Override
	public void positionChanged(Anchor2D source) {

		if (source == anchorCenter) {
			Point2D p = anchorCenter.getPosition();
			angleOriginal += Math.PI;
			Point2D p2 = new Point2D.Double(p.getX() + Math.cos(angleOriginal) * diagonalDistance, p.getY()
					+ Math.sin(angleOriginal) * diagonalDistance);
			anchorControlPoint.setPosition(p2);

		}

	}

	private ArrayList<ROI> createRois() {

	
			ArrayList<ROI> fourRois = new ArrayList<ROI>(); 
						
			fourRois.add(createROI(p1, p1p2, centerPoint, p4p1, "Roi1"));
			fourRois.add(createROI(p2, p1p2, centerPoint, p2p3, "Roi2"));
			fourRois.add(createROI(p3, p3p4, centerPoint, p2p3, "Roi3"));
			fourRois.add(createROI(p4, p3p4, centerPoint, p4p1, "Roi4"));

			return fourRois;

	}

	private ROI createROI(Point2D p1, Point2D p2, Point2D p3, Point2D p4, String name) {

		ArrayList<Point2D> pList = new ArrayList<Point2D>();
		pList.add(p1);
		pList.add(p2);
		pList.add(p3);
		pList.add(p4);
		ROI2DPolygon roi = new ROI2DPolygon(pList);
		roi.setName(name);
		return roi;

	}

}
