/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Map;

public abstract class CLAbstractUserProgram {
    final CLProgram program;
    String rawSource;
    Map<String, String> velocityArgs;
    volatile boolean addedSources;

    protected Long getSourceChecksum() {
        return null;
    }

    public CLProgram getProgram() {
        return this.program;
    }

    protected void checkArrayLength(Object arr, int length, String argName) {
        if (arr == null) {
            throw new IllegalArgumentException("Argument " + argName + " cannot be null. Expected array of size " + length);
        }
        int len = Array.getLength(arr);
        if (len != length) {
            throw new IllegalArgumentException("Argument " + argName + " must be an array of size " + length + ", but given array of size " + len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String readRawSourceForClass(Class<?> c) throws IOException {
        String simpleName = c.getSimpleName();
        InputStream srcIn = c.getResourceAsStream(simpleName + ".cl");
        try {
            if (srcIn == null) {
                srcIn = c.getResourceAsStream(simpleName + ".c");
            }
            if (srcIn == null) {
                throw new FileNotFoundException("OpenCL source code not found : '" + simpleName + "'");
            }
            String string = IOUtils.readText(srcIn);
            return string;
        }
        finally {
            if (srcIn != null) {
                srcIn.close();
            }
        }
    }

    protected CLAbstractUserProgram(CLProgram program, String rawSource) {
        this.program = program;
        this.rawSource = rawSource;
    }

    protected CLAbstractUserProgram(CLContext context, String rawSource) {
        this(context.createProgram(new String[0]), rawSource);
    }

    protected synchronized void addSources() {
        if (this.addedSources) {
            return;
        }
        String src = this.velocityArgs != null ? this.rawSource : this.rawSource;
        this.program.addSource(src);
        this.addedSources = true;
    }

    protected void defineMacro(String name, String value) {
        if (value == null) {
            this.program.undefineMacro(name);
        } else {
            this.program.defineMacro(name, value);
        }
    }

    protected synchronized CLKernel createKernel(String name) throws CLBuildException {
        this.addSources();
        return this.program.createKernel(name, new Object[0]);
    }
}

