/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util;

public final class SpecialMathFunction {
    private static final double log2 = Math.log(2.0);

    public static double log2(double x) throws ArithmeticException {
        if (x <= 0.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(x) / log2;
    }

    public static double atanh(double x) throws ArithmeticException {
        if (x > 1.0 || x < -1.0) {
            throw new ArithmeticException("range exception");
        }
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }
}

