/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.algo.LongFormatter;
import cern.colt.matrix.tlong.algo.LongProperty;
import cern.colt.matrix.tlong.algo.LongSorting;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongPlusMultSecond;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class LongMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected LongMatrix1D() {
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f) {
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(LongMatrix1D.this.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(LongMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public long aggregate(final LongLongFunction aggr, final LongFunction f, IntArrayList indexList) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size == 0");
        }
        int size = indexList.size();
        final int[] indexElements = indexList.elements();
        long a = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(LongMatrix1D.this.getQuick(indexElements[firstIdx]));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            long elem = LongMatrix1D.this.getQuick(indexElements[i]);
                            a = aggr.apply(a, f.apply(elem));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(this.getQuick(indexElements[0]));
            int i = 1;
            while (i < size) {
                long elem = this.getQuick(indexElements[i]);
                a = aggr.apply(a, f.apply(elem));
                ++i;
            }
        }
        return a;
    }

    public long aggregate(final LongMatrix1D other, final LongLongFunction aggr, final LongLongFunction f) {
        this.checkSize(other);
        if (this.size == 0) {
            throw new IllegalArgumentException("size == 0");
        }
        long a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long a = f.apply(LongMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(LongMatrix1D.this.getQuick(i), other.getQuick(i)));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
                ++i;
            }
        }
        return a;
    }

    public LongMatrix1D assign(final LongFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            LongMatrix1D.this.setQuick(i, f.apply(LongMatrix1D.this.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, f.apply(this.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongProcedure cond, final LongFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            long elem = LongMatrix1D.this.getQuick(i);
                            if (cond.apply(elem)) {
                                LongMatrix1D.this.setQuick(i, f.apply(elem));
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                long elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, f.apply(elem));
                }
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongProcedure cond, final long value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            long elem = LongMatrix1D.this.getQuick(i);
                            if (cond.apply(elem)) {
                                LongMatrix1D.this.setQuick(i, value);
                            }
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                long elem = this.getQuick(i);
                if (cond.apply(elem)) {
                    this.setQuick(i, value);
                }
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final long value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            LongMatrix1D.this.setQuick(i, value);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, value);
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final long[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            LongMatrix1D.this.setQuick(i, values[i]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, values[i]);
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final int[] values) {
        if (values.length != this.size) {
            throw new IllegalArgumentException("Must have same number of cells: length=" + values.length + "size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            LongMatrix1D.this.setQuick(i, values[i]);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, values[i]);
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(LongMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final LongMatrix1D other_loc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            LongMatrix1D.this.setQuick(i, other_loc.getQuick(i));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, other_loc.getQuick(i));
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(final LongMatrix1D y, final LongLongFunction function) {
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            LongMatrix1D.this.setQuick(i, function.apply(LongMatrix1D.this.getQuick(i), y.getQuick(i)));
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                this.setQuick(i, function.apply(this.getQuick(i), y.getQuick(i)));
                ++i;
            }
        }
        return this;
    }

    public LongMatrix1D assign(LongMatrix1D y, LongLongFunction function, IntArrayList nonZeroIndexes) {
        this.checkSize(y);
        int[] nonZeroElements = nonZeroIndexes.elements();
        if (function == LongFunctions.mult) {
            int j = 0;
            int index = nonZeroIndexes.size();
            while (--index >= 0) {
                int i = nonZeroElements[index];
                while (j < i) {
                    this.setQuick(j, 0L);
                    ++j;
                }
                this.setQuick(i, this.getQuick(i) * y.getQuick(i));
                ++j;
            }
        } else if (function instanceof LongPlusMultSecond) {
            long multiplicator = ((LongPlusMultSecond)function).multiplicator;
            if (multiplicator == 0L) {
                return this;
            }
            if (multiplicator == 1L) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + y.getQuick(i));
                }
            } else if (multiplicator == -1L) {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) - y.getQuick(i));
                }
            } else {
                int index = nonZeroIndexes.size();
                while (--index >= 0) {
                    int i = nonZeroElements[index];
                    this.setQuick(i, this.getQuick(i) + multiplicator * y.getQuick(i));
                }
            }
        } else {
            return this.assign(y, function);
        }
        return this;
    }

    public int cardinality() {
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (LongMatrix1D.this.getQuick(i) != 0L) {
                                ++cardinality;
                            }
                            ++i;
                        }
                        return cardinality;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Integer)futures[j].get();
                    ++j;
                }
                cardinality = results[0];
                j = 1;
                while (j < nthreads) {
                    cardinality += results[j].intValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.getQuick(i) != 0L) {
                    ++cardinality;
                }
                ++i;
            }
        }
        return cardinality;
    }

    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int i = this.size;
        while (--i >= 0 && cardinality < maxCardinality) {
            if (this.getQuick(i) == 0L) continue;
            ++cardinality;
        }
        return cardinality;
    }

    public LongMatrix1D copy() {
        LongMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public abstract Object elements();

    public boolean equals(long value) {
        return LongProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongMatrix1D)) {
            return false;
        }
        return LongProperty.DEFAULT.equals(this, (LongMatrix1D)obj);
    }

    public long get(int index) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    protected LongMatrix1D getContent() {
        return this;
    }

    public void getNegativeValues(IntArrayList indexList, LongArrayList valueList) {
        long value;
        indexList.clear();
        valueList.clear();
        int rem = this.size % 2;
        if (rem == 1 && (value = this.getQuick(0)) < 0L) {
            indexList.add(0);
            valueList.add(value);
        }
        int i = rem;
        while (i < this.size) {
            long value2 = this.getQuick(i);
            if (value2 < 0L) {
                indexList.add(i);
                valueList.add(value2);
            }
            if ((value2 = this.getQuick(i + 1)) < 0L) {
                indexList.add(i + 1);
                valueList.add(value2);
            }
            i += 2;
        }
    }

    public void getNonZeros(IntArrayList indexList, LongArrayList valueList) {
        long value;
        indexList.clear();
        valueList.clear();
        int rem = this.size % 2;
        if (rem == 1 && (value = this.getQuick(0)) != 0L) {
            indexList.add(0);
            valueList.add(value);
        }
        int i = rem;
        while (i < this.size) {
            long value2 = this.getQuick(i);
            if (value2 != 0L) {
                indexList.add(i);
                valueList.add(value2);
            }
            if ((value2 = this.getQuick(i + 1)) != 0L) {
                indexList.add(i + 1);
                valueList.add(value2);
            }
            i += 2;
        }
    }

    public void getNonZeros(IntArrayList indexList, LongArrayList valueList, int maxCardinality) {
        boolean fillValueList;
        boolean fillIndexList = indexList != null;
        boolean bl = fillValueList = valueList != null;
        if (fillIndexList) {
            indexList.clear();
        }
        if (fillValueList) {
            valueList.clear();
        }
        int s = this.size;
        int currentSize = 0;
        int i = 0;
        while (i < s) {
            long value = this.getQuick(i);
            if (value != 0L) {
                if (fillIndexList) {
                    indexList.add(i);
                }
                if (fillValueList) {
                    valueList.add(value);
                }
                ++currentSize;
            }
            if (currentSize >= maxCardinality) break;
            ++i;
        }
    }

    public void getPositiveValues(IntArrayList indexList, LongArrayList valueList) {
        long value;
        indexList.clear();
        valueList.clear();
        int rem = this.size % 2;
        if (rem == 1 && (value = this.getQuick(0)) > 0L) {
            indexList.add(0);
            valueList.add(value);
        }
        int i = rem;
        while (i < this.size) {
            long value2 = this.getQuick(i);
            if (value2 > 0L) {
                indexList.add(i);
                valueList.add(value2);
            }
            if ((value2 = this.getQuick(i + 1)) > 0L) {
                indexList.add(i + 1);
                valueList.add(value2);
            }
            i += 2;
        }
    }

    public abstract long getQuick(int var1);

    protected boolean haveSharedCells(LongMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D other) {
        return false;
    }

    public LongMatrix1D like() {
        return this.like(this.size);
    }

    public abstract LongMatrix1D like(int var1);

    public abstract LongMatrix2D like2D(int var1, int var2);

    public long[] getMaxLocation() {
        int location = 0;
        long maxValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int location = firstIdx;
                        long maxValue = LongMatrix1D.this.getQuick(location);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            long elem = LongMatrix1D.this.getQuick(i);
                            if (maxValue < elem) {
                                maxValue = elem;
                                location = i;
                            }
                            ++i;
                        }
                        return new long[]{maxValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                maxValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (maxValue < results[j][0]) {
                        maxValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            maxValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                long elem = this.getQuick(i);
                if (maxValue < elem) {
                    maxValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new long[]{maxValue, location};
    }

    public long[] getMinLocation() {
        int location = 0;
        long minValue = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            long[][] results = new long[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        int location = firstIdx;
                        long minValue = LongMatrix1D.this.getQuick(location);
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            long elem = LongMatrix1D.this.getQuick(i);
                            if (minValue > elem) {
                                minValue = elem;
                                location = i;
                            }
                            ++i;
                        }
                        return new long[]{minValue, location};
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (long[])futures[j].get();
                    ++j;
                }
                minValue = results[0][0];
                location = (int)results[0][1];
                j = 1;
                while (j < nthreads) {
                    if (minValue > results[j][0]) {
                        minValue = results[j][0];
                        location = (int)results[j][1];
                    }
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            minValue = this.getQuick(location);
            int i = 1;
            while ((long)i < this.size()) {
                long elem = this.getQuick(i);
                if (minValue > elem) {
                    minValue = elem;
                    location = i;
                }
                ++i;
            }
        }
        return new long[]{minValue, location};
    }

    public abstract LongMatrix2D reshape(int var1, int var2);

    public abstract LongMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, long value) {
        if (index < 0 || index >= this.size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, long var2);

    public void setSize(int size) {
        this.size = size;
    }

    public void swap(final LongMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            long tmp = LongMatrix1D.this.getQuick(i);
                            LongMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                long tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
                ++i;
            }
        }
    }

    public long[] toArray() {
        long[] values = new long[this.size];
        this.toArray(values);
        return values;
    }

    public void toArray(final long[] values) {
        if (values.length < this.size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            values[i] = LongMatrix1D.this.getQuick(i);
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i = 0;
            while (i < this.size) {
                values[i] = this.getQuick(i);
                ++i;
            }
        }
    }

    public String toString() {
        return new LongFormatter().toString(this);
    }

    protected LongMatrix1D view() {
        return (LongMatrix1D)this.clone();
    }

    public LongMatrix1D viewFlip() {
        return (LongMatrix1D)this.view().vFlip();
    }

    public LongMatrix1D viewPart(int index, int width) {
        return (LongMatrix1D)this.view().vPart(index, width);
    }

    public LongMatrix1D viewSelection(LongProcedure condition) {
        IntArrayList matches = new IntArrayList();
        int i = 0;
        while (i < this.size) {
            if (condition.apply(this.getQuick(i))) {
                matches.add(i);
            }
            ++i;
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    public LongMatrix1D viewSelection(int[] indexes) {
        if (indexes == null) {
            indexes = new int[this.size];
            int i = 0;
            while (i < this.size) {
                indexes[i] = i;
                ++i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        int i = 0;
        while (i < indexes.length) {
            offsets[i] = (int)this.index(indexes[i]);
            ++i;
        }
        return this.viewSelectionLike(offsets);
    }

    protected abstract LongMatrix1D viewSelectionLike(int[] var1);

    public LongMatrix1D viewSorted() {
        return LongSorting.mergeSort.sort(this);
    }

    public LongMatrix1D viewStrides(int stride) {
        return (LongMatrix1D)this.view().vStrides(stride);
    }

    public long zDotProduct(LongMatrix1D y) {
        return this.zDotProduct(y, 0, this.size);
    }

    public long zDotProduct(final LongMatrix1D y, final int from, int length) {
        if (from < 0 || length <= 0) {
            return 0L;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        long sum = 0L;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            Long[] results = new Long[nthreads];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long sum = 0L;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            int idx = k + from;
                            sum += LongMatrix1D.this.getQuick(idx) * y.getQuick(idx);
                            ++k;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Long)futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum += results[j].longValue();
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int i = tail - 1;
            int k = length;
            while (--k >= 0) {
                sum += this.getQuick(i) * y.getQuick(i);
                --i;
            }
        }
        return sum;
    }

    public long zDotProduct(LongMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        if (from < 0 || length <= 0) {
            return 0L;
        }
        int tail = from + length;
        if (this.size < tail) {
            tail = this.size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return 0L;
        }
        IntArrayList indexesCopy = nonZeroIndexes.copy();
        indexesCopy.trimToSize();
        indexesCopy.quickSort();
        int[] nonZeroIndexElements = indexesCopy.elements();
        int index = 0;
        int s = indexesCopy.size();
        while (index < s && nonZeroIndexElements[index] < from) {
            ++index;
        }
        long sum = 0L;
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            sum += this.getQuick(i) * y.getQuick(i);
            ++index;
        }
        return sum;
    }

    protected long zDotProduct(LongMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, this.size, nonZeroIndexes);
    }

    public long zSum() {
        if (this.size() == 0L) {
            return 0L;
        }
        return this.aggregate(LongFunctions.plus, LongFunctions.identity);
    }
}

