package plugins.nchenouard.linearprogrammingfullsimplex;

import lpsolve.LpSolve;
import lpsolve.LpSolveException;

public class LPSolveComparison {
//	public boolean solveSimplexCompareWithLPSolve(CanonicalProgramParameters parameters)
//	{
//		double[] b0 = parameters.b;
//		boolean[] equality = parameters.equalityConstraints;
//		double[][] A0 = parameters.A;
//		double[] c0 = parameters.c;
//		boolean onlyInequality = true;
//		for (boolean b:parameters.equalityConstraints)
//		{
//			if (b)
//			{
//				onlyInequality = false;
//				break;
//			}
//		}
//		boolean hasNegativeRHS = false;
//		for (int i = 0; i  < b0.length; i++)
//		{
//			if (b0[i] < 0)
//			{
//				if (equality[i]) // just change the signs for the constraint
//				{
//					b0[i] = -b0[i];
//					for (int j = 0; j < A0[i].length; j++)
//						A0[i][j] = -A0[i][j];
//				}
//				else
//					hasNegativeRHS = true;
//			}
//		}
//		if (onlyInequality)
//		{
//			if(hasNegativeRHS)
//			{
//				// add slack variables and multiply by -1 when corresponding to a negative rhs
//				double[][] A = new double[numConstraints][numConstraints + numVariables];
//				double[] c = new double[numConstraints + numVariables];
//				System.arraycopy(c0, 0, c, 0, numVariables); // no cost for slack variables
//				boolean[] equality2 = new boolean[numConstraints];
//				for (int i = 0; i < numConstraints; i++)
//				{
//					equality2[i] = true;
//					if (b0[i] >= 0)
//					{
//						System.arraycopy(A0[i], 0, A[i], 0, numVariables);
//						A[i][numVariables + i] = 1;
//					}
//					else
//					{
//						for (int j = 0; j < numVariables; j++)
//							A[i][j] = -A0[i][j];
//						A[i][numVariables + i] = -1;
//						b0[i] = -b0[i];
//					}
//				}
//				parameters.A = A;
//				parameters.c = c;
//				parameters.equalityConstraints = equality2;
//				// we have now a problem with only equality constraints and non-negative rhs
//				double d = solveWithLPSolve();
//				if(solveWithEqualities(true))
//				{
//					double[] tmpSolution = this.solution;
//					this.solution = new double[numVariables];
//					System.arraycopy(tmpSolution, 0, solution, 0, numVariables);
//					System.out.println("D2 "+ d +" | "+ getScore());
//				}
//				else
//				{
//					System.out.println("D2 "+ d +" failed");
//					return false;
//				}
//			}
//			else
//				solveWithInequalities(true);
//		}
//		else
//		{
//			if(hasNegativeRHS)
//			{
//				System.out.println("NEGRHS");
//				// we need to solve first a problem to find the initial tableau
//				//				// we will add slack variables and minimize the cost of the sum of the slack variables for the equality constraints
//				boolean maximization = false;
//				boolean[] equ = new boolean[equality.length];
//				double[] c = new double[c0.length];
//				boolean[] isNegativeConstraint = new boolean[b0.length];
//				for (int i = 0; i < equality.length; i++)
//				{
//					if (b0[i] < 0)
//					{
//						isNegativeConstraint[i] = true;
//						b0[i] = -b0[i];
//						for (int j = 0; j < A0[i].length; j++)
//							A0[i][j] = -A0[i][j];
//					}
//				}
//				CanonicalSimplexProgram modifiedProgram = createNewProgram(A0, b0, c, maximization, equ);
//				double d = modifiedProgram.solveWithLPSolve();
//				if (modifiedProgram.solvePhaseICanonicalSimplex())
//				{
//					modifiedProgram.tableau0.setUnitScoreToSlackVars(equality);
//					if (modifiedProgram.solvePhaseIICanonicalSimplex(modifiedProgram.tableau0, maximization))
//					{
//						if (Math.abs(modifiedProgram.tableau0.scoreValue) < tol) // optimal score should be 0
//						{
//							// we have found an initial tableau for the main problem
//							// we should modify the scores now for the tableau
//							this.tableau0 = modifiedProgram.tableau0;
//							tableau0.modifyScores(c0);
//							System.out.println("D1 "+ d +" | "+ modifiedProgram.getScore());
//							return true;
//						}
//						else
//						{
//							System.out.println("D1 "+ d +" failed");
//							return false;
//						}
//					}
//					else
//					{
//						System.out.println("D1 "+ d +" failed");
//						return false;
//					}
//				}
//			}
//			else
//			{
//				return solveWithEqualities(true);
//			}
//		}
//		return true;
//	}

	public static double solveWithLPSolve(CanonicalSimplexProgram program)
	{
		CanonicalProgramParameters parameters = program.getParameters();
		int numVariables = program.getNumVariables();
		// create solver
		LpSolve solver;
		try {
			solver = LpSolve.makeLp(0, numVariables);
		} catch (LpSolveException e1) {
			e1.printStackTrace();
			return 0;
		}
		// set objective function
		double[] objFn = new double[numVariables + 1];
		for (int v = 0; v < numVariables; v++)
		{
			objFn[v + 1] = parameters.c[v];
			try {
				solver.setBinary(v + 1, false);
			} catch (LpSolveException e) {
				e.printStackTrace();
			}
		}
		try {
			solver.setObjFn(objFn);
		} catch (LpSolveException e) {
			e.printStackTrace();
			return 0;
		}
		// add constraints
		for (int i  = 0; i < program.getNumConstraints(); i++)
		{
			double[] constraint = new double[numVariables + 1];
			System.arraycopy(parameters.A[i], 0, constraint, 1, numVariables);
			int constrType = LpSolve.LE;
			if (parameters.equalityConstraints[i])
				constrType = LpSolve.EQ;
			try {
				solver.addConstraint(constraint, constrType, parameters.b[i]);
			} catch (LpSolveException e) {
				e.printStackTrace();
				return 0;
			}
		}
		// positive variables
		for (int i  = 0; i < program.getNumVariables(); i++)
		{
			double[] constraint = new double[numVariables + 1];
			constraint[i + 1] = 1;
			int constrType = LpSolve.GE;
			try {
				solver.addConstraint(constraint, constrType, 0);
			} catch (LpSolveException e) {
				e.printStackTrace();
				return 0;
			}
		}

		// maximization problem
		solver.setMaxim();
		solver.setVerbose(LpSolve.CRITICAL);
		// solve the problem
		try {
			//			solver.printLp();
			solver.solve();
		} catch (LpSolveException e) {
			e.printStackTrace();
			return 0;
		}
		try {
			return solver.getObjective();
		} catch (LpSolveException e) {
			e.printStackTrace();
			return 0;
		}
	}
	
	public double solverWithLPSolve(TableauWithSlackVariables tableau, double c[], double b[], boolean maxim, boolean display)
	{
		int numVariables = c.length;
		// create solver
		LpSolve solver;
		try {
			solver = LpSolve.makeLp(0, numVariables);
		} catch (LpSolveException e1) {
			e1.printStackTrace();
			return 0;
		}
		// set objective function
		double[] objFn = new double[numVariables + 1];
		for (int i = 0; i < c.length; i++)
				objFn[i + 1] = c[i];		
		for (int v = 0; v < numVariables; v++)
		{
			try {
				solver.setBinary(v + 1, false);
			} catch (LpSolveException e) {
				e.printStackTrace();
			}
		}
		try {
			solver.setObjFn(objFn);
		} catch (LpSolveException e) {
			e.printStackTrace();
			return 0;
		}
	
		// add constraints
		for (int i  = 0; i < b.length; i++)
		{
			double[] constraint = new double[numVariables + 1];
			System.arraycopy(tableau.tableau[i], 0, constraint, 1, numVariables);
			int constrType = LpSolve.EQ; // we use only equalities here
			try {
				solver.addConstraint(constraint, constrType, b[i]);
			} catch (LpSolveException e) {
				e.printStackTrace();
				return 0;
			}
		}
		// positive variables
		for (int i  = 0; i < numVariables; i++)
		{
			double[] constraint = new double[numVariables + 1];
			constraint[i + 1] = 1;
			int constrType = LpSolve.GE;
			try {
				solver.addConstraint(constraint, constrType, 0);
			} catch (LpSolveException e) {
				e.printStackTrace();
				return 0;
			}
		}
		
		// maximization problem
		if (maxim)
			solver.setMaxim();
		else
			solver.setMinim();
		solver.setVerbose(LpSolve.CRITICAL);
		// solve the problem
		try {
			//			solver.printLp();
			solver.solve();
			if (display)
			{
//				double[] v = solver.getPtrVariables();
				double val = solver.getObjective();
				System.out.println("val lpsolve "+val);
			}
		} catch (LpSolveException e) {
			e.printStackTrace();
			return 0;
		}
		try {
			return solver.getObjective();
		} catch (LpSolveException e) {
			e.printStackTrace();
			return 0;
		}
	}
}
