/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums.handlers;

import java.util.Hashtable;
import ome.units.UNITS;
import ome.units.quantity.Frequency;
import ome.units.unit.Unit;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.UnitsFrequency;
import ome.xml.model.enums.handlers.IEnumerationHandler;
import ome.xml.model.primitives.NonNegativeFloat;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.PositiveLong;
import ome.xml.model.primitives.PrimitiveNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitsFrequencyEnumHandler
implements IEnumerationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitsFrequencyEnumHandler.class);
    private static final Hashtable<String, String> patterns = UnitsFrequencyEnumHandler.makePatterns();

    private static Hashtable<String, String> makePatterns() {
        Hashtable<String, String> p = new Hashtable<String, String>();
        p.put("^\\s*YHz\\s*", "YHz");
        p.put("^\\s*ZHz\\s*", "ZHz");
        p.put("^\\s*EHz\\s*", "EHz");
        p.put("^\\s*PHz\\s*", "PHz");
        p.put("^\\s*THz\\s*", "THz");
        p.put("^\\s*GHz\\s*", "GHz");
        p.put("^\\s*MHz\\s*", "MHz");
        p.put("^\\s*kHz\\s*", "kHz");
        p.put("^\\s*hHz\\s*", "hHz");
        p.put("^\\s*daHz\\s*", "daHz");
        p.put("^\\s*Hz\\s*", "Hz");
        p.put("^\\s*dHz\\s*", "dHz");
        p.put("^\\s*cHz\\s*", "cHz");
        p.put("^\\s*mHz\\s*", "mHz");
        p.put("^\\s*\u00b5Hz\\s*", "\u00b5Hz");
        p.put("^\\s*nHz\\s*", "nHz");
        p.put("^\\s*pHz\\s*", "pHz");
        p.put("^\\s*fHz\\s*", "fHz");
        p.put("^\\s*aHz\\s*", "aHz");
        p.put("^\\s*zHz\\s*", "zHz");
        p.put("^\\s*yHz\\s*", "yHz");
        return p;
    }

    @Override
    public Enumeration getEnumeration(String value) throws EnumerationException {
        if (value != null) {
            for (String pattern : patterns.keySet()) {
                if (!value.matches(pattern)) continue;
                String v = patterns.get(pattern);
                return UnitsFrequency.fromString(v);
            }
        }
        LOGGER.warn("Unknown {} value '{}' will be stored as \"Other\"", (Object)"UnitsFrequency", (Object)value);
        throw new EnumerationException(this.getClass().getName() + " could not find enumeration for " + value);
    }

    public Enumeration getEnumeration(Frequency inUnit) throws EnumerationException {
        return this.getEnumeration(inUnit.unit().getSymbol());
    }

    public static Unit<Frequency> getBaseUnit(UnitsFrequency inModelUnit) {
        Unit<Frequency> theResult = UNITS.HERTZ;
        if (UnitsFrequency.YOTTAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.YOTTAHERTZ;
        }
        if (UnitsFrequency.ZETTAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.ZETTAHERTZ;
        }
        if (UnitsFrequency.EXAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.EXAHERTZ;
        }
        if (UnitsFrequency.PETAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.PETAHERTZ;
        }
        if (UnitsFrequency.TERAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.TERAHERTZ;
        }
        if (UnitsFrequency.GIGAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.GIGAHERTZ;
        }
        if (UnitsFrequency.MEGAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.MEGAHERTZ;
        }
        if (UnitsFrequency.KILOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.KILOHERTZ;
        }
        if (UnitsFrequency.HECTOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.HECTOHERTZ;
        }
        if (UnitsFrequency.DECAHERTZ.equals(inModelUnit)) {
            theResult = UNITS.DECAHERTZ;
        }
        if (UnitsFrequency.HERTZ.equals(inModelUnit)) {
            theResult = UNITS.HERTZ;
        }
        if (UnitsFrequency.DECIHERTZ.equals(inModelUnit)) {
            theResult = UNITS.DECIHERTZ;
        }
        if (UnitsFrequency.CENTIHERTZ.equals(inModelUnit)) {
            theResult = UNITS.CENTIHERTZ;
        }
        if (UnitsFrequency.MILLIHERTZ.equals(inModelUnit)) {
            theResult = UNITS.MILLIHERTZ;
        }
        if (UnitsFrequency.MICROHERTZ.equals(inModelUnit)) {
            theResult = UNITS.MICROHERTZ;
        }
        if (UnitsFrequency.NANOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.NANOHERTZ;
        }
        if (UnitsFrequency.PICOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.PICOHERTZ;
        }
        if (UnitsFrequency.FEMTOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.FEMTOHERTZ;
        }
        if (UnitsFrequency.ATTOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.ATTOHERTZ;
        }
        if (UnitsFrequency.ZEPTOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.ZEPTOHERTZ;
        }
        if (UnitsFrequency.YOCTOHERTZ.equals(inModelUnit)) {
            theResult = UNITS.YOCTOHERTZ;
        }
        return theResult;
    }

    public static <T extends PrimitiveNumber> Frequency getQuantity(T inValue, UnitsFrequency inModelUnit) throws EnumerationException {
        if (inValue instanceof NonNegativeFloat) {
            NonNegativeFloat typedValue = (NonNegativeFloat)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeInteger) {
            NonNegativeInteger typedValue = (NonNegativeInteger)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof NonNegativeLong) {
            NonNegativeLong typedValue = (NonNegativeLong)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PercentFraction) {
            PercentFraction typedValue = (PercentFraction)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveFloat) {
            PositiveFloat typedValue = (PositiveFloat)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveInteger) {
            PositiveInteger typedValue = (PositiveInteger)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof PositiveLong) {
            PositiveLong typedValue = (PositiveLong)inValue;
            return new Frequency((Number)typedValue.getValue(), UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Frequency' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsFrequencyEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    public static <T extends Number> Frequency getQuantity(T inValue, UnitsFrequency inModelUnit) throws EnumerationException {
        if (inValue instanceof Double) {
            Double doubleValue = (Double)inValue;
            return new Frequency(doubleValue, UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        if (inValue instanceof Integer) {
            Integer intValue = (Integer)inValue;
            return new Frequency(intValue, UnitsFrequencyEnumHandler.getBaseUnit(inModelUnit));
        }
        LOGGER.warn("Unknown type '{}' cannot be used to create a 'Frequency' quantity", (Object)inValue.getClass().getName());
        throw new EnumerationException("UnitsFrequencyEnumHandler: type '" + inValue.getClass().getName() + "' cannot be used to create a quantity");
    }

    @Override
    public Class<? extends Enumeration> getEntity() {
        return UnitsFrequency.class;
    }
}

