/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array7D;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;

public abstract class Array8D
implements ShapedArray {
    protected final Shape shape;
    protected final int number;
    protected final int dim1;
    protected final int dim2;
    protected final int dim3;
    protected final int dim4;
    protected final int dim5;
    protected final int dim6;
    protected final int dim7;
    protected final int dim8;

    protected Array8D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.shape = new Shape(n, n2, n3, n4, n5, n6, n7, n8);
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
        this.dim1 = n;
        this.dim2 = n2;
        this.dim3 = n3;
        this.dim4 = n4;
        this.dim5 = n5;
        this.dim6 = n6;
        this.dim7 = n7;
        this.dim8 = n8;
    }

    protected Array8D(int[] nArray) {
        this(new Shape(nArray));
    }

    protected Array8D(Shape shape) {
        if (shape.rank() != 8) {
            throw new IllegalArgumentException("Bad number of dimensions for 8-D array");
        }
        if (shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)shape.number();
        this.shape = shape;
        this.dim1 = shape.dimension(0);
        this.dim2 = shape.dimension(1);
        this.dim3 = shape.dimension(2);
        this.dim4 = shape.dimension(3);
        this.dim5 = shape.dimension(4);
        this.dim6 = shape.dimension(5);
        this.dim7 = shape.dimension(6);
        this.dim8 = shape.dimension(7);
    }

    @Override
    public final int getRank() {
        return 8;
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int n) {
        return this.shape.dimension(n);
    }

    @Override
    public abstract Array8D copy();

    public abstract Array7D slice(int var1);

    public abstract Array7D slice(int var1, int var2);

    public abstract Array8D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8);

    public abstract Array8D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    @Override
    public abstract Array1D as1D();

    public static int checkViewStrides(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        int n19;
        int n20;
        int n21 = (n11 - 1) * n3;
        if (n21 >= 0) {
            n20 = n2;
            n19 = n2 + n21;
        } else {
            n20 = n2 + n21;
            n19 = n2;
        }
        n21 = (n12 - 1) * n4;
        if (n21 >= 0) {
            n19 += n21;
        } else {
            n20 += n21;
        }
        n21 = (n13 - 1) * n5;
        if (n21 >= 0) {
            n19 += n21;
        } else {
            n20 += n21;
        }
        n21 = (n14 - 1) * n6;
        if (n21 >= 0) {
            n19 += n21;
        } else {
            n20 += n21;
        }
        n21 = (n15 - 1) * n7;
        if (n21 >= 0) {
            n19 += n21;
        } else {
            n20 += n21;
        }
        n21 = (n16 - 1) * n8;
        if (n21 >= 0) {
            n19 += n21;
        } else {
            n20 += n21;
        }
        n21 = (n17 - 1) * n9;
        if (n21 >= 0) {
            n19 += n21;
        } else {
            n20 += n21;
        }
        n21 = (n18 - 1) * n10;
        if (n21 >= 0) {
            n19 += n21;
        } else {
            n20 += n21;
        }
        if (n20 < 0 || n19 >= n) {
            throw new IndexOutOfBoundsException("8D view is not within available space");
        }
        int n22 = Math.abs(n3);
        int n23 = Math.abs(n4);
        int n24 = Math.abs(n5);
        int n25 = Math.abs(n6);
        int n26 = Math.abs(n7);
        int n27 = Math.abs(n8);
        int n28 = Math.abs(n9);
        int n29 = Math.abs(n10);
        if (n22 <= n23 && n23 <= n24 && n24 <= n25 && n25 <= n26 && n26 <= n27 && n27 <= n28 && n28 <= n29) {
            return 1;
        }
        if (n22 >= n23 && n23 >= n24 && n24 >= n25 && n25 >= n26 && n26 >= n27 && n27 >= n28 && n28 >= n29) {
            return 2;
        }
        return 0;
    }
}

