/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;

public class FloatGivensRotation {
    private final float c;
    private final float s;

    public FloatGivensRotation(float x, float y) {
        float roe = Math.abs(x) > Math.abs(y) ? x : y;
        float scale = Math.abs(x) + Math.abs(y);
        if (scale != 0.0f) {
            float xs = x / scale;
            float ys = y / scale;
            float r = scale * (float)Math.sqrt(xs * xs + ys * ys);
            if (roe < 0.0f) {
                r *= -1.0f;
            }
            this.c = x / r;
            this.s = y / r;
        } else {
            this.c = 1.0f;
            this.s = 0.0f;
        }
    }

    public void apply(FloatMatrix2D H, int column, int i1, int i2) {
        float temp = this.c * H.getQuick(i1, column) + this.s * H.getQuick(i2, column);
        H.setQuick(i2, column, -this.s * H.getQuick(i1, column) + this.c * H.getQuick(i2, column));
        H.setQuick(i1, column, temp);
    }

    public void apply(FloatMatrix1D x, int i1, int i2) {
        float temp = this.c * x.getQuick(i1) + this.s * x.getQuick(i2);
        x.setQuick(i2, -this.s * x.getQuick(i1) + this.c * x.getQuick(i2));
        x.setQuick(i1, temp);
    }
}

