/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.cost.DifferentiableCostFunction;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class CompositeDifferentiableCostFunction
implements DifferentiableCostFunction {
    private final VectorSpace inputSpace;
    private final DifferentiableCostFunction[] func;
    private final double[] wght;
    protected int nfx = 0;
    protected int ngx = 0;

    public CompositeDifferentiableCostFunction(double d, DifferentiableCostFunction differentiableCostFunction) {
        CompositeDifferentiableCostFunction.checkWeight(d);
        this.inputSpace = differentiableCostFunction.getInputSpace();
        this.func = new DifferentiableCostFunction[]{differentiableCostFunction};
        this.wght = new double[]{d};
    }

    public CompositeDifferentiableCostFunction(double d, DifferentiableCostFunction differentiableCostFunction, double d2, DifferentiableCostFunction differentiableCostFunction2) {
        CompositeDifferentiableCostFunction.checkWeight(d);
        CompositeDifferentiableCostFunction.checkWeight(d2);
        this.inputSpace = differentiableCostFunction.getInputSpace();
        if (differentiableCostFunction2.getInputSpace() != this.inputSpace) {
            throw new IncorrectSpaceException("All functions must have the same input space.");
        }
        this.func = new DifferentiableCostFunction[]{differentiableCostFunction, differentiableCostFunction2};
        this.wght = new double[]{d, d2};
    }

    public CompositeDifferentiableCostFunction(double d, DifferentiableCostFunction differentiableCostFunction, double d2, DifferentiableCostFunction differentiableCostFunction2, double d3, DifferentiableCostFunction differentiableCostFunction3) {
        CompositeDifferentiableCostFunction.checkWeight(d);
        CompositeDifferentiableCostFunction.checkWeight(d2);
        CompositeDifferentiableCostFunction.checkWeight(d3);
        this.inputSpace = differentiableCostFunction.getInputSpace();
        if (differentiableCostFunction2.getInputSpace() != this.inputSpace || differentiableCostFunction3.getInputSpace() != this.inputSpace) {
            throw new IncorrectSpaceException("All functions must have the same input space.");
        }
        this.func = new DifferentiableCostFunction[]{differentiableCostFunction, differentiableCostFunction2, differentiableCostFunction3};
        this.wght = new double[]{d, d2, d3};
    }

    @Override
    public double computeCostAndGradient(double d, Vector vector, Vector vector2, boolean bl) {
        double d2 = 0.0;
        if (d == 0.0) {
            if (bl) {
                vector2.fill(0.0);
            }
        } else {
            for (int i = 0; i < this.func.length; ++i) {
                if (this.wght[i] == 0.0) continue;
                d2 += this.func[i].computeCostAndGradient(d * this.wght[i], vector, vector2, bl);
                bl = false;
            }
        }
        ++this.nfx;
        ++this.ngx;
        return d2;
    }

    @Override
    public VectorSpace getInputSpace() {
        return this.inputSpace;
    }

    @Override
    public double evaluate(double d, Vector vector) {
        double d2 = 0.0;
        if (d != 0.0) {
            for (int i = 0; i < this.func.length; ++i) {
                if (this.wght[i] == 0.0) continue;
                d2 += this.func[i].evaluate(d * this.wght[i], vector);
            }
        }
        ++this.nfx;
        return d2;
    }

    public int getNumberOfFunctionCalls() {
        return this.nfx;
    }

    public int getNumberOfGradientCalls() {
        return this.ngx;
    }

    private static final void checkWeight(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d) || d < 0.0) {
            throw new IllegalArgumentException("Cost function weight must be finite and nonnegative");
        }
    }
}

