package plugins.tprovoost.sequenceblocks.importer;

import java.io.File;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import plugins.adufour.blocks.tools.io.IOBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.util.VarException;
import plugins.tprovoost.sequenceblocks.SequenceBlocks;

/**
 * Block to test if a specified file if supported by a given SequenceFileImporter.
 * 
 * @author Stephane
 */
public class SequenceFileImporterAccept extends Plugin implements IOBlock, PluginLibrary, PluginBundled
{
    final protected Var<PositionedSequenceFileImporter> importer;
    final protected VarMutable file;
    final protected VarBoolean accepted;

    public SequenceFileImporterAccept()
    {
        super();

        importer = new Var<PositionedSequenceFileImporter>("Importer", PositionedSequenceFileImporter.class);
        file = new VarMutable("File", null)
        {
            @SuppressWarnings("rawtypes")
            @Override
            public boolean isAssignableFrom(Var source)
            {
                return (String.class == source.getType()) || (File.class == source.getType());
            }
        };
        accepted = new VarBoolean("Accepted", Boolean.FALSE);
    }

    @Override
    public void run()
    {
        final PositionedSequenceFileImporter pi = importer.getValue();

        if (pi == null)
            throw new VarException(importer, "Importer is null !");

        final String path;
        final Object obj = file.getValue();

        if (obj != null)
        {
            if (obj instanceof String)
                path = (String) obj;
            else
                path = ((File) obj).getAbsolutePath();
        }
        else
            throw new VarException(file, "File is null !");

        accepted.setValue(Boolean.valueOf(pi.importer.acceptFile(path)));
    }

    @Override
    public void declareInput(VarList inputMap)
    {
        inputMap.add("importer", importer);
        inputMap.add("file", file);
    }

    @Override
    public void declareOutput(VarList outputMap)
    {
        outputMap.add("accepted", accepted);
    }

    @Override
    public String getMainPluginClassName()
    {
        return SequenceBlocks.class.getName();
    }
}
