/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Array5D;
import mitiv.array.Array6D;
import mitiv.array.Array7D;
import mitiv.array.Array8D;
import mitiv.array.Array9D;
import mitiv.array.ArrayFactory;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;

public class ArrayUtils {
    public static double sum(ShapedArray shapedArray) {
        double d = 0.0;
        if (shapedArray != null) {
            switch (shapedArray.getType()) {
                case 0: {
                    d = ((ByteArray)shapedArray).sum();
                    break;
                }
                case 1: {
                    d = ((ShortArray)shapedArray).sum();
                    break;
                }
                case 2: {
                    d = ((IntArray)shapedArray).sum();
                    break;
                }
                case 3: {
                    d = ((LongArray)shapedArray).sum();
                    break;
                }
                case 4: {
                    d = ((FloatArray)shapedArray).sum();
                    break;
                }
                case 5: {
                    d = ((DoubleArray)shapedArray).sum();
                }
            }
        }
        return d;
    }

    public static byte[] toByte(byte[] byArray) {
        return byArray;
    }

    public static byte[] toByte(short[] sArray) {
        int n = sArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)sArray[i];
        }
        return byArray;
    }

    public static byte[] toByte(int[] nArray) {
        int n = nArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)nArray[i];
        }
        return byArray;
    }

    public static byte[] toByte(long[] lArray) {
        int n = lArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)lArray[i];
        }
        return byArray;
    }

    public static byte[] toByte(float[] fArray) {
        int n = fArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)fArray[i];
        }
        return byArray;
    }

    public static byte[] toByte(double[] dArray) {
        int n = dArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)dArray[i];
        }
        return byArray;
    }

    public static short[] toShort(byte[] byArray) {
        int n = byArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)(byArray[i] & 0xFF);
        }
        return sArray;
    }

    public static short[] toShort(short[] sArray) {
        return sArray;
    }

    public static short[] toShort(int[] nArray) {
        int n = nArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)nArray[i];
        }
        return sArray;
    }

    public static short[] toShort(long[] lArray) {
        int n = lArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)lArray[i];
        }
        return sArray;
    }

    public static short[] toShort(float[] fArray) {
        int n = fArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)fArray[i];
        }
        return sArray;
    }

    public static short[] toShort(double[] dArray) {
        int n = dArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)dArray[i];
        }
        return sArray;
    }

    public static int[] toInt(byte[] byArray) {
        int n = byArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        return nArray;
    }

    public static int[] toInt(short[] sArray) {
        int n = sArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = sArray[i];
        }
        return nArray;
    }

    public static int[] toInt(int[] nArray) {
        return nArray;
    }

    public static int[] toInt(long[] lArray) {
        int n = lArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    public static int[] toInt(float[] fArray) {
        int n = fArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)fArray[i];
        }
        return nArray;
    }

    public static int[] toInt(double[] dArray) {
        int n = dArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)dArray[i];
        }
        return nArray;
    }

    public static long[] toLong(byte[] byArray) {
        int n = byArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = byArray[i] & 0xFF;
        }
        return lArray;
    }

    public static long[] toLong(short[] sArray) {
        int n = sArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = sArray[i];
        }
        return lArray;
    }

    public static long[] toLong(int[] nArray) {
        int n = nArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    public static long[] toLong(long[] lArray) {
        return lArray;
    }

    public static long[] toLong(float[] fArray) {
        int n = fArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = (long)fArray[i];
        }
        return lArray;
    }

    public static long[] toLong(double[] dArray) {
        int n = dArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = (long)dArray[i];
        }
        return lArray;
    }

    public static float[] toFloat(byte[] byArray) {
        int n = byArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = byArray[i] & 0xFF;
        }
        return fArray;
    }

    public static float[] toFloat(short[] sArray) {
        int n = sArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = sArray[i];
        }
        return fArray;
    }

    public static float[] toFloat(int[] nArray) {
        int n = nArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = nArray[i];
        }
        return fArray;
    }

    public static float[] toFloat(long[] lArray) {
        int n = lArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = lArray[i];
        }
        return fArray;
    }

    public static float[] toFloat(float[] fArray) {
        return fArray;
    }

    public static float[] toFloat(double[] dArray) {
        int n = dArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static double[] toDouble(byte[] byArray) {
        int n = byArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = byArray[i] & 0xFF;
        }
        return dArray;
    }

    public static double[] toDouble(short[] sArray) {
        int n = sArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = sArray[i];
        }
        return dArray;
    }

    public static double[] toDouble(int[] nArray) {
        int n = nArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    public static double[] toDouble(long[] lArray) {
        int n = lArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = lArray[i];
        }
        return dArray;
    }

    public static double[] toDouble(float[] fArray) {
        int n = fArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = fArray[i];
        }
        return dArray;
    }

    public static double[] toDouble(double[] dArray) {
        return dArray;
    }

    public static ShapedArray pad(ShapedArray shapedArray, Shape shape) {
        return ArrayUtils.pad(shapedArray, shape, null, 0.0);
    }

    public static ShapedArray pad(ShapedArray shapedArray, Shape shape, Double d) {
        return ArrayUtils.pad(shapedArray, shape, null, d);
    }

    public static ShapedArray pad(ShapedArray shapedArray, Shape shape, int[] nArray) {
        return ArrayUtils.pad(shapedArray, shape, nArray, 0.0);
    }

    public static ShapedArray pad(ShapedArray shapedArray, Shape shape, int[] nArray, double d) {
        Range[] rangeArray = ArrayUtils.getROI(shape, shapedArray.getShape(), nArray);
        if (rangeArray == null) {
            return shapedArray;
        }
        int n = rangeArray.length;
        int n2 = shapedArray.getType();
        ShapedArray shapedArray2 = ArrayFactory.create(n2, shape);
        switch (n2) {
            case 0: {
                ((ByteArray)shapedArray2).fill((byte)d);
                break;
            }
            case 1: {
                ((ShortArray)shapedArray2).fill((short)d);
                break;
            }
            case 2: {
                ((IntArray)shapedArray2).fill((int)d);
                break;
            }
            case 3: {
                ((LongArray)shapedArray2).fill((long)d);
                break;
            }
            case 4: {
                ((FloatArray)shapedArray2).fill((float)d);
                break;
            }
            case 5: {
                ((DoubleArray)shapedArray2).fill(d);
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
        switch (n) {
            case 1: {
                ((Array1D)shapedArray2).view(rangeArray[0]).assign(shapedArray);
                break;
            }
            case 2: {
                ((Array2D)shapedArray2).view(rangeArray[0], rangeArray[1]).assign(shapedArray);
                break;
            }
            case 3: {
                ((Array3D)shapedArray2).view(rangeArray[0], rangeArray[1], rangeArray[2]).assign(shapedArray);
                break;
            }
            case 4: {
                ((Array4D)shapedArray2).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3]).assign(shapedArray);
                break;
            }
            case 5: {
                ((Array5D)shapedArray2).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4]).assign(shapedArray);
                break;
            }
            case 6: {
                ((Array6D)shapedArray2).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5]).assign(shapedArray);
                break;
            }
            case 7: {
                ((Array7D)shapedArray2).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6]).assign(shapedArray);
                break;
            }
            case 8: {
                ((Array8D)shapedArray2).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6], rangeArray[7]).assign(shapedArray);
                break;
            }
            case 9: {
                ((Array9D)shapedArray2).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6], rangeArray[7], rangeArray[8]).assign(shapedArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported rank");
            }
        }
        return shapedArray2;
    }

    public static ShapedArray crop(ShapedArray shapedArray, Shape shape) {
        return ArrayUtils.crop(shapedArray, shape, null);
    }

    public static ShapedArray crop(ShapedArray shapedArray, Shape shape, int[] nArray) {
        Range[] rangeArray = ArrayUtils.getROI(shapedArray.getShape(), shape, nArray);
        if (rangeArray == null) {
            return shapedArray;
        }
        switch (rangeArray.length) {
            case 1: {
                return ((Array1D)shapedArray).view(rangeArray[0]);
            }
            case 2: {
                return ((Array2D)shapedArray).view(rangeArray[0], rangeArray[1]);
            }
            case 3: {
                return ((Array3D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2]);
            }
            case 4: {
                return ((Array4D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3]);
            }
            case 5: {
                return ((Array5D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4]);
            }
            case 6: {
                return ((Array6D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5]);
            }
            case 7: {
                return ((Array7D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6]);
            }
            case 8: {
                return ((Array8D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6], rangeArray[7]);
            }
            case 9: {
                return ((Array9D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6], rangeArray[7], rangeArray[8]);
            }
        }
        throw new IllegalArgumentException("Unsupported rank");
    }

    private static Range[] getROI(Shape shape, Shape shape2, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = shape.rank();
        if (shape2.rank() != n4) {
            throw new NonConformableArrayException("Not same rank");
        }
        Boolean bl = true;
        Boolean bl2 = false;
        if (nArray == null) {
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = shape.dimension(n3);
                n = shape2.dimension(n3);
                if (n > n2) {
                    bl2 = true;
                    break;
                }
                if (n == n2) continue;
                bl = false;
            }
        } else {
            if (nArray.length != n4) {
                throw new NonConformableArrayException("Bad number of offsets");
            }
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = shape.dimension(n3);
                n = shape2.dimension(n3);
                if (nArray[n3] < 0 || n + nArray[n3] > n2) {
                    bl2 = true;
                    break;
                }
                if (n == n2) continue;
                bl = false;
            }
        }
        if (bl2.booleanValue()) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds region of interest");
        }
        if (bl.booleanValue()) {
            return null;
        }
        Range[] rangeArray = new Range[n4];
        if (nArray == null) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = shape.dimension(n2);
                int n5 = shape2.dimension(n2);
                int n6 = n / 2 - n5 / 2;
                int n7 = n6 + n5 - 1;
                rangeArray[n2] = new Range(n6, n7, 1);
            }
        } else {
            for (n2 = 0; n2 < n4; ++n2) {
                n = shape2.dimension(n2);
                int n8 = nArray[n2];
                int n9 = n8 + n - 1;
                rangeArray[n2] = new Range(n8, n9, 1);
            }
        }
        return rangeArray;
    }

    public static ShapedArray extract(ShapedArray shapedArray, Shape shape, int[] nArray, double d) {
        int n;
        int n2 = shape.rank();
        if (shapedArray.getRank() != n2) {
            throw new NonConformableArrayException("Bad number of dimensions for the resized array");
        }
        Range[] rangeArray = new Range[n2];
        Range[] rangeArray2 = new Range[n2];
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4;
            int n5 = shape.dimension(n);
            int n6 = shapedArray.getDimension(n);
            int n7 = nArray == null ? n6 / 2 - n5 / 2 : nArray[n];
            int n8 = Math.max(0, -n7);
            int n9 = Math.min(n5 - n8, n6 - (n4 = Math.max(0, n7)));
            if (n9 <= 0) {
                n3 = 5;
                break;
            }
            if (n5 != n6) {
                n3 |= 2;
            }
            if (n8 > 0 || n8 + n9 < n5) {
                n3 |= 1;
            }
            rangeArray[n] = new Range(n4, n4 + n9 - 1);
            rangeArray2[n] = new Range(n8, n8 + n9 - 1);
        }
        if (n3 == 0) {
            return shapedArray;
        }
        n = shapedArray.getType();
        ShapedArray shapedArray2 = ArrayFactory.create(n, shape);
        if (n3 & true) {
            switch (n) {
                case 0: {
                    ((ByteArray)shapedArray2).fill((byte)d);
                    break;
                }
                case 1: {
                    ((ShortArray)shapedArray2).fill((short)d);
                    break;
                }
                case 2: {
                    ((IntArray)shapedArray2).fill((int)d);
                    break;
                }
                case 3: {
                    ((LongArray)shapedArray2).fill((long)d);
                    break;
                }
                case 4: {
                    ((FloatArray)shapedArray2).fill((float)d);
                    break;
                }
                case 5: {
                    ((DoubleArray)shapedArray2).fill(d);
                    break;
                }
                default: {
                    throw new IllegalTypeException();
                }
            }
        }
        if ((n3 & 4) == 0) {
            switch (n2) {
                case 1: {
                    ((Array1D)shapedArray2).view(rangeArray2[0]).assign(((Array1D)shapedArray).view(rangeArray[0]));
                    break;
                }
                case 2: {
                    ((Array2D)shapedArray2).view(rangeArray2[0], rangeArray2[1]).assign(((Array2D)shapedArray).view(rangeArray[0], rangeArray[1]));
                    break;
                }
                case 3: {
                    ((Array3D)shapedArray2).view(rangeArray2[0], rangeArray2[1], rangeArray2[2]).assign(((Array3D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2]));
                    break;
                }
                case 4: {
                    ((Array4D)shapedArray2).view(rangeArray2[0], rangeArray2[1], rangeArray2[2], rangeArray2[3]).assign(((Array4D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3]));
                    break;
                }
                case 5: {
                    ((Array5D)shapedArray2).view(rangeArray2[0], rangeArray2[1], rangeArray2[2], rangeArray2[3], rangeArray2[4]).assign(((Array5D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4]));
                    break;
                }
                case 6: {
                    ((Array6D)shapedArray2).view(rangeArray2[0], rangeArray2[1], rangeArray2[2], rangeArray2[3], rangeArray2[4], rangeArray2[5]).assign(((Array6D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5]));
                    break;
                }
                case 7: {
                    ((Array7D)shapedArray2).view(rangeArray2[0], rangeArray2[1], rangeArray2[2], rangeArray2[3], rangeArray2[4], rangeArray2[5], rangeArray2[6]).assign(((Array7D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6]));
                    break;
                }
                case 8: {
                    ((Array8D)shapedArray2).view(rangeArray2[0], rangeArray2[1], rangeArray2[2], rangeArray2[3], rangeArray2[4], rangeArray2[5], rangeArray2[6], rangeArray2[7]).assign(((Array8D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6], rangeArray[7]));
                    break;
                }
                case 9: {
                    ((Array9D)shapedArray2).view(rangeArray2[0], rangeArray2[1], rangeArray2[2], rangeArray2[3], rangeArray2[4], rangeArray2[5], rangeArray2[6], rangeArray2[7], rangeArray2[8]).assign(((Array9D)shapedArray).view(rangeArray[0], rangeArray[1], rangeArray[2], rangeArray[3], rangeArray[4], rangeArray[5], rangeArray[6], rangeArray[7], rangeArray[8]));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rank");
                }
            }
        }
        return shapedArray2;
    }

    public static ShapedArray extract(ShapedArray shapedArray, Shape shape, int[] nArray) {
        return ArrayUtils.extract(shapedArray, shape, nArray, 0.0);
    }

    public static ShapedArray extract(ShapedArray shapedArray, Shape shape, double d) {
        return ArrayUtils.extract(shapedArray, shape, null, d);
    }

    public static ShapedArray extract(ShapedArray shapedArray, Shape shape) {
        return ArrayUtils.extract(shapedArray, shape, null, 0.0);
    }

    public static ShapedArray roll(ShapedArray shapedArray) {
        Shape shape = shapedArray.getShape();
        int n = shape.rank();
        int[] nArray = new int[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            int n2 = shape.dimension(i);
            nArray[i] = -(n2 / 2);
            if (n2 == 1) continue;
            bl = false;
        }
        if (bl) {
            return shapedArray;
        }
        return ArrayUtils.roll(shapedArray, nArray);
    }

    public static ShapedArray roll(ShapedArray shapedArray, int[] nArray) {
        Shape shape = shapedArray.getShape();
        int n = shape.rank();
        if (nArray.length != n) {
            throw new IllegalArgumentException("Range mismatch");
        }
        boolean bl = true;
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = shape.dimension(i);
            int n3 = n2 == 1 ? 0 : (n2 + nArray[i] % n2) % n2;
            if (n3 != 0) {
                bl = false;
            }
            int[] nArray2 = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArray2[j] = (j + n3) % n2;
            }
            nArrayArray[i] = nArray2;
        }
        if (bl) {
            return shapedArray;
        }
        switch (n) {
            case 1: {
                return ((Array1D)shapedArray).view(nArrayArray[0]);
            }
            case 2: {
                return ((Array2D)shapedArray).view(nArrayArray[0], nArrayArray[1]);
            }
            case 3: {
                return ((Array3D)shapedArray).view(nArrayArray[0], nArrayArray[1], nArrayArray[2]);
            }
            case 4: {
                return ((Array4D)shapedArray).view(nArrayArray[0], nArrayArray[1], nArrayArray[2], nArrayArray[3]);
            }
            case 5: {
                return ((Array5D)shapedArray).view(nArrayArray[0], nArrayArray[1], nArrayArray[2], nArrayArray[3], nArrayArray[4]);
            }
            case 6: {
                return ((Array6D)shapedArray).view(nArrayArray[0], nArrayArray[1], nArrayArray[2], nArrayArray[3], nArrayArray[4], nArrayArray[5]);
            }
            case 7: {
                return ((Array7D)shapedArray).view(nArrayArray[0], nArrayArray[1], nArrayArray[2], nArrayArray[3], nArrayArray[4], nArrayArray[5], nArrayArray[6]);
            }
            case 8: {
                return ((Array8D)shapedArray).view(nArrayArray[0], nArrayArray[1], nArrayArray[2], nArrayArray[3], nArrayArray[4], nArrayArray[5], nArrayArray[6], nArrayArray[7]);
            }
            case 9: {
                return ((Array9D)shapedArray).view(nArrayArray[0], nArrayArray[1], nArrayArray[2], nArrayArray[3], nArrayArray[4], nArrayArray[5], nArrayArray[6], nArrayArray[7], nArrayArray[8]);
            }
        }
        throw new IllegalArgumentException("Unsupported rank");
    }
}

