/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array7D;
import mitiv.array.Byte7D;
import mitiv.array.Double7D;
import mitiv.array.Float1D;
import mitiv.array.Float6D;
import mitiv.array.FloatArray;
import mitiv.array.Int7D;
import mitiv.array.Long7D;
import mitiv.array.ShapedArray;
import mitiv.array.Short7D;
import mitiv.array.impl.FlatFloat7D;
import mitiv.array.impl.StriddenFloat7D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float7D
extends Array7D
implements FloatArray {
    protected Float7D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
    }

    protected Float7D(int[] nArray) {
        super(nArray);
    }

    protected Float7D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, float var8);

    @Override
    public void fill(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) + f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) + f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) - f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) - f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) * f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) * f);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, floatFunction.apply(this.get(i, j, k, i2, i3, i4, i5)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, floatFunction.apply(this.get(i9, i8, i7, i6, k, j, i)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, floatGenerator.nextFloat());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, floatGenerator.nextFloat());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            floatScanner.update(this.get(i, j, k, i2, i3, i4, i5));
                                            continue;
                                        }
                                        floatScanner.initialize(this.get(i, j, k, i2, i3, i4, i5));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            floatScanner.update(this.get(i9, i8, i7, i6, k, j, i));
                                            continue;
                                        }
                                        floatScanner.initialize(this.get(i9, i8, i7, i6, k, j, i));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float f = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        float f2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (!(f2 < f)) continue;
                                        f = f2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        float f3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (!(f3 < f)) continue;
                                        f = f3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public float max() {
        float f = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        float f2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (!(f2 > f)) continue;
                                        f = f2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        float f3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (!(f3 > f)) continue;
                                        f = f3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public float[] getMinAndMax() {
        float[] fArray = new float[2];
        this.getMinAndMax(fArray);
        return fArray;
    }

    @Override
    public void getMinAndMax(float[] fArray) {
        float f;
        float f2 = f = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        float f3 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (f3 < f) {
                                            f = f3;
                                        }
                                        if (!(f3 > f2)) continue;
                                        f2 = f3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        float f4 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (f4 < f) {
                                            f = f4;
                                        }
                                        if (!(f4 > f2)) continue;
                                        f2 = f4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
    }

    @Override
    public float sum() {
        float f = 0.0f;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        f += this.get(i, j, k, i2, i3, i4, i5);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        f += this.get(i9, i8, i7, i6, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return f;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte7D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        byArray[++n] = (byte)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte7D.wrap(byArray, this.getShape());
    }

    @Override
    public Short7D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        sArray[++n] = (short)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short7D.wrap(sArray, this.getShape());
    }

    @Override
    public Int7D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        nArray[++n] = (int)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int7D.wrap(nArray, this.getShape());
    }

    @Override
    public Long7D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        lArray[++n] = (long)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long7D.wrap(lArray, this.getShape());
    }

    @Override
    public Float7D toFloat() {
        return this;
    }

    @Override
    public Double7D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        dArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double7D.wrap(dArray, this.getShape());
    }

    @Override
    public Float7D copy() {
        return new FlatFloat7D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Float7D float7D = shapedArray.getType() == 4 ? (Float7D)shapedArray : (Float7D)shapedArray.toFloat();
        if (this.getOrder() == 2 && float7D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, float7D.get(i, j, k, i2, i3, i4, i5));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, float7D.get(i9, i8, i7, i6, k, j, i));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        this.set(i5, i4, i3, i2, k, j, i, (float)doubleShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, (float)floatShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float7D create() {
        return new FlatFloat7D(this.getShape());
    }

    public static Float7D create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatFloat7D(n, n2, n3, n4, n5, n6, n7);
    }

    public static Float7D create(int[] nArray) {
        return new FlatFloat7D(nArray);
    }

    public static Float7D create(Shape shape) {
        return new FlatFloat7D(shape);
    }

    public static Float7D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatFloat7D(fArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Float7D wrap(float[] fArray, int[] nArray) {
        return new FlatFloat7D(fArray, nArray);
    }

    public static Float7D wrap(float[] fArray, Shape shape) {
        return new FlatFloat7D(fArray, shape);
    }

    public static Float7D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        return new StriddenFloat7D(fArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
    }

    @Override
    public abstract Float6D slice(int var1);

    @Override
    public abstract Float6D slice(int var1, int var2);

    @Override
    public abstract Float7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    @Override
    public abstract Float7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Float1D as1D();
}

