/*
 * Decompiled with CFR 0.152.
 */
package jmapps.util;

import com.sun.media.util.JMFI18N;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.Format;
import javax.media.Manager;
import jmapps.ui.MessageDialog;

public class JMAppsCfg {
    public static final String KEY_OPEN_FILE = "Last Open File";
    public static final String KEY_OPEN_RTP = "Last Open RTP";
    public static final String KEY_OPEN_URL = "Last Open URL";
    public static final String KEY_CAPTURE_AUDIO = "Last Capture Audio Device";
    public static final String KEY_CAPTURE_VIDEO = "Last Capture Video Device";
    public static final String KEY_TRANSMIT_RTP = "Last Transmit RTP";
    public static final String KEY_TRANSMIT_SOURCE = "Last Transmit Source";
    public static final String KEY_SAVE_FILE_CONTENT = "Last Save File Content Type";
    public static final String KEY_SAVE_FILE_TRACKS = "Last Save File Tracks";
    public static final String KEY_SAVE_FILE_DIR = "Last Save File Directory";
    public static final String KEY_RECENT_URL = "Recent URL";
    public static final String KEY_JMSTUDIO_FRAME_POS = "Location of JMStudio Frame";
    public static final String KEY_AUTO_PLAY = "Auto Play";
    public static final String KEY_AUTO_LOOP = "Auto Loop";
    public static final String KEY_KEEP_ASPECT = "Keep Aspect Ratio";
    private static String nameFileCfg = ".JMAppsCfg";
    private static final String signatureFileCfg = "JMStudio configuration data file.";
    private static final String signatureHashtable = "Embedded Hashtable";
    private Hashtable hashProperties = new Hashtable();

    public JMAppsCfg() {
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        this.saveFile();
    }

    public String getLastOpenFile() {
        String strFile = null;
        Object objValue = this.hashProperties.get(KEY_OPEN_FILE);
        if (objValue != null) {
            strFile = objValue.toString();
        }
        return strFile;
    }

    public void setLastOpenFile(String strFile) {
        this.hashProperties.put(KEY_OPEN_FILE, strFile);
    }

    public RtpData getLastOpenRtpData() {
        RtpData dataRtp = null;
        Object objValue = this.hashProperties.get(KEY_OPEN_RTP);
        if (objValue != null && objValue instanceof RtpData) {
            dataRtp = (RtpData)objValue;
        }
        return dataRtp;
    }

    public void setLastOpenRtpData(RtpData dataRtp) {
        this.hashProperties.put(KEY_OPEN_RTP, dataRtp);
    }

    public String getLastTransmitRtpSource() {
        String strValue = null;
        Object objValue = this.hashProperties.get(KEY_TRANSMIT_SOURCE);
        if (objValue != null) {
            strValue = objValue.toString();
        }
        return strValue;
    }

    public void setLastTransmitRtpSource(String strValue) {
        this.hashProperties.put(KEY_TRANSMIT_SOURCE, strValue);
    }

    public RtpData getLastTransmitRtpData(String strTrack) {
        Hashtable hashTransmitRtp;
        RtpData dataRtp = null;
        Object objValue = this.hashProperties.get(KEY_TRANSMIT_RTP);
        if (objValue != null && objValue instanceof Hashtable) {
            hashTransmitRtp = (Hashtable)objValue;
        } else {
            hashTransmitRtp = new Hashtable();
            this.hashProperties.put(KEY_TRANSMIT_RTP, hashTransmitRtp);
        }
        objValue = hashTransmitRtp.get(strTrack);
        if (objValue != null && objValue instanceof RtpData) {
            dataRtp = (RtpData)objValue;
        }
        return dataRtp;
    }

    public void setLastTransmitRtpData(RtpData dataRtp, String strTrack) {
        Hashtable hashTransmitRtp;
        Object objValue = this.hashProperties.get(KEY_TRANSMIT_RTP);
        if (objValue != null && objValue instanceof Hashtable) {
            hashTransmitRtp = (Hashtable)objValue;
        } else {
            hashTransmitRtp = new Hashtable();
            this.hashProperties.put(KEY_TRANSMIT_RTP, hashTransmitRtp);
        }
        hashTransmitRtp.put(strTrack, dataRtp);
    }

    public String getLastOpenUrl() {
        String strValue = null;
        Object objValue = this.hashProperties.get(KEY_OPEN_URL);
        if (objValue != null) {
            strValue = objValue.toString();
        }
        return strValue;
    }

    public void setLastOpenUrl(String strValue) {
        this.hashProperties.put(KEY_OPEN_URL, strValue);
    }

    public CaptureDeviceData getLastCaptureAudioData() {
        CaptureDeviceData dataCapture = null;
        Object objValue = this.hashProperties.get(KEY_CAPTURE_AUDIO);
        if (objValue != null && objValue instanceof CaptureDeviceData) {
            dataCapture = (CaptureDeviceData)objValue;
        }
        return dataCapture;
    }

    public void setLastCaptureAudioData(CaptureDeviceData dataCapture) {
        this.hashProperties.put(KEY_CAPTURE_AUDIO, dataCapture);
    }

    public CaptureDeviceData getLastCaptureVideoData() {
        CaptureDeviceData dataCapture = null;
        Object objValue = this.hashProperties.get(KEY_CAPTURE_VIDEO);
        if (objValue != null && objValue instanceof CaptureDeviceData) {
            dataCapture = (CaptureDeviceData)objValue;
        }
        return dataCapture;
    }

    public void setLastCaptureVideoData(CaptureDeviceData dataCapture) {
        this.hashProperties.put(KEY_CAPTURE_VIDEO, dataCapture);
    }

    public String getLastSaveFileContentType() {
        String strValue = null;
        Object objValue = this.hashProperties.get(KEY_SAVE_FILE_CONTENT);
        if (objValue != null) {
            strValue = objValue.toString();
        }
        return strValue;
    }

    public void setLastSaveFileContentType(String strValue) {
        this.hashProperties.put(KEY_SAVE_FILE_CONTENT, strValue);
    }

    public TrackData getLastSaveFileTrackData(String strTrack) {
        Hashtable hashSaveFile;
        TrackData dataTrack = null;
        Object objValue = this.hashProperties.get(KEY_SAVE_FILE_TRACKS);
        if (objValue != null && objValue instanceof Hashtable) {
            hashSaveFile = (Hashtable)objValue;
        } else {
            hashSaveFile = new Hashtable();
            this.hashProperties.put(KEY_SAVE_FILE_TRACKS, hashSaveFile);
        }
        objValue = hashSaveFile.get(strTrack);
        if (objValue != null && objValue instanceof TrackData) {
            dataTrack = (TrackData)objValue;
        }
        return dataTrack;
    }

    public void setLastSaveFileTrackData(TrackData dataTrack, String strTrack) {
        Hashtable hashSaveFile;
        Object objValue = this.hashProperties.get(KEY_SAVE_FILE_TRACKS);
        if (objValue != null && objValue instanceof Hashtable) {
            hashSaveFile = (Hashtable)objValue;
        } else {
            hashSaveFile = new Hashtable();
            this.hashProperties.put(KEY_SAVE_FILE_TRACKS, hashSaveFile);
        }
        hashSaveFile.put(strTrack, dataTrack);
    }

    public String getLastSaveFileDir() {
        String strValue = null;
        Object objValue = this.hashProperties.get(KEY_SAVE_FILE_DIR);
        if (objValue != null) {
            strValue = objValue.toString();
        }
        return strValue;
    }

    public void setLastSaveFileDir(String strValue) {
        this.hashProperties.put(KEY_SAVE_FILE_DIR, strValue);
    }

    public Enumeration getRecentUrlTypes() {
        Enumeration enumTypes = null;
        Object objValue = this.hashProperties.get(KEY_RECENT_URL);
        if (objValue != null && objValue instanceof Hashtable) {
            Hashtable hashRecentUrls = (Hashtable)objValue;
            enumTypes = hashRecentUrls.keys();
        }
        return enumTypes;
    }

    public Vector getRecentUrls(String strUrlType) {
        Hashtable hashRecentUrls;
        Vector vectorUrls = null;
        Object objValue = this.hashProperties.get(KEY_RECENT_URL);
        if (objValue != null && objValue instanceof Hashtable) {
            hashRecentUrls = (Hashtable)objValue;
        } else {
            hashRecentUrls = new Hashtable();
            this.hashProperties.put(KEY_RECENT_URL, hashRecentUrls);
        }
        objValue = hashRecentUrls.get(strUrlType);
        if (objValue != null && objValue instanceof Vector) {
            vectorUrls = (Vector)objValue;
        }
        return vectorUrls;
    }

    public void addRecentUrls(String strUrlType, String strUrl) {
        Hashtable hashRecentUrls;
        Vector vectorUrls = null;
        Object objValue = this.hashProperties.get(KEY_RECENT_URL);
        if (objValue != null && objValue instanceof Hashtable) {
            hashRecentUrls = (Hashtable)objValue;
        } else {
            hashRecentUrls = new Hashtable();
            this.hashProperties.put(KEY_RECENT_URL, hashRecentUrls);
        }
        objValue = hashRecentUrls.get(strUrlType);
        if (objValue != null && objValue instanceof Vector) {
            vectorUrls = (Vector)objValue;
        } else {
            vectorUrls = new Vector();
            hashRecentUrls.put(strUrlType, vectorUrls);
        }
        if (vectorUrls.contains(strUrl)) {
            vectorUrls.removeElement(strUrl);
        } else if (vectorUrls.size() >= 16) {
            vectorUrls.removeElementAt(15);
        }
        vectorUrls.insertElementAt(strUrl, 0);
    }

    public Point getJMStudioFrameLocation(int nFrameIndex) {
        int nCount;
        int nIndex;
        Point pointValue = null;
        Vector vectorValues = null;
        Object objValue = this.hashProperties.get(KEY_JMSTUDIO_FRAME_POS);
        if (objValue != null && objValue instanceof Vector && (objValue = vectorValues.elementAt(nIndex = nFrameIndex < (nCount = (vectorValues = (Vector)objValue).size()) ? nFrameIndex : nCount - 1)) != null && objValue instanceof Point) {
            pointValue = new Point((Point)objValue);
            pointValue.x += 20 * (nFrameIndex - nIndex);
            pointValue.y += 20 * (nFrameIndex - nIndex);
        }
        if (pointValue == null) {
            pointValue = new Point(20 * nFrameIndex, 20 * nFrameIndex);
        }
        return pointValue;
    }

    public void setJMStudioFrameLocation(Point pointValue, int nFrameIndex) {
        Vector vectorValues = null;
        Object objValue = this.hashProperties.get(KEY_JMSTUDIO_FRAME_POS);
        if (objValue != null && objValue instanceof Vector) {
            vectorValues = (Vector)objValue;
        } else {
            vectorValues = new Vector();
            this.hashProperties.put(KEY_JMSTUDIO_FRAME_POS, vectorValues);
        }
        int nCount = vectorValues.size();
        if (nFrameIndex < nCount) {
            vectorValues.setElementAt(pointValue, nFrameIndex);
        } else {
            vectorValues.addElement(pointValue);
        }
    }

    public boolean getAutoPlay() {
        boolean boolValue = true;
        Object objValue = this.hashProperties.get(KEY_AUTO_PLAY);
        if (objValue != null && objValue instanceof Boolean) {
            boolValue = (Boolean)objValue;
        }
        return boolValue;
    }

    public void setAutoPlay(boolean boolValue) {
        Boolean objValue = new Boolean(boolValue);
        this.hashProperties.put(KEY_AUTO_PLAY, objValue);
    }

    public boolean getAutoLoop() {
        boolean boolValue = true;
        Object objValue = this.hashProperties.get(KEY_AUTO_LOOP);
        if (objValue != null && objValue instanceof Boolean) {
            boolValue = (Boolean)objValue;
        }
        return boolValue;
    }

    public void setAutoLoop(boolean boolValue) {
        Boolean objValue = new Boolean(boolValue);
        this.hashProperties.put(KEY_AUTO_LOOP, objValue);
    }

    public boolean getKeepAspectRatio() {
        boolean boolValue = false;
        Object objValue = this.hashProperties.get(KEY_KEEP_ASPECT);
        if (objValue != null && objValue instanceof Boolean) {
            boolValue = (Boolean)objValue;
        }
        return boolValue;
    }

    public void setKeepAspectRatio(boolean boolValue) {
        Boolean objValue = new Boolean(boolValue);
        this.hashProperties.put(KEY_KEEP_ASPECT, objValue);
    }

    protected void init() throws Exception {
        this.readFile();
    }

    private void readFile() {
        FileInputStream streamFile = null;
        ObjectInputStream streamObject = null;
        try {
            String strPath = System.getProperty("user.home");
            if (strPath != null) {
                nameFileCfg = strPath + File.separator + nameFileCfg;
            }
            streamFile = new FileInputStream(nameFileCfg);
        }
        catch (Exception exception) {
            return;
        }
        try {
            streamObject = new ObjectInputStream(streamFile);
            String strSignatue = streamObject.readUTF();
            String strVersion = streamObject.readUTF();
            Object objValue = streamObject.readObject();
            if (objValue.toString().equals(signatureHashtable)) {
                this.hashProperties = this.readHashtable(streamObject);
            }
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.read"), exception);
        }
        try {
            if (streamObject != null) {
                streamObject.close();
            }
            if (streamFile != null) {
                streamFile.close();
            }
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.close"), exception);
        }
    }

    private Hashtable readHashtable(ObjectInputStream streamObject) throws Exception {
        Hashtable<String, Object> hashRead = new Hashtable<String, Object>();
        int nSize = streamObject.readInt();
        int i2 = 0;
        while (i2 < nSize) {
            String strKey = streamObject.readUTF();
            Object objValue = streamObject.readObject();
            if (objValue != null && objValue.toString().equals(signatureHashtable)) {
                objValue = this.readHashtable(streamObject);
            }
            hashRead.put(strKey, objValue);
            ++i2;
        }
        return hashRead;
    }

    private void saveFile() {
        FileOutputStream streamFile = null;
        ObjectOutputStream streamObject = null;
        try {
            streamFile = new FileOutputStream(nameFileCfg);
            streamObject = new ObjectOutputStream(streamFile);
        }
        catch (Exception exception) {
            System.out.println(JMFI18N.getResource("jmstudio.error.cfgfile.create") + " " + exception.getMessage());
            return;
        }
        try {
            streamObject.writeUTF(signatureFileCfg);
            String strVersion = Manager.getVersion();
            streamObject.writeUTF(strVersion);
            this.writeHashtable(streamObject, this.hashProperties);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.write"), exception);
        }
        try {
            if (streamObject != null) {
                streamObject.close();
            }
            if (streamFile != null) {
                streamFile.close();
            }
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(null, JMFI18N.getResource("jmstudio.error.cfgfile.close"), exception);
        }
    }

    private void writeHashtable(ObjectOutputStream streamObject, Hashtable hashWrite) throws Exception {
        streamObject.writeObject(signatureHashtable);
        int nSize = hashWrite.size();
        streamObject.writeInt(nSize);
        Enumeration enumKeys = hashWrite.keys();
        while (enumKeys.hasMoreElements()) {
            String strKey = (String)enumKeys.nextElement();
            Object objValue = hashWrite.get(strKey);
            if (objValue instanceof Hashtable) {
                streamObject.writeUTF(strKey);
                this.writeHashtable(streamObject, (Hashtable)objValue);
            } else if (!(objValue instanceof Serializable)) {
                System.out.println("Error. Not Serializable object");
            } else {
                streamObject.writeUTF(strKey);
                streamObject.writeObject(objValue);
            }
            streamObject.flush();
        }
    }

    public RtpData createRtpDataObject() {
        RtpData dataRtp = new RtpData();
        return dataRtp;
    }

    public CaptureDeviceData createCaptureDeviceDataObject() {
        CaptureDeviceData dataCaptureDevice = new CaptureDeviceData();
        return dataCaptureDevice;
    }

    public TrackData createTrackDataObject() {
        TrackData dataTrack = new TrackData();
        return dataTrack;
    }

    public class TrackData
    implements Serializable {
        public boolean boolEnable = false;
        public Format format = null;

        private void writeObject(ObjectOutputStream streamOut) throws IOException {
            streamOut.writeBoolean(this.boolEnable);
            if (this.format == null) {
                streamOut.writeBoolean(false);
            } else {
                streamOut.writeBoolean(true);
                streamOut.writeObject(this.format);
            }
        }

        private void readObject(ObjectInputStream streamIn) throws IOException, ClassNotFoundException {
            this.boolEnable = streamIn.readBoolean();
            boolean boolRead = streamIn.readBoolean();
            Object objValue = boolRead ? streamIn.readObject() : null;
            this.format = objValue != null && objValue instanceof Format ? (Format)objValue : null;
        }
    }

    public class CaptureDeviceData
    implements Serializable {
        public boolean boolUse = false;
        public String strDeviceName = null;
        public Format format = null;

        private void writeObject(ObjectOutputStream streamOut) throws IOException {
            streamOut.writeBoolean(this.boolUse);
            if (this.strDeviceName == null) {
                streamOut.writeBoolean(false);
            } else {
                streamOut.writeBoolean(true);
                streamOut.writeUTF(this.strDeviceName);
            }
            if (this.format == null) {
                streamOut.writeBoolean(false);
            } else {
                streamOut.writeBoolean(true);
                streamOut.writeObject(this.format);
            }
        }

        private void readObject(ObjectInputStream streamIn) throws IOException, ClassNotFoundException {
            this.boolUse = streamIn.readBoolean();
            boolean boolRead = streamIn.readBoolean();
            this.strDeviceName = boolRead ? streamIn.readUTF() : null;
            boolRead = streamIn.readBoolean();
            Object objValue = boolRead ? streamIn.readObject() : null;
            this.format = objValue != null && objValue instanceof Format ? (Format)objValue : null;
        }
    }

    public class RtpData
    implements Serializable {
        public String strAddress0 = "0";
        public String strAddress1 = "0";
        public String strAddress2 = "0";
        public String strAddress3 = "0";
        public String strPort = "0";
        public String strTtl = "1";

        private void writeObject(ObjectOutputStream streamOut) throws IOException {
            streamOut.writeUTF(this.strAddress0);
            streamOut.writeUTF(this.strAddress1);
            streamOut.writeUTF(this.strAddress2);
            streamOut.writeUTF(this.strAddress3);
            streamOut.writeUTF(this.strPort);
            streamOut.writeUTF(this.strTtl);
        }

        private void readObject(ObjectInputStream streamIn) throws IOException, ClassNotFoundException {
            this.strAddress0 = streamIn.readUTF();
            this.strAddress1 = streamIn.readUTF();
            this.strAddress2 = streamIn.readUTF();
            this.strAddress3 = streamIn.readUTF();
            this.strPort = streamIn.readUTF();
            this.strTtl = streamIn.readUTF();
        }

        public String toString() {
            return "RtpData address " + this.strAddress0 + "." + this.strAddress1 + "." + this.strAddress2 + "." + this.strAddress3 + "; port " + this.strPort + "; TTL " + this.strTtl;
        }
    }
}

