/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.compression;

import com.sun.j3d.utils.compression.CommandStream;
import com.sun.j3d.utils.compression.CompressionStream;
import com.sun.j3d.utils.compression.CompressionStreamElement;
import com.sun.j3d.utils.compression.HuffmanNode;
import com.sun.j3d.utils.compression.HuffmanTable;
import javax.vecmath.Vector3f;

class CompressionStreamNormal
extends CompressionStreamElement {
    private int u;
    private int v;
    private int specialOctant;
    private int specialSextant;
    private float normalX;
    private float normalY;
    private float normalZ;
    int octant;
    int sextant;
    boolean specialNormal;
    int uAbsolute;
    int vAbsolute;
    private static final int MAX_UV_BITS = 6;
    private static final int MAX_UV_ENTRIES = 64;
    private static final double[][][][] cgNormals = new double[7][65][65][3];
    private static final double MAX_Y_ANG = 0.615479709;
    private static final double UNITY_14 = 16384.0;
    private static final short[][] inverseSine = new short[7][];
    private static final short MAX_SIN_14BIT = 9459;

    CompressionStreamNormal(CompressionStream compressionStream, Vector3f vector3f) {
        this.normalX = vector3f.x;
        this.normalY = vector3f.y;
        this.normalZ = vector3f.z;
        compressionStream.byteCount += 12;
    }

    private static void computeNormals() {
        for (int i = 0; i <= 6; ++i) {
            int n = 1 << i;
            for (int j = 0; j <= n; ++j) {
                for (int k = 0; k <= n; ++k) {
                    if (k + j > n) continue;
                    double d = 0.615479709 * ((double)j / (double)n);
                    double d2 = Math.asin(Math.tan(0.615479709 * ((double)(n - k) / (double)n)));
                    double d3 = Math.cos(d2) * Math.cos(d);
                    double d4 = Math.sin(d);
                    double d5 = Math.sin(d2) * Math.cos(d);
                    int n2 = (int)(d3 *= 16384.0);
                    d3 = n2;
                    int n3 = (int)(d4 *= 16384.0);
                    d4 = n3;
                    int n4 = (int)(d5 *= 16384.0);
                    d5 = n4;
                    CompressionStreamNormal.cgNormals[i][j][k][0] = d3 /= 16384.0;
                    CompressionStreamNormal.cgNormals[i][j][k][1] = d4 /= 16384.0;
                    CompressionStreamNormal.cgNormals[i][j][k][2] = d5 /= 16384.0;
                }
            }
        }
    }

    private static void computeInverseSineTables() {
        int n;
        short[] sArray = new short[65];
        for (n = 0; n <= 64; ++n) {
            sArray[n] = (short)(16384.0 * Math.sin((double)n * 0.615479709 / 64.0));
        }
        for (n = 0; n <= 6; ++n) {
            int n2;
            switch (n) {
                default: {
                    n2 = 64;
                    break;
                }
                case 5: {
                    n2 = 128;
                    break;
                }
                case 4: {
                    n2 = 256;
                    break;
                }
                case 3: {
                    n2 = 512;
                    break;
                }
                case 2: {
                    n2 = 1024;
                    break;
                }
                case 1: {
                    n2 = 2048;
                    break;
                }
                case 0: {
                    n2 = 4096;
                }
            }
            CompressionStreamNormal.inverseSine[n] = new short[9459 / n2 + 1];
            int n3 = 0;
            for (int i = 0; i < inverseSine[n].length; ++i) {
                double d = (double)n3 / 16384.0;
                double d2 = Math.asin(d);
                int n4 = (int)(d2 / 0.615479709 * (double)(1 << n));
                if (n4 > 0 && Math.abs(sArray[n4 << 6 - n] - n3) > Math.abs(sArray[n4 - 1 << 6 - n] - n3)) {
                    --n4;
                }
                if (n4 < 1 << n && Math.abs(sArray[n4 << 6 - n] - n3) > Math.abs(sArray[n4 + 1 << 6 - n] - n3)) {
                    ++n4;
                }
                CompressionStreamNormal.inverseSine[n][i] = (short)n4;
                n3 += n2;
            }
        }
    }

    void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
        int n;
        int n2;
        double d;
        int n3 = compressionStream.normalQuant < 0 ? 0 : (compressionStream.normalQuant > 6 ? 6 : compressionStream.normalQuant);
        double d2 = this.normalX;
        double d3 = this.normalY;
        double d4 = this.normalZ;
        this.octant = 0;
        this.sextant = 0;
        this.u = 0;
        this.v = 0;
        if (d2 < 0.0) {
            this.octant |= 4;
            d2 = -d2;
        }
        if (d3 < 0.0) {
            this.octant |= 2;
            d3 = -d3;
        }
        if (d4 < 0.0) {
            this.octant |= 1;
            d4 = -d4;
        }
        if (d2 < d3) {
            this.sextant |= 1;
            d = d2;
            d2 = d3;
            d3 = d;
        }
        if (d4 < d3) {
            this.sextant |= 2;
            d = d3;
            d3 = d4;
            d4 = d;
        }
        if (d2 < d4) {
            this.sextant |= 4;
            d = d2;
            d2 = d4;
            d4 = d;
        }
        int n4 = (int)(d3 * 16384.0);
        short s = inverseSine[n3][n4 >> 12 - n3];
        int n5 = 0;
        int n6 = 0;
        int n7 = 1 << n3;
        double d5 = -1.0;
        for (n2 = s - 1; n2 < s + 1 && n2 <= n7; ++n2) {
            if (n2 < 0) continue;
            for (n = 0; n <= n7; ++n) {
                double d6;
                if (n + n2 > n7 || !((d6 = d2 * cgNormals[n3][n2][n][0] + d3 * cgNormals[n3][n2][n][1] + d4 * cgNormals[n3][n2][n][2]) > d5)) continue;
                d5 = d6;
                n5 = n;
                n6 = n2;
            }
        }
        this.u = n5 << 6 - n3;
        this.v = n6 << 6 - n3;
        this.specialNormal = false;
        if (this.u == 64 && this.v == 0) {
            if (this.sextant == 0 || this.sextant == 2) {
                this.specialSextant = 6;
                this.specialOctant = (this.octant & 4) != 0 ? 2 : 0;
            } else if (this.sextant == 3 || this.sextant == 1) {
                this.specialSextant = 6;
                this.specialOctant = 4 | ((this.octant & 2) != 0 ? 2 : 0);
            } else if (this.sextant == 5 || this.sextant == 4) {
                this.specialSextant = 7;
                this.specialOctant = (this.octant & 1) != 0 ? 2 : 0;
            }
            this.specialNormal = true;
            this.v = 0;
            this.u = 0;
        } else if (this.u == 0 && this.v == 64) {
            this.specialSextant = 6 | this.octant >> 2;
            this.specialOctant = (this.octant & 3) << 1 | 1;
            this.specialNormal = true;
            this.v = 0;
            this.u = 0;
        }
        n2 = 0;
        n = 0;
        int n8 = 64 >> 6 - n3;
        this.absolute = false;
        if (compressionStream.firstNormal || compressionStream.normalQuantChanged || compressionStream.lastSpecialNormal || this.specialNormal) {
            this.absolute = true;
            compressionStream.firstNormal = false;
            compressionStream.normalQuantChanged = false;
        } else if (compressionStream.lastOctant == this.octant && compressionStream.lastSextant == this.sextant) {
            n2 = n5 - compressionStream.lastU;
            n = n6 - compressionStream.lastV;
        } else if (compressionStream.lastOctant != this.octant && compressionStream.lastSextant == this.sextant && ((this.sextant == 1 || this.sextant == 5) && (compressionStream.lastOctant & 3) == (this.octant & 3) || (this.sextant == 0 || this.sextant == 4) && (compressionStream.lastOctant & 5) == (this.octant & 5) || (this.sextant == 2 || this.sextant == 3) && (compressionStream.lastOctant & 6) == (this.octant & 6))) {
            n2 = n5 - compressionStream.lastU;
            n = -n6 - compressionStream.lastV;
            if (n < -n8) {
                this.absolute = true;
            }
            if (n6 == 0) {
                this.absolute = true;
            }
        } else if (compressionStream.lastOctant == this.octant && compressionStream.lastSextant != this.sextant && (this.sextant == 0 && compressionStream.lastSextant == 4 || this.sextant == 4 && compressionStream.lastSextant == 0 || this.sextant == 1 && compressionStream.lastSextant == 5 || this.sextant == 5 && compressionStream.lastSextant == 1 || this.sextant == 2 && compressionStream.lastSextant == 3 || this.sextant == 3 && compressionStream.lastSextant == 2)) {
            n2 = -n5 - compressionStream.lastU;
            n = n6 - compressionStream.lastV;
            if (n2 < -n8) {
                this.absolute = true;
            }
            if (n5 == 0) {
                this.absolute = true;
            }
        } else if (compressionStream.lastOctant == this.octant && compressionStream.lastSextant != this.sextant && (this.sextant == 0 && compressionStream.lastSextant == 2 || this.sextant == 2 && compressionStream.lastSextant == 0 || this.sextant == 1 && compressionStream.lastSextant == 3 || this.sextant == 3 && compressionStream.lastSextant == 1 || this.sextant == 4 && compressionStream.lastSextant == 5 || this.sextant == 5 && compressionStream.lastSextant == 4)) {
            if (n5 + n6 != n8 && n5 != 0 && n6 != 0) {
                n2 = n8 - n5 - compressionStream.lastU;
                n = n8 - n6 - compressionStream.lastV;
                if (n2 >= n8 || n >= n8) {
                    this.absolute = true;
                }
            } else {
                this.absolute = true;
            }
        } else {
            this.absolute = true;
        }
        if (!this.absolute) {
            this.u = n2 << 6 - n3;
            this.v = n << 6 - n3;
        }
        this.computeLengthShift(this.u, this.v);
        if (this.absolute && this.length > 6) {
            this.length = 6;
        }
        huffmanTable.addNormalEntry(this.length, this.shift, this.absolute);
        compressionStream.lastSextant = this.sextant;
        compressionStream.lastOctant = this.octant;
        compressionStream.lastU = n5;
        compressionStream.lastV = n6;
        compressionStream.lastSpecialNormal = this.specialNormal;
        this.uAbsolute = n5;
        this.vAbsolute = n6;
    }

    void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
        this.outputNormal(huffmanTable, commandStream, 192, 8);
    }

    void outputSubcommand(HuffmanTable huffmanTable, CommandStream commandStream) {
        this.outputNormal(huffmanTable, commandStream, 0, 6);
    }

    private void outputNormal(HuffmanTable huffmanTable, CommandStream commandStream, int n, int n2) {
        HuffmanNode huffmanNode = huffmanTable.getNormalEntry(this.length, this.shift, this.absolute);
        int n3 = huffmanNode.dataLength - huffmanNode.shift;
        int n4 = 0;
        long l = 0L;
        if (this.absolute) {
            n4 = huffmanNode.tagLength + 6;
            l = this.specialNormal ? (long)(huffmanNode.tag << 6 | this.specialSextant << 3 | this.specialOctant) : (long)(huffmanNode.tag << 6 | this.sextant << 3 | this.octant);
        } else {
            n4 = huffmanNode.tagLength;
            l = huffmanNode.tag;
        }
        this.u = this.u >> huffmanNode.shift & (int)lengthMask[n3];
        this.v = this.v >> huffmanNode.shift & (int)lengthMask[n3];
        l = l << 2 * n3 | (long)(this.u << 1 * n3) | (long)(this.v << 0 * n3);
        if ((n4 += 2 * n3) < 6) {
            n |= (int)(l << 6 - n4);
            n4 = 0;
        } else {
            n |= (int)(l >>> n4 - 6);
            n4 -= 6;
        }
        commandStream.addCommand(n, n2, l, n4);
    }

    public String toString() {
        String string = this.specialNormal ? " special normal, sextant " + this.specialSextant + " octant " + this.specialOctant : (this.absolute ? " sextant " + this.sextant + " octant " + this.octant + " u " + this.u + " v " + this.v : " du " + this.u + " dv " + this.v);
        return "normal: " + this.normalX + " " + this.normalY + " " + this.normalZ + "\n" + string + "\n" + " length " + this.length + " shift " + this.shift + (this.absolute ? " absolute" : " relative");
    }

    static {
        CompressionStreamNormal.computeNormals();
        CompressionStreamNormal.computeInverseSineTables();
    }
}

