/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.UnsupportedEncodingException;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.ShortLargeArray;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class StringLargeArray
extends LargeArray {
    private static final long serialVersionUID = -4096759496772248522L;
    private String[] data;
    private ShortLargeArray stringLengths;
    private int maxStringLength;
    private long size;
    private byte[] byteArray;
    private static final String CHARSET = "UTF-8";
    private static final int CHARSET_SIZE = 4;

    public StringLargeArray(long l) {
        this(l, 100);
    }

    public StringLargeArray(long l, int n) {
        this(l, n, true);
    }

    public StringLargeArray(long l, int n, boolean bl) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        if (l <= 0L) {
            throw new IllegalArgumentException(l + " is not a positive long value.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException(n + " is not a positive int value.");
        }
        this.length = l;
        this.size = l * (long)n * 4L;
        this.maxStringLength = n;
        if (l > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.size * this.sizeof);
            if (bl) {
                this.zeroNativeMemory(this.size);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.size, this.sizeof));
            MemoryCounter.increaseCounter(this.size * this.sizeof);
            this.stringLengths = new ShortLargeArray(l);
            this.byteArray = new byte[n * 4];
        } else {
            this.data = new String[(int)l];
        }
    }

    public StringLargeArray(String[] stringArray) {
        this.type = LargeArrayType.STRING;
        this.sizeof = 1L;
        this.length = stringArray.length;
        this.data = stringArray;
    }

    @Override
    public StringLargeArray clone() {
        StringLargeArray stringLargeArray = new StringLargeArray(this.size, this.maxStringLength, false);
        Utilities.arraycopy(this, 0L, stringLargeArray, 0L, this.size);
        return stringLargeArray;
    }

    @Override
    public String get(long l) {
        if (this.ptr != 0L) {
            int n = this.stringLengths.getShort(l);
            long l2 = this.sizeof * l * (long)this.maxStringLength * 4L;
            for (int i = 0; i < n; ++i) {
                this.byteArray[i] = Utilities.UNSAFE.getByte(this.ptr + l2 + this.sizeof * (long)i);
            }
            try {
                return new String(this.byteArray, 0, n, CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
        return this.data[(int)l];
    }

    @Override
    public String getFromNative(long l) {
        int n = this.stringLengths.getShort(l);
        long l2 = this.sizeof * l * (long)this.maxStringLength * 4L;
        for (int i = 0; i < n; ++i) {
            this.byteArray[i] = Utilities.UNSAFE.getByte(this.ptr + l2 + this.sizeof * (long)i);
        }
        try {
            return new String(this.byteArray, 0, n, CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte getByte(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public short getShort(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getInt(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long getLong(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float getFloat(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getDouble(long l) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        return this.data;
    }

    @Override
    public boolean[] getBooleanData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean[] getBooleanData(boolean[] blArray, long l, long l2, long l3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] getByteData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public byte[] getByteData(byte[] byArray, long l, long l2, long l3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public short[] getShortData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public short[] getShortData(short[] sArray, long l, long l2, long l3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] getIntData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int[] getIntData(int[] nArray, long l, long l2, long l3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] getLongData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long[] getLongData(long[] lArray, long l, long l2, long l3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[] getFloatData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public float[] getFloatData(float[] fArray, long l, long l2, long l3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] getDoubleData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double[] getDoubleData(double[] dArray, long l, long l2, long l3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setToNative(long l, Object object) {
        byte[] byArray;
        String string = (String)object;
        if (string.length() > this.maxStringLength) {
            throw new IllegalArgumentException("String  " + string + " is too long.");
        }
        try {
            byArray = string.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        int n = byArray.length;
        if (n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("String  " + string + " is too long.");
        }
        this.stringLengths.setShort(l, (short)n);
        long l2 = this.sizeof * l * (long)this.maxStringLength * 4L;
        for (int i = 0; i < n; ++i) {
            Utilities.UNSAFE.putByte(this.ptr + l2 + this.sizeof * (long)i, byArray[i]);
        }
    }

    @Override
    public void set(long l, Object object) {
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(object + " is not a string.");
        }
        String string = (String)object;
        if (string.length() > this.maxStringLength) {
            throw new IllegalArgumentException("String  " + string + " is too long.");
        }
        if (this.ptr != 0L) {
            byte[] byArray;
            try {
                byArray = string.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return;
            }
            int n = byArray.length;
            if (n > Short.MAX_VALUE) {
                throw new IllegalArgumentException("String  " + string + " is too long.");
            }
            this.stringLengths.setShort(l, (short)n);
            long l2 = this.sizeof * l * (long)this.maxStringLength * 4L;
            for (int i = 0; i < n; ++i) {
                Utilities.UNSAFE.putByte(this.ptr + l2 + this.sizeof * (long)i, byArray[i]);
            }
        } else {
            this.data[(int)l] = string;
        }
    }

    @Override
    public void set_safe(long l, Object object) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException(object + " is not a string.");
        }
        String string = (String)object;
        if (string.length() > this.maxStringLength) {
            throw new IllegalArgumentException("String  " + string + " is too long.");
        }
        if (this.ptr != 0L) {
            byte[] byArray;
            try {
                byArray = string.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return;
            }
            int n = byArray.length;
            if (n > Short.MAX_VALUE) {
                throw new IllegalArgumentException("String  " + string + " is too long.");
            }
            this.stringLengths.setShort(l, (short)n);
            long l2 = this.sizeof * l * (long)this.maxStringLength * 4L;
            for (int i = 0; i < n; ++i) {
                Utilities.UNSAFE.putByte(this.ptr + l2 + this.sizeof * (long)i, byArray[i]);
            }
        } else {
            this.data[(int)l] = string;
        }
    }

    @Override
    public void setBoolean(long l, boolean bl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setByte(long l, byte by) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setShort(long l, short s) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setInt(long l, int n) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setLong(long l, long l2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFloat(long l, float f) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDouble(long l, double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

